/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.server.logic;

import ch.rinn.restrictions.Friend;
import ch.systemsx.cisd.common.collection.IKeyExtractor;
import ch.systemsx.cisd.common.collection.TableMap;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.bo.materiallister.IMaterialLister;
import ch.systemsx.cisd.openbis.generic.server.business.bo.samplelister.ISampleLister;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BasicProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchCriterion;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchField;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityReference;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IAttributeSearchFieldKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ListMaterialCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ListOrSearchSampleCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialAttributeSearchFieldKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SearchCriteriaConnection;
import ch.systemsx.cisd.openbis.generic.shared.basic.utils.GroupByMap;
import ch.systemsx.cisd.openbis.generic.shared.basic.utils.IGroupKeyExtractor;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialTypePropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import ch.systemsx.cisd.openbis.plugin.screening.server.IScreeningBusinessObjectFactory;
import ch.systemsx.cisd.openbis.plugin.screening.server.dataaccess.IScreeningQuery;
import ch.systemsx.cisd.openbis.plugin.screening.server.dataaccess.WellContentQueryResult;
import ch.systemsx.cisd.openbis.plugin.screening.server.logic.AbstractContentLoader;
import ch.systemsx.cisd.openbis.plugin.screening.server.logic.FeatureVectorDatasetLoader;
import ch.systemsx.cisd.openbis.plugin.screening.server.logic.HCSImageDatasetLoader;
import ch.systemsx.cisd.openbis.plugin.screening.server.logic.ReplicateSequenceProvider;
import ch.systemsx.cisd.openbis.plugin.screening.server.logic.ScreeningUtils;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.DatasetImagesReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.DatasetReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ExperimentReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.FeatureVectorValues;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ImageDatasetParameters;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.MaterialSummarySettings;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.NamedFeatureVector;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellContent;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellFeatureVectorReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellLocation;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellReplicaImage;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellSearchCriteria;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.FeatureVectorLoader;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.IHCSFeatureVectorLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.lemnik.eodsql.DataIterator;
import org.apache.commons.lang3.ArrayUtils;

@Friend(toClasses={IScreeningQuery.class})
public class WellContentLoader
extends AbstractContentLoader {
    private static final int MAX_NUMBERS_OF_MATERIALS = 1000;

    public static List<WellContent> loadOnlyMetadata(Session session, IScreeningBusinessObjectFactory businessObjectFactory, IDAOFactory daoFactory, TechId materialId, TechId experimentId) {
        WellContentLoader loader = new WellContentLoader(session, businessObjectFactory, daoFactory, null);
        return loader.loadLocations(materialId, experimentId);
    }

    public static List<WellContent> loadOnlyMetadata(Session session, IScreeningBusinessObjectFactory businessObjectFactory, IDAOFactory daoFactory, TechId materialId) {
        WellContentLoader loader = new WellContentLoader(session, businessObjectFactory, daoFactory, null);
        return loader.loadLocations(materialId);
    }

    public static List<WellContent> loadOnlyMetadataForProject(Session session, IScreeningBusinessObjectFactory businessObjectFactory, IDAOFactory daoFactory, TechId materialId, TechId projectId) {
        WellContentLoader loader = new WellContentLoader(session, businessObjectFactory, daoFactory, null);
        return loader.loadLocationsForProject(materialId, projectId);
    }

    public static List<WellContent> load(Session session, IScreeningBusinessObjectFactory businessObjectFactory, IDAOFactory daoFactory, WellSearchCriteria materialCriteria) {
        long start = System.currentTimeMillis();
        WellContentLoader loader = new WellContentLoader(session, businessObjectFactory, daoFactory, null);
        List<WellContent> locations = loader.loadLocations(materialCriteria);
        operationLog.info((Object)String.format("[%d msec] Load %d locations.", System.currentTimeMillis() - start, locations.size()));
        List<WellContent> withPropsAndDataSets = loader.enrichWithDatasets(locations, materialCriteria.getAnalysisProcedureCriteria());
        List<WellContent> byAnalysisProcedure = loader.filterByAnalysisProcedure(withPropsAndDataSets, materialCriteria.getAnalysisProcedureCriteria());
        List<WellContent> withFeatureVectors = loader.enrichWithFeatureVectors(byAnalysisProcedure);
        return withFeatureVectors;
    }

    public static List<WellReplicaImage> loadWithImages(Session session, IScreeningBusinessObjectFactory businessObjectFactory, IDAOFactory daoFactory, TechId materialId, TechId experimentId, MaterialSummarySettings settings) {
        WellContentLoader loader = new WellContentLoader(session, businessObjectFactory, daoFactory, null);
        List<WellContent> locations = loader.loadLocations(materialId, experimentId);
        locations = loader.enrichWithSingleImageDatasets(locations);
        return WellContentLoader.annotateWithReplicaLabels(locations, settings);
    }

    private static List<WellReplicaImage> annotateWithReplicaLabels(List<WellContent> wellsWithImages, MaterialSummarySettings settings) {
        ReplicateSequenceProvider replicaSequences = new ReplicateSequenceProvider(wellsWithImages, settings.getBiologicalReplicatePropertyTypeCodes());
        ArrayList<WellReplicaImage> wellReplicaImages = new ArrayList<WellReplicaImage>();
        for (WellContent wellContent : wellsWithImages) {
            wellReplicaImages.add(WellContentLoader.annotateWithReplicaLabels(wellContent, replicaSequences));
        }
        return wellReplicaImages;
    }

    private static WellReplicaImage annotateWithReplicaLabels(WellContent wellContent, ReplicateSequenceProvider replicaSequences) {
        int technicalReplicaSequenceNumber = replicaSequences.getTechnicalReplicateSequence(wellContent);
        String biologicalReplicateLabel = replicaSequences.tryGetBiologicalReplicateLabel(wellContent);
        return new WellReplicaImage(wellContent, technicalReplicaSequenceNumber, biologicalReplicateLabel);
    }

    private List<WellContent> enrichWithSingleImageDatasets(List<WellContent> locations) {
        Set<PlateIdentifier> plateIdentifiers = WellContentLoader.extractPlates(locations);
        Map<Long, DatasetImagesReference> plateToDatasetReferenceMap = this.loadPlateToSingleImageDatasetMap(plateIdentifiers);
        return WellContentLoader.enrichWithSingleImageDatasets(locations, plateToDatasetReferenceMap);
    }

    private Map<Long, DatasetImagesReference> loadPlateToSingleImageDatasetMap(Set<PlateIdentifier> plateIdentifiers) {
        HCSImageDatasetLoader datasetsRetriever = this.createImageDatasetsRetriever(plateIdentifiers);
        List<AbstractExternalData> imageDatasets = datasetsRetriever.getImageDatasets();
        if (imageDatasets.isEmpty()) {
            return new HashMap<Long, DatasetImagesReference>();
        }
        return this.createPlateToSingleDatasetReferenceMap(imageDatasets);
    }

    private static List<WellContent> enrichWithSingleImageDatasets(List<WellContent> locations, Map<Long, DatasetImagesReference> plateToDatasetReferenceMap) {
        ArrayList<WellContent> wellContentsWithImageDatasets = new ArrayList<WellContent>();
        for (WellContent wellContent : locations) {
            Long plateId = wellContent.getPlate().getId();
            DatasetImagesReference imageDatasetReference = plateToDatasetReferenceMap.get(plateId);
            if (imageDatasetReference == null) continue;
            WellContent enrichedWellContent = wellContent.cloneWithImageDatasets(imageDatasetReference, null);
            wellContentsWithImageDatasets.add(enrichedWellContent);
        }
        return wellContentsWithImageDatasets;
    }

    private Map<Long, DatasetImagesReference> createPlateToSingleDatasetReferenceMap(Collection<AbstractExternalData> imageDatasets) {
        TableMap plateToDatasetMap = new TableMap(imageDatasets, (IKeyExtractor)new IKeyExtractor<Long, AbstractExternalData>(){

            public Long getKey(AbstractExternalData externalData) {
                return externalData.getSample().getId();
            }
        }, TableMap.UniqueKeyViolationStrategy.KEEP_FIRST);
        return this.asDatasetImagesReferenceMap((TableMap<Long, AbstractExternalData>)plateToDatasetMap);
    }

    private Map<Long, DatasetImagesReference> asDatasetImagesReferenceMap(TableMap<Long, AbstractExternalData> plateToDatasetMap) {
        Map<String, ImageDatasetParameters> imageParams = this.loadImagesReport((Iterable<AbstractExternalData>)plateToDatasetMap);
        HashMap<Long, DatasetImagesReference> plateToDatasetReferenceMap = new HashMap<Long, DatasetImagesReference>();
        for (Long plateId : plateToDatasetMap.keySet()) {
            AbstractExternalData imageDataset = (AbstractExternalData)plateToDatasetMap.getOrDie((Object)plateId);
            DatasetImagesReference imaageDatasetReference = WellContentLoader.createDatasetImagesReference(imageDataset, imageParams);
            plateToDatasetReferenceMap.put(plateId, imaageDatasetReference);
        }
        return plateToDatasetReferenceMap;
    }

    public static List<Material> loadMaterials(Session session, IScreeningBusinessObjectFactory businessObjectFactory, IDAOFactory daoFactory, WellSearchCriteria materialCriteria) {
        Iterable<WellContentQueryResult> locations = new WellContentLoader(session, businessObjectFactory, daoFactory, null).loadRawLocations(materialCriteria);
        Collection<Long> materialIds = WellContentLoader.extractMaterialIds(locations);
        return businessObjectFactory.createMaterialLister(session).list(ListMaterialCriteria.createFromMaterialIds(materialIds), true);
    }

    private static Collection<Long> extractMaterialIds(Iterable<WellContentQueryResult> locations) {
        ArrayList<Long> materialIds = new ArrayList<Long>();
        for (WellContentQueryResult location : locations) {
            materialIds.add(location.material_content_id);
        }
        return materialIds;
    }

    private WellContentLoader(Session session, IScreeningBusinessObjectFactory businessObjectFactory, IDAOFactory daoFactory, IScreeningQuery screeningQuery) {
        super(session, businessObjectFactory, daoFactory, screeningQuery);
    }

    private List<WellContent> enrichWithWellProperties(List<WellContent> locations) {
        HashMap<Long, WellContent> wellContents = new HashMap<Long, WellContent>();
        for (WellContent wellContent : locations) {
            EntityReference wellReference = wellContent.getWell();
            if (wellReference == null) continue;
            wellContents.put(wellReference.getId(), wellContent);
        }
        ListOrSearchSampleCriteria criteria = new ListOrSearchSampleCriteria(wellContents.keySet());
        ISampleLister sampleLister = this.businessObjectFactory.createSampleLister(this.session);
        List wells = sampleLister.list(criteria);
        for (Sample well : wells) {
            WellContent content = (WellContent)wellContents.get(well.getId());
            content.setWellProperties(well.getProperties());
        }
        return locations;
    }

    private List<WellContent> enrichWithDatasets(List<WellContent> locations, WellSearchCriteria.AnalysisProcedureCriteria analysisProcedureCriteria) {
        long start = System.currentTimeMillis();
        FeatureVectorDatasetLoader datasetsRetriever = this.createFeatureVectorDatasetsRetriever(locations, analysisProcedureCriteria);
        List<AbstractExternalData> imageDatasets = datasetsRetriever.getImageDatasets();
        Collection<AbstractExternalData> featureVectorDatasets = datasetsRetriever.getFeatureVectorDatasets();
        operationLog.info((Object)String.format("[%d msec] load datasets (%d image, %d fv).", System.currentTimeMillis() - start, imageDatasets.size(), featureVectorDatasets.size()));
        start = System.currentTimeMillis();
        Map<String, ImageDatasetParameters> imageParams = this.loadImagesReport(imageDatasets);
        operationLog.info((Object)String.format("[%d msec] loadImagesReport", System.currentTimeMillis() - start));
        Collection<AbstractExternalData> childlessImageDatasets = WellContentLoader.selectChildlessImageDatasets(imageDatasets, featureVectorDatasets);
        Map<Long, List<AbstractExternalData>> plateToChildlessImageDatasetMap = WellContentLoader.createPlateToDatasetMap(childlessImageDatasets);
        Map<Long, List<AbstractExternalData>> plateToFeatureVectoreDatasetMap = WellContentLoader.createPlateToDatasetMap(featureVectorDatasets);
        return WellContentLoader.enrichWithDatasets(locations, plateToChildlessImageDatasetMap, plateToFeatureVectoreDatasetMap, imageParams);
    }

    private FeatureVectorDatasetLoader createFeatureVectorDatasetsRetriever(List<WellContent> locations, WellSearchCriteria.AnalysisProcedureCriteria analysisProcedureCriteria) {
        Set<PlateIdentifier> plates = WellContentLoader.extractPlates(locations);
        return this.createFeatureVectorDatasetsRetriever(plates, analysisProcedureCriteria);
    }

    private static Collection<AbstractExternalData> selectChildlessImageDatasets(Collection<AbstractExternalData> imageDatasets, Collection<AbstractExternalData> featureVectorDatasets) {
        ArrayList<AbstractExternalData> childlessImageDatasets = new ArrayList<AbstractExternalData>();
        Set<String> parentImageDatasetCodes = WellContentLoader.extractParentDatasetCodes(featureVectorDatasets);
        for (AbstractExternalData imageDataset : imageDatasets) {
            if (parentImageDatasetCodes.contains(imageDataset.getCode())) continue;
            childlessImageDatasets.add(imageDataset);
        }
        return childlessImageDatasets;
    }

    private static Set<String> extractParentDatasetCodes(Collection<AbstractExternalData> datasets) {
        HashSet<String> codes = new HashSet<String>();
        for (AbstractExternalData dataset : datasets) {
            Collection parents = dataset.getParents();
            if (parents == null) continue;
            for (AbstractExternalData parent : parents) {
                codes.add(parent.getCode());
            }
        }
        return codes;
    }

    private static Set<PlateIdentifier> extractPlates(Collection<WellContent> locations) {
        HashSet<PlateIdentifier> plates = new HashSet<PlateIdentifier>();
        for (WellContent location : locations) {
            plates.add(PlateIdentifier.createFromPermId(location.getPlate().getPermId()));
        }
        return plates;
    }

    private static List<WellContent> enrichWithDatasets(List<WellContent> wellContents, Map<Long, List<AbstractExternalData>> plateToChildlessImageDatasetMap, Map<Long, List<AbstractExternalData>> plateToFeatureVectoreDatasetMap, Map<String, ImageDatasetParameters> imageParams) {
        HashMap<AbstractExternalData, DatasetImagesReference> childlessImageDatasetsToImageReference = new HashMap<AbstractExternalData, DatasetImagesReference>();
        HashMap<AbstractExternalData, DatasetImagesReference> featureVectorDatasetsToImageReference = new HashMap<AbstractExternalData, DatasetImagesReference>();
        HashMap<Long, DatasetImagesReference> plateToSingleImageDatasetReference = new HashMap<Long, DatasetImagesReference>();
        HashMap<AbstractExternalData, DatasetReference> featureVectorDatasetsToReference = new HashMap<AbstractExternalData, DatasetReference>();
        for (WellContent wellContent : wellContents) {
            Long plateId = wellContent.getPlate().getId();
            if (plateToSingleImageDatasetReference.containsKey(plateId)) continue;
            List<AbstractExternalData> featureVectoreDatasets = plateToFeatureVectoreDatasetMap.get(plateId);
            List<AbstractExternalData> childlessImageDatasets = plateToChildlessImageDatasetMap.get(plateId);
            DatasetImagesReference singleImageDatasetOrNull = WellContentLoader.tryGetSingleImageDataset(childlessImageDatasets, imageParams);
            plateToSingleImageDatasetReference.put(plateId, singleImageDatasetOrNull);
            boolean onlySingleImageExists = false;
            if (featureVectoreDatasets != null) {
                for (AbstractExternalData featureVectoreDataset : featureVectoreDatasets) {
                    DatasetReference featureVectoreDatasetReference = ScreeningUtils.createDatasetReference(featureVectoreDataset);
                    featureVectorDatasetsToReference.put(featureVectoreDataset, featureVectoreDatasetReference);
                    DatasetImagesReference imagesDatasetReference = WellContentLoader.tryGetImageDatasetReference(featureVectoreDataset, imageParams);
                    featureVectorDatasetsToImageReference.put(featureVectoreDataset, imagesDatasetReference);
                    if (imagesDatasetReference != null || singleImageDatasetOrNull == null) continue;
                    onlySingleImageExists = true;
                }
            }
            if (childlessImageDatasets == null || onlySingleImageExists) continue;
            for (AbstractExternalData childlessImageDataset : childlessImageDatasets) {
                DatasetImagesReference imagesDatasetReference = WellContentLoader.createDatasetImagesReference(childlessImageDataset, imageParams);
                childlessImageDatasetsToImageReference.put(childlessImageDataset, imagesDatasetReference);
            }
        }
        ArrayList<WellContent> wellsWithDatasets = new ArrayList<WellContent>();
        for (WellContent wellContent : wellContents) {
            Long plateId = wellContent.getPlate().getId();
            ArrayList<WellContent> clonedWellContents = new ArrayList<WellContent>();
            List<AbstractExternalData> featureVectoreDatasets = plateToFeatureVectoreDatasetMap.get(plateId);
            List<AbstractExternalData> childlessImageDatasets = plateToChildlessImageDatasetMap.get(plateId);
            DatasetImagesReference singleImageDatasetOrNull = (DatasetImagesReference)plateToSingleImageDatasetReference.get(plateId);
            boolean singleImageAlreadyUsed = false;
            if (featureVectoreDatasets != null) {
                for (AbstractExternalData featureVectorDataset : featureVectoreDatasets) {
                    DatasetReference featureVectorDatasetReference = (DatasetReference)featureVectorDatasetsToReference.get(featureVectorDataset);
                    DatasetImagesReference imagesDatasetReference = (DatasetImagesReference)featureVectorDatasetsToImageReference.get(featureVectorDataset);
                    if (imagesDatasetReference == null && singleImageDatasetOrNull != null) {
                        imagesDatasetReference = singleImageDatasetOrNull;
                        singleImageAlreadyUsed = true;
                    }
                    clonedWellContents.add(wellContent.cloneWithImageDatasets(imagesDatasetReference, featureVectorDatasetReference));
                }
            }
            if (childlessImageDatasets != null && !singleImageAlreadyUsed) {
                for (AbstractExternalData childlessImageDataset : childlessImageDatasets) {
                    DatasetImagesReference imagesDatasetReference = (DatasetImagesReference)childlessImageDatasetsToImageReference.get(childlessImageDataset);
                    clonedWellContents.add(wellContent.cloneWithImageDatasets(imagesDatasetReference, null));
                }
            }
            if (clonedWellContents.isEmpty()) {
                wellsWithDatasets.add(wellContent);
                continue;
            }
            wellsWithDatasets.addAll(clonedWellContents);
        }
        return wellsWithDatasets;
    }

    private List<WellContent> enrichWithFeatureVectors(List<WellContent> wellsWithDatasets) {
        ArrayList<WellContent> enrichedWellContents = new ArrayList<WellContent>();
        Map<String, List<WellContent>> datastoreToWellContentsMap = this.createAnalysisDatastoreToWellContentsMap(wellsWithDatasets);
        for (Map.Entry<String, List<WellContent>> entry : datastoreToWellContentsMap.entrySet()) {
            String datastoreCode = entry.getKey();
            List<WellContent> oneDatastoreWellContents = entry.getValue();
            if (datastoreCode != null) {
                IHCSFeatureVectorLoader loader = this.businessObjectFactory.createHCSFeatureVectorLoader(datastoreCode);
                oneDatastoreWellContents = this.enrichWithFeatureVectors(oneDatastoreWellContents, loader);
            }
            enrichedWellContents.addAll(oneDatastoreWellContents);
        }
        return enrichedWellContents;
    }

    private Map<String, List<WellContent>> createAnalysisDatastoreToWellContentsMap(List<WellContent> wellContents) {
        return GroupByMap.create(wellContents, (IGroupKeyExtractor)new IGroupKeyExtractor<String, WellContent>(){

            public String getKey(WellContent wellContent) {
                DatasetReference featureVectorDataset = wellContent.tryGetFeatureVectorDataset();
                String datastoreCode = featureVectorDataset == null ? null : featureVectorDataset.getDatastoreCode();
                return datastoreCode;
            }
        }).getMap();
    }

    private List<WellContent> enrichWithFeatureVectors(List<WellContent> wellsWithDatasets, IHCSFeatureVectorLoader loader) {
        List<WellFeatureVectorReference> wellReferences = WellContentLoader.extractWellReferences(wellsWithDatasets);
        FeatureVectorLoader.WellFeatureCollection<FeatureVectorValues> featureVectors = loader.fetchWellFeatureValuesIfPossible(this.session, wellReferences);
        return WellContentLoader.enrichWithFeatureVectors(wellsWithDatasets, featureVectors);
    }

    private static List<WellContent> enrichWithFeatureVectors(List<WellContent> wellsWithDatasets, FeatureVectorLoader.WellFeatureCollection<FeatureVectorValues> featureVectors) {
        FeaturesMetadata featureMetadata = WellContentLoader.extractFeaturesMetadata(featureVectors);
        Map<WellFeatureVectorReference, FeatureVectorValues> refsToFeaturesMap = WellContentLoader.createReferencesToFeaturesMap(featureVectors);
        ArrayList<WellContent> enrichedWellContents = new ArrayList<WellContent>();
        for (WellContent wellContent : wellsWithDatasets) {
            WellContent enrichedWellContent = WellContentLoader.enrichWithFeatureVectors(wellContent, refsToFeaturesMap, featureMetadata);
            enrichedWellContents.add(enrichedWellContent);
        }
        return enrichedWellContents;
    }

    private static FeaturesMetadata extractFeaturesMetadata(FeatureVectorLoader.WellFeatureCollection<FeatureVectorValues> featureVectors) {
        int size = featureVectors.getFeatureCodesAndLabels().size();
        String[] featureCodes = new String[size];
        featureVectors.getFeatureCodes().toArray(featureCodes);
        String[] featureLabels = new String[size];
        featureVectors.getFeatureLabels().toArray(featureLabels);
        return new FeaturesMetadata(featureCodes, featureLabels);
    }

    private static WellContent enrichWithFeatureVectors(WellContent wellsWithDatasets, Map<WellFeatureVectorReference, FeatureVectorValues> refsToFeaturesMap, FeaturesMetadata featureMetadata) {
        FeatureVectorValues featureVectorValues;
        WellFeatureVectorReference ref = WellContentLoader.tryAsWellReference(wellsWithDatasets);
        if (ref != null && (featureVectorValues = refsToFeaturesMap.get(ref)) != null) {
            NamedFeatureVector fv = new NamedFeatureVector(featureVectorValues.getFeatureValues(), featureMetadata.featureCodes, featureMetadata.featureLabels);
            return wellsWithDatasets.cloneWithFeatureVector(fv);
        }
        return wellsWithDatasets;
    }

    private static Map<WellFeatureVectorReference, FeatureVectorValues> createReferencesToFeaturesMap(FeatureVectorLoader.WellFeatureCollection<FeatureVectorValues> featureVectors) {
        HashMap<WellFeatureVectorReference, FeatureVectorValues> map = new HashMap<WellFeatureVectorReference, FeatureVectorValues>();
        for (FeatureVectorValues featureVector : featureVectors.getFeatures()) {
            map.put(featureVector.getFeatureVectorReference(), featureVector);
        }
        return map;
    }

    private static List<WellFeatureVectorReference> extractWellReferences(List<WellContent> wellsWithDatasets) {
        ArrayList<WellFeatureVectorReference> wellRefs = new ArrayList<WellFeatureVectorReference>();
        for (WellContent wellContent : wellsWithDatasets) {
            WellFeatureVectorReference ref = WellContentLoader.tryAsWellReference(wellContent);
            if (ref == null) continue;
            wellRefs.add(ref);
        }
        return wellRefs;
    }

    private static WellFeatureVectorReference tryAsWellReference(WellContent wellContent) {
        WellFeatureVectorReference ref = null;
        WellLocation location = wellContent.tryGetLocation();
        DatasetReference featureVectorDataset = wellContent.tryGetFeatureVectorDataset();
        if (location != null && featureVectorDataset != null) {
            WellLocation pos = new WellLocation(location.getRow(), location.getColumn());
            ref = new WellFeatureVectorReference(featureVectorDataset.getCode(), pos);
        }
        return ref;
    }

    private static DatasetImagesReference tryGetSingleImageDataset(List<AbstractExternalData> childlessImageDatasets, Map<String, ImageDatasetParameters> imageParams) {
        if (childlessImageDatasets != null && childlessImageDatasets.size() == 1) {
            AbstractExternalData singleImageDataset = childlessImageDatasets.get(0);
            return WellContentLoader.createDatasetImagesReference(singleImageDataset, imageParams);
        }
        return null;
    }

    private static DatasetImagesReference tryGetImageDatasetReference(AbstractExternalData featureVectoreDataset, Map<String, ImageDatasetParameters> imageParams) {
        Collection parents = featureVectoreDataset.getParents();
        if (parents != null && parents.size() == 1) {
            AbstractExternalData imageDataset = (AbstractExternalData)parents.iterator().next();
            return WellContentLoader.createDatasetImagesReference(imageDataset, imageParams);
        }
        return null;
    }

    private static DatasetImagesReference createDatasetImagesReference(AbstractExternalData imageDataset, Map<String, ImageDatasetParameters> imageParams) {
        ImageDatasetParameters imageParameters = imageParams.get(imageDataset.getCode());
        if (imageParameters != null) {
            return DatasetImagesReference.create(ScreeningUtils.createDatasetReference(imageDataset), imageParameters);
        }
        operationLog.error((Object)("Cannot find image parameters for dataset: " + imageDataset.getCode() + ". It will not be displayed"));
        return null;
    }

    private static Map<Long, List<AbstractExternalData>> createPlateToDatasetMap(Collection<AbstractExternalData> datasets) {
        HashMap<Long, List<AbstractExternalData>> map = new HashMap<Long, List<AbstractExternalData>>();
        for (AbstractExternalData dataset : datasets) {
            Sample sample = dataset.getSample();
            if (sample == null) continue;
            Long sampleId = sample.getId();
            ArrayList<AbstractExternalData> plateDatasets = (ArrayList<AbstractExternalData>)map.get(sampleId);
            if (plateDatasets == null) {
                plateDatasets = new ArrayList<AbstractExternalData>();
                map.put(sampleId, plateDatasets);
            }
            plateDatasets.add(dataset);
        }
        return map;
    }

    private Map<String, ImageDatasetParameters> loadImagesReport(Iterable<AbstractExternalData> imageDatasets) {
        ArrayList<ImageDatasetParameters> imageParameters = new ArrayList<ImageDatasetParameters>();
        for (AbstractExternalData dataSet : imageDatasets) {
            ImageDatasetParameters imageParams = ScreeningUtils.tryLoadImageParameters(dataSet, this.businessObjectFactory);
            if (imageParams == null) continue;
            imageParameters.add(imageParams);
        }
        return WellContentLoader.asDatasetToParamsMap(imageParameters);
    }

    private static Map<String, ImageDatasetParameters> asDatasetToParamsMap(List<ImageDatasetParameters> imageParameters) {
        HashMap<String, ImageDatasetParameters> map = new HashMap<String, ImageDatasetParameters>();
        for (ImageDatasetParameters params : imageParameters) {
            map.put(params.getDatasetCode(), params);
        }
        return map;
    }

    private List<WellContent> loadLocations(WellSearchCriteria materialCriteria) {
        Iterable<WellContentQueryResult> locations = this.loadRawLocations(materialCriteria);
        return this.convert(locations);
    }

    private Iterable<WellContentQueryResult> loadRawLocations(WellSearchCriteria materialCriteria) {
        DataIterator<WellContentQueryResult> locations;
        WellSearchCriteria.MaterialSearchCriteria materialSearchCriteria = materialCriteria.getMaterialSearchCriteria();
        WellSearchCriteria.ExperimentSearchCriteria experimentCriteria = materialCriteria.getExperimentCriteria();
        WellSearchCriteria.SingleExperimentSearchCriteria experimentOrNull = experimentCriteria.tryGetExperiment();
        BasicProjectIdentifier projectOrNull = experimentCriteria.tryGetProjectIdentifier();
        IScreeningQuery dao = this.getScreeningDAO();
        if (materialSearchCriteria.tryGetMaterialCodesOrProperties() != null) {
            WellSearchCriteria.MaterialSearchCodesCriteria codesCriteria = materialSearchCriteria.tryGetMaterialCodesOrProperties();
            long start = System.currentTimeMillis();
            long[] materialIds = this.findMaterialIds(codesCriteria);
            operationLog.info((Object)String.format("[%d msec] Finding %d materials for criteria '%s'. Result: %s", System.currentTimeMillis() - start, materialIds.length, codesCriteria, WellContentLoader.abbreviate(materialIds, 100)));
            if (materialIds.length > 1000) {
                throw new UserFailureException("More than 1000 materials for criteria '" + codesCriteria + "' are found. Please restrict your search criteria.");
            }
            start = System.currentTimeMillis();
            locations = experimentOrNull != null ? dao.getPlateLocationsForMaterialCodes(materialIds, codesCriteria.getMaterialTypeCodes(), experimentOrNull.getExperimentId().getId()) : (projectOrNull != null ? dao.getPlateLocationsForMaterialCodesInProject(materialIds, codesCriteria.getMaterialTypeCodes(), projectOrNull.getSpaceCode(), projectOrNull.getProjectCode()) : dao.getPlateLocationsForMaterialCodes(materialIds, codesCriteria.getMaterialTypeCodes()));
        } else if (materialSearchCriteria.tryGetMaterialId() != null) {
            long materialId = materialSearchCriteria.tryGetMaterialId().getId();
            locations = experimentOrNull != null ? dao.getPlateLocationsForMaterialId(materialId, experimentOrNull.getExperimentId().getId()) : (projectOrNull != null ? dao.getPlateLocationsForMaterialId(materialId, projectOrNull.getSpaceCode(), projectOrNull.getProjectCode()) : dao.getPlateLocationsForMaterialId(materialId));
        } else {
            throw new IllegalStateException("unhandled materia search criteria: " + materialSearchCriteria);
        }
        return locations;
    }

    private static String abbreviate(long[] values, int limit) {
        int realLimit = limit == -1 ? values.length : Math.min(limit, values.length);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < realLimit; ++i) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(i);
        }
        return sb.toString();
    }

    private long[] findMaterialIds(WellSearchCriteria.MaterialSearchCodesCriteria codesCriteria) {
        List<String> materialTypeCodes = Arrays.asList(codesCriteria.getMaterialTypeCodes());
        List types = this.daoFactory.getEntityTypeDAO(EntityKind.MATERIAL).listEntityTypes();
        HashSet<String> propertyCodes = new HashSet<String>();
        for (MaterialTypePE mt : types) {
            if (!materialTypeCodes.contains(mt.getCode())) continue;
            for (MaterialTypePropertyTypePE mtpt : mt.getMaterialTypePropertyTypes()) {
                propertyCodes.add(mtpt.getPropertyType().getCode());
            }
        }
        DetailedSearchCriteria criteria = new DetailedSearchCriteria();
        ArrayList<DetailedSearchCriterion> listOfCriteria = new ArrayList<DetailedSearchCriterion>();
        for (String value : codesCriteria.getMaterialCodesOrProperties()) {
            listOfCriteria.add(this.createCodeCriterion(value));
            listOfCriteria.add(this.createPropertyCriterion(value, propertyCodes));
        }
        criteria.setCriteria(listOfCriteria);
        criteria.setConnection(SearchCriteriaConnection.MATCH_ANY);
        criteria.setUseWildcardSearchMode(codesCriteria.isExactMatchOnly());
        return ArrayUtils.toPrimitive((Long[])this.daoFactory.getHibernateSearchDAO().searchForEntityIds(this.session.getUserName(), criteria, EntityKind.MATERIAL).toArray(new Long[0]));
    }

    private DetailedSearchCriterion createPropertyCriterion(String value, Set<String> allEntityPropertyCodes) {
        DetailedSearchCriterion criterion = new DetailedSearchCriterion();
        criterion.setField(DetailedSearchField.createAnyPropertyField(new ArrayList<String>(allEntityPropertyCodes)));
        criterion.setValue(value);
        return criterion;
    }

    private DetailedSearchCriterion createCodeCriterion(String code) {
        DetailedSearchCriterion criterion = new DetailedSearchCriterion();
        criterion.setField(DetailedSearchField.createAttributeField((IAttributeSearchFieldKind)MaterialAttributeSearchFieldKind.CODE));
        criterion.setValue(code);
        return criterion;
    }

    private List<WellContent> loadLocations(TechId geneMaterialId, TechId experimentId) {
        DataIterator<WellContentQueryResult> locations = this.getScreeningDAO().getPlateLocationsForMaterialId(geneMaterialId.getId(), experimentId.getId());
        return this.convert((Iterable<WellContentQueryResult>)locations);
    }

    private List<WellContent> loadLocations(TechId geneMaterialId) {
        DataIterator<WellContentQueryResult> locations = this.getScreeningDAO().getPlateLocationsForMaterialId(geneMaterialId.getId());
        return this.convert((Iterable<WellContentQueryResult>)locations);
    }

    private List<WellContent> loadLocationsForProject(TechId geneMaterialId, TechId projectId) {
        DataIterator<WellContentQueryResult> locations = this.getScreeningDAO().getPlateLocationsForMaterialAndProjectIds(geneMaterialId.getId(), projectId.getId());
        return this.convert((Iterable<WellContentQueryResult>)locations);
    }

    private List<WellContent> convert(Iterable<WellContentQueryResult> queryResults) {
        List<WellContent> wellContents = this.convertAndRemoveDuplicateWells(queryResults);
        List<WellContent> withProperties = this.enrichWithWellProperties(wellContents);
        IMaterialLister materialLister = this.businessObjectFactory.createMaterialLister(this.session);
        List<Material> containedMaterials = WellContentLoader.getMaterialsWithDuplicates(withProperties);
        materialLister.enrichWithProperties(containedMaterials);
        return wellContents;
    }

    private static List<Material> getMaterialsWithDuplicates(List<WellContent> wellLocations) {
        ArrayList<Material> materials = new ArrayList<Material>();
        for (WellContent wc : wellLocations) {
            materials.addAll(wc.getMaterialContents());
        }
        return materials;
    }

    private List<WellContent> convertAndRemoveDuplicateWells(Iterable<WellContentQueryResult> queryResults) {
        ArrayList<WellContent> wellContents = new ArrayList<WellContent>();
        HashSet<String> seenWellPermIds = new HashSet<String>();
        for (WellContentQueryResult queryResult : queryResults) {
            String permId = queryResult.well_perm_id;
            if (seenWellPermIds.contains(permId)) continue;
            seenWellPermIds.add(permId);
            wellContents.add(WellContentLoader.convert(queryResult));
        }
        return wellContents;
    }

    private static WellContent convert(WellContentQueryResult well) {
        WellLocation wellLocation = ScreeningUtils.tryCreateLocationFromMatrixCoordinate(well.well_code);
        EntityReference wellReference = new EntityReference(well.well_id, well.well_code, well.well_type_code, ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind.SAMPLE, well.well_perm_id);
        EntityReference plate = new EntityReference(well.plate_id, well.plate_code, well.plate_type_code, ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind.SAMPLE, well.getPlatePermId());
        return new WellContent(wellLocation, wellReference, plate, WellContentLoader.convertExperiment(well));
    }

    private static ExperimentReference convertExperiment(WellContentQueryResult loc) {
        return new ExperimentReference(loc.exp_id, loc.exp_perm_id, loc.exp_code, loc.exp_type_code, loc.proj_code, loc.space_code);
    }

    private List<WellContent> filterByAnalysisProcedure(List<WellContent> wells, WellSearchCriteria.AnalysisProcedureCriteria criteria) {
        if (criteria.isAllProcedures()) {
            return wells;
        }
        ArrayList<WellContent> filtered = new ArrayList<WellContent>();
        for (WellContent well : wells) {
            String analysisProcedureCode = well.tryGetFeatureVectorDataset() == null ? null : well.tryGetFeatureVectorDataset().getAnalysisProcedure();
            if (!criteria.matches(analysisProcedureCode)) continue;
            filtered.add(well);
        }
        return filtered;
    }

    private static class FeaturesMetadata {
        private final String[] featureCodes;
        private final String[] featureLabels;

        public FeaturesMetadata(String[] featureCodes, String[] featureLabels) {
            this.featureCodes = featureCodes;
            this.featureLabels = featureLabels;
        }
    }
}

