/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.server.logic;

import ch.systemsx.cisd.common.collection.IKeyExtractor;
import ch.systemsx.cisd.common.collection.TableMap;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.utils.GroupByMap;
import ch.systemsx.cisd.openbis.generic.shared.basic.utils.IGroupKeyExtractor;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.plugin.screening.server.IScreeningBusinessObjectFactory;
import ch.systemsx.cisd.openbis.plugin.screening.server.dataaccess.IScreeningQuery;
import ch.systemsx.cisd.openbis.plugin.screening.server.logic.AbstractContentLoader;
import ch.systemsx.cisd.openbis.plugin.screening.server.logic.FeatureVectorDatasetLoader;
import ch.systemsx.cisd.openbis.plugin.screening.server.logic.ScreeningUtils;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.DatasetReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.FeatureValue;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.FeatureVectorValues;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellSearchCriteria;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.FeatureVectorLoader;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.IHCSFeatureVectorLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.time.StopWatch;

public class WellFeatureCollectionLoader
extends AbstractContentLoader {
    public WellFeatureCollectionLoader(Session session, IScreeningBusinessObjectFactory businessObjectFactory, IDAOFactory daoFactory, IScreeningQuery screeningQuery) {
        super(session, businessObjectFactory, daoFactory, screeningQuery);
    }

    public FeatureVectorLoader.WellFeatureCollection<FeatureVectorValues> tryLoadWellSingleFeatureVectors(Set<PlateIdentifier> plates, List<String> featureCodes, WellSearchCriteria.AnalysisProcedureCriteria analysisProcedureCriteria) {
        StopWatch watch = new StopWatch();
        watch.start();
        FeatureVectorDatasetLoader datasetsRetriever = this.createFeatureVectorDatasetsRetriever(plates, analysisProcedureCriteria);
        Collection<AbstractExternalData> featureVectorDatasets = datasetsRetriever.getFeatureVectorDatasets();
        if (featureVectorDatasets.isEmpty()) {
            return null;
        }
        List<DatasetReference> datasetPerPlate = WellFeatureCollectionLoader.chooseSingleDatasetForPlate(new ArrayList<AbstractExternalData>(featureVectorDatasets));
        FeatureVectorLoader.WellFeatureCollection features = new FeatureVectorRetriever(featureCodes).tryFetch(datasetPerPlate);
        operationLog.info((Object)String.format("[%d msec] Fetching %d feature vectors from %d datasets.", watch.getTime(), features == null ? 0 : features.getFeatures().size(), featureVectorDatasets.size()));
        return features;
    }

    private static List<DatasetReference> chooseSingleDatasetForPlate(List<AbstractExternalData> datasets) {
        Collections.sort(datasets);
        TableMap plateToDatasetMap = new TableMap(datasets, (IKeyExtractor)new IKeyExtractor<String, AbstractExternalData>(){

            public String getKey(AbstractExternalData externalData) {
                Sample plate = externalData.getSample();
                return plate != null ? plate.getPermId() : null;
            }
        }, TableMap.UniqueKeyViolationStrategy.KEEP_FIRST);
        ArrayList<DatasetReference> datasetPerPlate = new ArrayList<DatasetReference>();
        for (String platePermId : plateToDatasetMap.keySet()) {
            if (platePermId == null) continue;
            AbstractExternalData dataset = (AbstractExternalData)plateToDatasetMap.getOrDie((Object)platePermId);
            DatasetReference datasetReference = ScreeningUtils.createDatasetReference(dataset);
            datasetPerPlate.add(datasetReference);
        }
        return datasetPerPlate;
    }

    public static float[] asFeatureVectorValues(FeatureVectorValues featureVector) {
        FeatureValue[] featureValues = featureVector.getFeatureValues();
        float[] values = new float[featureValues.length];
        int i = 0;
        for (FeatureValue featureValue : featureValues) {
            values[i++] = WellFeatureCollectionLoader.asFloat(featureValue);
        }
        return values;
    }

    private static float asFloat(FeatureValue featureValue) {
        return featureValue.isFloat() ? featureValue.asFloat() : Float.NaN;
    }

    private class FeatureVectorRetriever {
        private final List<String> featureCodes;

        public FeatureVectorRetriever(List<String> featureCodes) {
            this.featureCodes = featureCodes;
        }

        private FeatureVectorLoader.WellFeatureCollection<FeatureVectorValues> tryFetch(Collection<DatasetReference> datasets) {
            assert (datasets.size() > 0) : "No feature vector datasets specified.";
            GroupByMap datastoreToDatasetsMap = GroupByMap.create(datasets, (IGroupKeyExtractor)new IGroupKeyExtractor<String, DatasetReference>(){

                public String getKey(DatasetReference datasetReference) {
                    return datasetReference.getDatastoreCode();
                }
            });
            FeatureVectorLoader.WellFeatureCollection<FeatureVectorValues> allFeatures = null;
            for (String datastoreCode : datastoreToDatasetsMap.getKeys()) {
                List datasetsForDatastore = datastoreToDatasetsMap.getOrDie((Object)datastoreCode);
                FeatureVectorLoader.WellFeatureCollection<FeatureVectorValues> features = this.fetchFromDatastore(datastoreCode, datasetsForDatastore);
                if (allFeatures == null) {
                    allFeatures = features;
                    continue;
                }
                this.mergeFeatures(allFeatures, features);
            }
            return allFeatures;
        }

        private void mergeFeatures(FeatureVectorLoader.WellFeatureCollection<FeatureVectorValues> allFeatures, FeatureVectorLoader.WellFeatureCollection<FeatureVectorValues> features) {
            if (!allFeatures.getFeatureCodes().equals(features.getFeatureCodes())) {
                throw new IllegalStateException("Cannot merge feature vectors from different datastores because the have different set of features: '" + allFeatures.getFeatureCodes() + "' and '" + features.getFeatureCodes() + "'.");
            }
            allFeatures.getFeatures().addAll(features.getFeatures());
        }

        private FeatureVectorLoader.WellFeatureCollection<FeatureVectorValues> fetchFromDatastore(String datastoreCode, List<DatasetReference> datasets) {
            IHCSFeatureVectorLoader loader = WellFeatureCollectionLoader.this.businessObjectFactory.createHCSFeatureVectorLoader(datastoreCode);
            return loader.fetchDatasetFeatureValues(WellFeatureCollectionLoader.this.session, this.extractCodes(datasets), this.featureCodes);
        }

        private List<String> extractCodes(List<DatasetReference> datasets) {
            Collection codes = CollectionUtils.collect(datasets, (Transformer)new Transformer<DatasetReference, String>(){

                public String transform(DatasetReference element) {
                    return element.getCode();
                }
            });
            return new LinkedList<String>(codes);
        }
    }
}

