/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.server.logic;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.openbis.generic.shared.basic.utils.GroupByMap;
import ch.systemsx.cisd.openbis.generic.shared.basic.utils.IGroupKeyExtractor;
import ch.systemsx.cisd.openbis.plugin.screening.server.logic.dto.IWellData;
import ch.systemsx.cisd.openbis.plugin.screening.server.logic.dto.MaterialIdFeatureVectorSummary;
import ch.systemsx.cisd.openbis.plugin.screening.server.logic.dto.WellData;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.MaterialReplicaSummaryAggregationType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class WellReplicaSummaryCalculator {
    private final GroupByMap<Long, IWellData> replicaToWellDataMap;
    private final MaterialReplicaSummaryAggregationType aggregationType;
    private final int numberOfFeatures;

    public static List<MaterialIdFeatureVectorSummary> calculateReplicasFeatureVectorSummaries(List<? extends IWellData> wellDataList, MaterialReplicaSummaryAggregationType aggregationType, boolean calculateDeviations) {
        WellReplicaSummaryCalculator.validate(wellDataList);
        WellReplicaSummaryCalculator calculator = new WellReplicaSummaryCalculator(wellDataList, aggregationType);
        List<MaterialIdFeatureVectorSummary> summaries = calculator.calculateReplicasFeatureVectorSummaries(calculateDeviations);
        return summaries;
    }

    public static float[] calculateSummaryFeatureVector(List<? extends IWellData> techicalReplicaWells, MaterialReplicaSummaryAggregationType aggregationType) {
        WellReplicaSummaryCalculator.validate(techicalReplicaWells);
        int numberOfFeatures = WellReplicaSummaryCalculator.getNumberOfFeatures(techicalReplicaWells);
        return WellReplicaSummaryCalculator.calculateSummaryFeatureVector(techicalReplicaWells, aggregationType, numberOfFeatures, false).getAggregates();
    }

    private static void validate(List<? extends IWellData> wellDataList) {
        int numberOfFeatures = WellReplicaSummaryCalculator.getNumberOfFeatures(wellDataList);
        for (IWellData iWellData : wellDataList) {
            if (iWellData.getFeatureVector() == null) {
                throw new IllegalStateException(String.format("No feature vector found for material " + iWellData.getReplicaMaterialId(), new Object[0]));
            }
            if (iWellData.getFeatureVector().length == numberOfFeatures) continue;
            throw new IllegalStateException(String.format("Each well should have the same amount features, but some have %d and some have %d.", numberOfFeatures, iWellData.getFeatureVector().length));
        }
    }

    private WellReplicaSummaryCalculator(List<? extends IWellData> wellDataList, MaterialReplicaSummaryAggregationType aggregationType) {
        this.numberOfFeatures = WellReplicaSummaryCalculator.getNumberOfFeatures(wellDataList);
        this.aggregationType = aggregationType;
        this.replicaToWellDataMap = GroupByMap.create(wellDataList, (IGroupKeyExtractor)new IGroupKeyExtractor<Long, IWellData>(){

            public Long getKey(IWellData wellData) {
                return wellData.getReplicaMaterialId();
            }
        });
    }

    private List<MaterialIdFeatureVectorSummary> calculateReplicasFeatureVectorSummaries(boolean calculateDeviations) {
        Map<Long, SummaryFeatureVector> replicaToSummaryMap = this.calculateSummaryFeatures(calculateDeviations);
        Map<Long, int[]> ranks = WellReplicaSummaryCalculator.calculateRanks(replicaToSummaryMap, this.numberOfFeatures);
        ArrayList<MaterialIdFeatureVectorSummary> summaries = new ArrayList<MaterialIdFeatureVectorSummary>();
        Set replicaIds = this.replicaToWellDataMap.getKeys();
        int numberOfReplicas = replicaIds.size();
        for (Long replicaId : replicaIds) {
            SummaryFeatureVector summaryFeatures = replicaToSummaryMap.get(replicaId);
            MaterialIdFeatureVectorSummary summary = new MaterialIdFeatureVectorSummary(replicaId, summaryFeatures.getAggregates(), summaryFeatures.tryGetDeviations(), ranks.get(replicaId), numberOfReplicas);
            summaries.add(summary);
        }
        return summaries;
    }

    @Private
    static Map<Long, int[]> calculateRanks(Map<Long, SummaryFeatureVector> replicaToSummaryMap, int numberOfFeatures) {
        List<IWellData> summaryWellDataList = WellReplicaSummaryCalculator.createSummaryWellData(replicaToSummaryMap);
        Map<Long, int[]> ranks = WellReplicaSummaryCalculator.createEmptyRankingMap(replicaToSummaryMap, numberOfFeatures);
        for (int featureIx = 0; featureIx < numberOfFeatures; ++featureIx) {
            WellReplicaSummaryCalculator.sortBySelectedFeature(summaryWellDataList, featureIx);
            Float prevValue = null;
            int rank = 0;
            for (int i = 0; i < summaryWellDataList.size(); ++i) {
                IWellData rankWellData = summaryWellDataList.get(i);
                float value = WellReplicaSummaryCalculator.getFeatureValue(rankWellData, featureIx);
                if (WellReplicaSummaryCalculator.isDifferent(prevValue, value)) {
                    rank = i + 1;
                }
                int[] replicaRanks = ranks.get(rankWellData.getReplicaMaterialId());
                replicaRanks[featureIx] = rank;
                prevValue = Float.valueOf(value);
            }
        }
        return ranks;
    }

    private static boolean isDifferent(Float prevValueOrNull, float value) {
        if (prevValueOrNull == null) {
            return true;
        }
        float prevValue = prevValueOrNull.floatValue();
        if (WellReplicaSummaryCalculator.isNumerical(value) != WellReplicaSummaryCalculator.isNumerical(prevValue)) {
            return true;
        }
        if (!WellReplicaSummaryCalculator.isNumerical(value)) {
            return false;
        }
        return value != prevValue;
    }

    private static List<IWellData> createSummaryWellData(Map<Long, SummaryFeatureVector> replicaToSummaryMap) {
        ArrayList<IWellData> summaryWellDataList = new ArrayList<IWellData>();
        for (Map.Entry<Long, SummaryFeatureVector> entry : replicaToSummaryMap.entrySet()) {
            Long replicaId = entry.getKey();
            float[] aggregates = entry.getValue().getAggregates();
            WellData summaryWellData = new WellData(replicaId, aggregates, null);
            summaryWellDataList.add(summaryWellData);
        }
        return summaryWellDataList;
    }

    private static Map<Long, int[]> createEmptyRankingMap(Map<Long, SummaryFeatureVector> replicaToSummaryMap, int numberOfFeatures) {
        HashMap<Long, int[]> ranks = new HashMap<Long, int[]>();
        Set<Long> replicaIds = replicaToSummaryMap.keySet();
        for (Long replicaId : replicaIds) {
            ranks.put(replicaId, new int[numberOfFeatures]);
        }
        return ranks;
    }

    private Map<Long, SummaryFeatureVector> calculateSummaryFeatures(boolean calculateDeviations) {
        HashMap<Long, SummaryFeatureVector> replicaToSummaryMap = new HashMap<Long, SummaryFeatureVector>();
        Set replicaIds = this.replicaToWellDataMap.getKeys();
        for (Long replicaId : replicaIds) {
            List replicaWells = this.replicaToWellDataMap.getOrDie((Object)replicaId);
            SummaryFeatureVector summary = WellReplicaSummaryCalculator.calculateSummaryFeatureVector(replicaWells, this.aggregationType, this.numberOfFeatures, calculateDeviations);
            replicaToSummaryMap.put(replicaId, summary);
        }
        return replicaToSummaryMap;
    }

    private static SummaryFeatureVector calculateSummaryFeatureVector(List<? extends IWellData> replicaWells, MaterialReplicaSummaryAggregationType aggregationType, int numberOfFeatures, boolean calculateDeviations) {
        switch (aggregationType) {
            case MEDIAN: {
                return WellReplicaSummaryCalculator.calculateMedianVector(replicaWells, numberOfFeatures, calculateDeviations);
            }
        }
        throw new IllegalStateException("Unhandled aggregation type: " + aggregationType);
    }

    private static SummaryFeatureVector calculateMedianVector(List<? extends IWellData> replicaWells, int numberOfFeatures, boolean calculateDeviations) {
        float[] medians = new float[numberOfFeatures];
        for (int featureIx = 0; featureIx < numberOfFeatures; ++featureIx) {
            medians[featureIx] = WellReplicaSummaryCalculator.calculateMedian(replicaWells, featureIx);
        }
        float[] deviations = null;
        if (calculateDeviations) {
            deviations = WellReplicaSummaryCalculator.calculateDeviations(replicaWells, numberOfFeatures, medians);
        }
        return new SummaryFeatureVector(medians, deviations);
    }

    private static float[] calculateDeviations(List<? extends IWellData> replicaWells, int numberOfFeatures, float[] medians) {
        float[] deviations = new float[numberOfFeatures];
        for (int featureIx = 0; featureIx < numberOfFeatures; ++featureIx) {
            float median = medians[featureIx];
            deviations[featureIx] = WellReplicaSummaryCalculator.calculateMedianAbsoluteDeviation(median, replicaWells, featureIx);
        }
        return deviations;
    }

    private static void sortBySelectedFeature(List<IWellData> replicaWells, int featureIx) {
        Collections.sort(replicaWells, WellReplicaSummaryCalculator.createSelectedFeatureAscendingComparator(featureIx));
    }

    private static int getNumberOfFeatures(List<? extends IWellData> replicaWells) {
        if (replicaWells.size() == 0) {
            return 0;
        }
        return replicaWells.get(0).getFeatureVector().length;
    }

    @Private
    static float calculateMedian(List<? extends IWellData> replicaWells, int featureIx) {
        ArrayList<Float> featureValues = new ArrayList<Float>();
        for (IWellData iWellData : replicaWells) {
            float featureValue = WellReplicaSummaryCalculator.getFeatureValue(iWellData, featureIx);
            if (!WellReplicaSummaryCalculator.isNumerical(featureValue)) continue;
            featureValues.add(Float.valueOf(featureValue));
        }
        return WellReplicaSummaryCalculator.calculateMedian(featureValues);
    }

    private static float calculateMedian(List<Float> numbers) {
        if (numbers.isEmpty()) {
            return Float.NaN;
        }
        Collections.sort(numbers);
        int size = numbers.size();
        int index = size / 2;
        float median = numbers.get(index).floatValue();
        if (size % 2 == 0) {
            median = (median + numbers.get(index - 1).floatValue()) / 2.0f;
        }
        return median;
    }

    private static float getFeatureValue(IWellData wellData, int featureIx) {
        return wellData.getFeatureVector()[featureIx];
    }

    @Private
    static float calculateMedianAbsoluteDeviation(float median, List<? extends IWellData> replicaWells, int featureIx) {
        if (!WellReplicaSummaryCalculator.isNumerical(median)) {
            return Float.NaN;
        }
        ArrayList<Float> absDeviations = new ArrayList<Float>();
        for (IWellData iWellData : replicaWells) {
            float value = WellReplicaSummaryCalculator.getFeatureValue(iWellData, featureIx);
            if (!WellReplicaSummaryCalculator.isNumerical(value)) continue;
            float absDev = Math.abs(value - median);
            absDeviations.add(Float.valueOf(absDev));
        }
        return WellReplicaSummaryCalculator.calculateMedian(absDeviations);
    }

    private static boolean isNumerical(float value) {
        return !Float.isInfinite(value) && !Float.isNaN(value);
    }

    private static Comparator<IWellData> createSelectedFeatureAscendingComparator(final int featureIx) {
        return new Comparator<IWellData>(){

            @Override
            public int compare(IWellData w1, IWellData w2) {
                float v1 = WellReplicaSummaryCalculator.getFeatureValue(w1, featureIx);
                float v2 = WellReplicaSummaryCalculator.getFeatureValue(w2, featureIx);
                if (WellReplicaSummaryCalculator.isNumerical(v1) != WellReplicaSummaryCalculator.isNumerical(v2)) {
                    return WellReplicaSummaryCalculator.isNumerical(v1) ? -1 : 1;
                }
                return Float.compare(v1, v2);
            }
        };
    }

    @Private
    static class SummaryFeatureVector {
        private final float[] aggregate;
        private final float[] deviationsOrNull;

        public SummaryFeatureVector(float[] aggregate, float[] deviationsOrNull) {
            this.aggregate = aggregate;
            this.deviationsOrNull = deviationsOrNull;
        }

        public float[] getAggregates() {
            return this.aggregate;
        }

        public float[] tryGetDeviations() {
            return this.deviationsOrNull;
        }
    }
}

