/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto;

import ch.systemsx.cisd.base.annotation.JsonObject;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PermanentIdentifier;
import com.fasterxml.jackson.annotation.JsonIgnore;

@JsonObject(value="ExperimentIdentifier")
public class ExperimentIdentifier
extends PermanentIdentifier {
    private static final long serialVersionUID = 1L;
    private String spaceCode;
    private String projectCode;
    private String experimentCode;

    public static ExperimentIdentifier createFromAugmentedCode(String augmentedCode) throws IllegalArgumentException {
        String[] splitted = augmentedCode.split("/");
        if (splitted.length == 2 && splitted[0].length() > 0) {
            return new ExperimentIdentifier(splitted[1], splitted[0], null, null);
        }
        if (splitted.length != 4 || splitted[0].length() != 0) {
            throw new IllegalArgumentException("Augmented code '" + augmentedCode + "' needs to be either of the form '/SPACE/PROJECT/EXPERIMENT' or 'PROJECT/EXPERIMENT'.");
        }
        return new ExperimentIdentifier(splitted[3], splitted[2], splitted[1], null);
    }

    public static ExperimentIdentifier createFromPermId(String permId) throws IllegalArgumentException {
        return new ExperimentIdentifier(null, null, null, permId);
    }

    public ExperimentIdentifier(String experimentCode, String projectCode, String spaceCode, String permId) {
        super(permId);
        this.spaceCode = spaceCode;
        this.projectCode = projectCode;
        this.experimentCode = experimentCode;
    }

    public String getSpaceCode() {
        return this.spaceCode;
    }

    public String getProjectCode() {
        return this.projectCode;
    }

    public String getExperimentCode() {
        return this.experimentCode;
    }

    @JsonIgnore
    public String getAugmentedCode() {
        if (this.spaceCode != null) {
            return "/" + this.spaceCode + "/" + this.projectCode + "/" + this.experimentCode;
        }
        return this.projectCode + "/" + this.experimentCode;
    }

    @Override
    public String toString() {
        if (this.getPermId() == null) {
            return this.getAugmentedCode();
        }
        return this.getAugmentedCode() + " [" + this.getPermId() + "]";
    }

    private ExperimentIdentifier() {
        super(null);
    }

    private void setSpaceCode(String spaceCode) {
        this.spaceCode = spaceCode;
    }

    private void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    private void setExperimentCode(String experimentCode) {
        this.experimentCode = experimentCode;
    }
}

