/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto;

import ch.systemsx.cisd.base.annotation.JsonObject;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;

@JsonObject(value="Geometry")
public final class Geometry
implements Serializable {
    public static final Geometry GEOMETRY_96_8X12 = new Geometry(12, 8);
    public static final Geometry GEOMETRY_384_16X24 = new Geometry(24, 16);
    public static final Geometry GEOMETRY_1536_32X48 = new Geometry(48, 32);
    private static final long serialVersionUID = 1L;
    private int width;
    private int height;

    public static Geometry createFromCartesianDimensions(int maxX, int maxY) {
        return new Geometry(maxX, maxY);
    }

    public static Geometry createFromCartesianDimensions(int[] cartesianDims) {
        assert (cartesianDims != null);
        assert (cartesianDims.length == 2);
        return new Geometry(cartesianDims[0], cartesianDims[1]);
    }

    public static Geometry createFromRowColDimensions(int numberOfRows, int numberOfColumns) {
        return new Geometry(numberOfColumns, numberOfRows);
    }

    public static Geometry createFromPlateGeometryString(String plateGeometryStr) {
        int lastIndexOfUnderscore = plateGeometryStr.lastIndexOf(95);
        int lastIndexOfX = plateGeometryStr.lastIndexOf(88);
        if (lastIndexOfUnderscore < 0 || lastIndexOfX < 0) {
            throw new IllegalArgumentException("Invalid plate geometry string '" + plateGeometryStr + "'");
        }
        try {
            int numberOfRows = Integer.parseInt(plateGeometryStr.substring(lastIndexOfUnderscore + 1, lastIndexOfX));
            int numberOfColumns = Integer.parseInt(plateGeometryStr.substring(lastIndexOfX + 1));
            return Geometry.createFromRowColDimensions(numberOfRows, numberOfColumns);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Invalid plate geometry string '" + plateGeometryStr + "'");
        }
    }

    private Geometry(int width, int height) {
        if (width < 0) {
            throw new IllegalArgumentException("Negative width: " + width);
        }
        if (height < 0) {
            throw new IllegalArgumentException("Negative height: " + height);
        }
        this.width = width;
        this.height = height;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    @JsonIgnore
    public final int getNumberOfColumns() {
        return this.width;
    }

    @JsonIgnore
    public final int getNumberOfRows() {
        return this.height;
    }

    @JsonIgnore
    public final int getDimX() {
        return this.width;
    }

    @JsonIgnore
    public final int getDimY() {
        return this.height;
    }

    @JsonIgnore
    public final int[] getCartesianDimensions() {
        return new int[]{this.width, this.height};
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Geometry)) {
            return false;
        }
        Geometry geometry = (Geometry)obj;
        return geometry.width == this.width && geometry.height == this.height;
    }

    public int hashCode() {
        return 37 * this.width + this.height;
    }

    public String toPlateGeometryStr() {
        return this.height * this.width + "_" + this.height + "X" + this.width;
    }

    public String toString() {
        return "{" + this.width + "," + this.height + "}";
    }

    private Geometry() {
    }

    private void setWidth(int width) {
        if (width < 0) {
            throw new IllegalArgumentException("Negative width: " + width);
        }
        this.width = width;
    }

    private void setHeight(int height) {
        if (height < 0) {
            throw new IllegalArgumentException("Negative height: " + height);
        }
        this.height = height;
    }
}

