/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto;

import ch.systemsx.cisd.base.annotation.JsonObject;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PermanentIdentifier;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonObject(value="PlateIdentifier")
public class PlateIdentifier
extends PermanentIdentifier {
    private static final long serialVersionUID = 1L;
    private String plateCode;
    @JsonProperty
    private String spaceCodeOrNull;
    private String projectCodeOrNull;

    public static PlateIdentifier createFromAugmentedCode(String augmentedCode) throws IllegalArgumentException {
        String[] splitted = augmentedCode.split("/");
        if (splitted.length == 1) {
            return new PlateIdentifier(splitted[0], null);
        }
        if (splitted.length == 2 && splitted[0].length() == 0) {
            return new PlateIdentifier(splitted[1], "");
        }
        if (splitted.length == 4) {
            return new PlateIdentifier(splitted[3], splitted[1], splitted[2], null);
        }
        if (splitted.length != 3 || splitted[0].length() != 0) {
            throw new IllegalArgumentException("Augmented code '" + augmentedCode + "' needs to be of the form '/SPACE/PROJECT/PLATE', '/SPACE/PLATE', '/PLATE' or 'PLATE'.");
        }
        return new PlateIdentifier(splitted[2], splitted[1]);
    }

    public static PlateIdentifier createFromPermId(String permId) throws IllegalArgumentException {
        return new PlateIdentifier(null, null, permId);
    }

    protected PlateIdentifier(String plateCode, String spaceCodeOrNull) {
        this(plateCode, spaceCodeOrNull, null);
    }

    public PlateIdentifier(String plateCode, String spaceCodeOrNull, String permId) {
        this(plateCode, spaceCodeOrNull, null, permId);
    }

    public PlateIdentifier(String plateCode, String spaceCodeOrNull, String projectCodeOrNull, String permId) {
        super(permId);
        this.plateCode = plateCode;
        this.spaceCodeOrNull = spaceCodeOrNull;
        this.projectCodeOrNull = projectCodeOrNull;
    }

    public String getPlateCode() {
        return this.plateCode;
    }

    public String tryGetSpaceCode() {
        return this.spaceCodeOrNull;
    }

    public String tryGetProjectCode() {
        return this.projectCodeOrNull;
    }

    @JsonIgnore
    public String getAugmentedCode() {
        if (this.projectCodeOrNull != null) {
            return "/" + this.spaceCodeOrNull + "/" + this.projectCodeOrNull + "/" + this.plateCode;
        }
        if (this.spaceCodeOrNull != null) {
            if (this.isSharedPlate()) {
                return "/" + this.plateCode;
            }
            return "/" + this.spaceCodeOrNull + "/" + this.plateCode;
        }
        return this.plateCode;
    }

    @JsonIgnore
    public boolean isSharedPlate() {
        return "".equals(this.spaceCodeOrNull);
    }

    @Override
    public int hashCode() {
        if (this.getPermId() != null) {
            return this.getPermId().hashCode();
        }
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.plateCode == null ? 0 : this.plateCode.hashCode());
        result = 31 * result + (this.spaceCodeOrNull == null ? 0 : this.spaceCodeOrNull.hashCode());
        result = 31 * result + (this.projectCodeOrNull == null ? 0 : this.projectCodeOrNull.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this.getPermId() != null) {
            return super.equals(obj);
        }
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof PlateIdentifier)) {
            return false;
        }
        PlateIdentifier other = (PlateIdentifier)obj;
        return this.equals(this.plateCode, other.plateCode) && this.equals(this.spaceCodeOrNull, other.spaceCodeOrNull) && this.equals(this.projectCodeOrNull, other.projectCodeOrNull);
    }

    private boolean equals(Object obj1, Object obj2) {
        return obj1 == null ? obj1 == obj2 : obj1.equals(obj2);
    }

    @Override
    public String toString() {
        if (this.getPermId() == null) {
            return this.getAugmentedCode();
        }
        return this.getAugmentedCode() + " [" + this.getPermId() + "]";
    }

    private PlateIdentifier() {
        super(null);
    }

    private void setPlateCode(String plateCode) {
        this.plateCode = plateCode;
    }

    private String getSpaceCodeOrNull() {
        return this.spaceCodeOrNull;
    }

    private void setSpaceCodeOrNull(String spaceCodeOrNull) {
        this.spaceCodeOrNull = spaceCodeOrNull;
    }

    private String getProjectCodeOrNull() {
        return this.projectCodeOrNull;
    }

    private void setProjectCodeOrNull(String projectCodeOrNull) {
        this.projectCodeOrNull = projectCodeOrNull;
    }
}

