/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto;

import ch.systemsx.cisd.base.annotation.JsonObject;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.DatasetIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.IDatasetIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.WellPosition;

@JsonObject(value="PlateImageReference")
public class PlateImageReference
extends DatasetIdentifier {
    private static final long serialVersionUID = 1L;
    private WellPosition wellPosition;
    private int tile;
    private String channelOrNull;

    public PlateImageReference(int tile, String channelOrNull, WellPosition wellPosition, IDatasetIdentifier dataset) {
        super(dataset.getDatasetCode(), dataset.getDatastoreServerUrl());
        this.wellPosition = wellPosition;
        this.tile = tile;
        this.channelOrNull = channelOrNull != null ? channelOrNull.toUpperCase() : null;
    }

    public PlateImageReference(int wellRow, int wellColumn, int tile, String channel, IDatasetIdentifier dataset) {
        this(tile, channel, new WellPosition(wellRow, wellColumn), dataset);
    }

    public WellPosition getWellPosition() {
        return this.wellPosition;
    }

    public int getTile() {
        return this.tile;
    }

    public String getChannel() {
        return this.channelOrNull;
    }

    @Override
    public String toString() {
        String wellDesc = this.wellPosition != null ? ", well " + this.wellPosition : "";
        return "Image for [dataset " + this.getDatasetCode() + wellDesc + ", channel " + this.channelOrNull + ", tile " + this.tile + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + super.hashCode();
        result = 31 * result + (this.channelOrNull == null ? 0 : this.channelOrNull.hashCode());
        result = 31 * result + this.tile;
        result = 31 * result + this.wellPosition.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        PlateImageReference other = (PlateImageReference)obj;
        if (this.channelOrNull == null && other.channelOrNull != null || !this.channelOrNull.equals(other.channelOrNull)) {
            return false;
        }
        if (this.tile != other.tile) {
            return false;
        }
        return this.wellPosition.equals(other.wellPosition);
    }

    private PlateImageReference() {
        super(null, null);
    }

    private void setWellPosition(WellPosition wellPosition) {
        this.wellPosition = wellPosition;
    }

    private void setTile(int tile) {
        this.tile = tile;
    }

    private void setChannel(String channelOrNull) {
        this.channelOrNull = channelOrNull;
    }
}

