/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto;

import ch.systemsx.cisd.base.annotation.JsonObject;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.Geometry;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.MaterialIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateIdentifier;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@JsonObject(value="PlateWellMaterialMapping")
public class PlateWellMaterialMapping
implements Serializable {
    private static final long serialVersionUID = 1L;
    private PlateIdentifier plateIdentifier;
    private Geometry plateGeometry;
    @JsonProperty
    private List<MaterialIdentifier>[] mapping;

    public PlateWellMaterialMapping(PlateIdentifier plateIdentifier, Geometry plateGeometry, List<MaterialIdentifier>[] mapping) {
        this.plateIdentifier = plateIdentifier;
        this.plateGeometry = plateGeometry;
        this.mapping = mapping;
    }

    public PlateWellMaterialMapping(PlateIdentifier plateIdentifier, Geometry plateGeometry, int defaultSize) {
        this.plateIdentifier = plateIdentifier;
        int size = plateGeometry.getNumberOfRows() * plateGeometry.getNumberOfColumns();
        this.plateGeometry = plateGeometry;
        this.mapping = this.createList(size);
        for (int i = 0; i < size; ++i) {
            this.mapping[i] = new ArrayList<MaterialIdentifier>(defaultSize);
        }
    }

    private List<MaterialIdentifier>[] createList(int size) {
        return new List[size];
    }

    public PlateIdentifier getPlateIdentifier() {
        return this.plateIdentifier;
    }

    public Geometry getPlateGeometry() {
        return this.plateGeometry;
    }

    public List<MaterialIdentifier> getMaterialsForWell(int row, int col) {
        return this.mapping[(row - 1) * this.plateGeometry.getNumberOfColumns() + (col - 1)];
    }

    private PlateWellMaterialMapping() {
    }

    private void setPlateIdentifier(PlateIdentifier plateIdentifier) {
        this.plateIdentifier = plateIdentifier;
    }

    private void setPlateGeometry(Geometry plateGeometry) {
        this.plateGeometry = plateGeometry;
    }

    private List<MaterialIdentifier>[] getMapping() {
        return this.mapping;
    }

    private void setMapping(List<MaterialIdentifier>[] mapping) {
        this.mapping = mapping;
    }
}

