/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto;

import ch.systemsx.cisd.base.annotation.JsonObject;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.FeatureVectorDatasetReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ImageDatasetReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.Plate;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.WellPosition;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

@JsonObject(value="PlateWellReferenceWithDatasets")
public class PlateWellReferenceWithDatasets
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Plate experimentPlateIdentifier;
    private WellPosition wellPosition;
    private List<ImageDatasetReference> imageDatasetReferences;
    private List<FeatureVectorDatasetReference> featureVectorDatasetReferences;

    public PlateWellReferenceWithDatasets(Plate experimentPlateIdentifier, WellPosition wellPosition) {
        this(experimentPlateIdentifier, wellPosition, Collections.emptyList(), Collections.emptyList());
    }

    public PlateWellReferenceWithDatasets(Plate plateExperimentIdentifier, WellPosition wellPosition, List<ImageDatasetReference> imageDatasetReferences, List<FeatureVectorDatasetReference> featureVectorDatasetReferences) {
        this.experimentPlateIdentifier = plateExperimentIdentifier;
        this.wellPosition = wellPosition;
        this.imageDatasetReferences = imageDatasetReferences;
        this.featureVectorDatasetReferences = featureVectorDatasetReferences;
    }

    public Plate getExperimentPlateIdentifier() {
        return this.experimentPlateIdentifier;
    }

    public WellPosition getWellPosition() {
        return this.wellPosition;
    }

    public List<ImageDatasetReference> getImageDatasetReferences() {
        return this.imageDatasetReferences;
    }

    public List<FeatureVectorDatasetReference> getFeatureVectorDatasetReferences() {
        return this.featureVectorDatasetReferences;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.experimentPlateIdentifier == null ? 0 : this.experimentPlateIdentifier.hashCode());
        result = 31 * result + (this.wellPosition == null ? 0 : this.wellPosition.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PlateWellReferenceWithDatasets other = (PlateWellReferenceWithDatasets)obj;
        if (this.experimentPlateIdentifier == null ? other.experimentPlateIdentifier != null : !this.experimentPlateIdentifier.equals(other.experimentPlateIdentifier)) {
            return false;
        }
        return !(this.wellPosition == null ? other.wellPosition != null : !this.wellPosition.equals(other.wellPosition));
    }

    public String toString() {
        return "PlateWellReferenceWithDatasets [experimentPlateIdentifier=" + this.experimentPlateIdentifier + ", wellPosition=" + this.wellPosition + ", #imageDatasets=" + this.imageDatasetReferences.size() + ", #featureVectorDatasets=" + this.featureVectorDatasetReferences.size() + "]";
    }

    private PlateWellReferenceWithDatasets() {
    }

    private void setExperimentPlateIdentifier(Plate experimentPlateIdentifier) {
        this.experimentPlateIdentifier = experimentPlateIdentifier;
    }

    private void setWellPosition(WellPosition wellPosition) {
        this.wellPosition = wellPosition;
    }

    private void setImageDatasetReferences(List<ImageDatasetReference> imageDatasetReferences) {
        this.imageDatasetReferences = imageDatasetReferences;
    }

    private void setFeatureVectorDatasetReferences(List<FeatureVectorDatasetReference> featureVectorDatasetReferences) {
        this.featureVectorDatasetReferences = featureVectorDatasetReferences;
    }
}

