/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto;

import ch.systemsx.cisd.base.annotation.JsonObject;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.Material;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.WellIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.WellPosition;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@JsonObject(value="WellMetadata")
public class WellMetadata
extends WellIdentifier {
    private static final long serialVersionUID = 1L;
    private String code;
    private String type;
    private Map<String, String> properties;
    private Map<String, Material> materialProperties;

    public WellMetadata(PlateIdentifier plateIdentifier, String code, String permId, String type, WellPosition wellPosition, Map<String, String> properties, Map<String, Material> materialProperties) {
        super(plateIdentifier, wellPosition, permId);
        this.code = code;
        this.type = type;
        this.properties = new HashMap<String, String>(properties);
        this.materialProperties = new HashMap<String, Material>(materialProperties);
    }

    public String getCode() {
        return this.code;
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public Map<String, Material> getMaterialProperties() {
        return Collections.unmodifiableMap(this.materialProperties);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.code == null ? 0 : this.code.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return this.getPermId() + " " + this.getCode() + " " + this.getWellPosition() + ", plate: " + this.getPlateIdentifier();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof WellMetadata)) {
            return false;
        }
        WellMetadata other = (WellMetadata)obj;
        return !(this.code == null ? other.code != null : false == this.code.equals(other.code));
    }

    public String getType() {
        return this.type;
    }

    private WellMetadata() {
        super(null, null, null);
    }

    private void setCode(String code) {
        this.code = code;
    }

    private void setType(String type) {
        this.type = type;
    }

    private void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    private void setMaterialProperties(Map<String, Material> materialProperties) {
        this.materialProperties = materialProperties;
    }
}

