/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto;

import ch.systemsx.cisd.base.annotation.JsonObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

@JsonObject(value="WellPosition")
public class WellPosition
implements Serializable,
Comparable<WellPosition> {
    private static final long serialVersionUID = 1L;
    private int wellRow;
    private int wellColumn;

    public static List<WellPosition> parseWellPositions(String wellPositionDescriptions) {
        StringTokenizer tokenizer = new StringTokenizer(wellPositionDescriptions);
        ArrayList<WellPosition> positions = new ArrayList<WellPosition>();
        while (tokenizer.hasMoreTokens()) {
            positions.add(WellPosition.parseWellPosition(tokenizer.nextToken()));
        }
        return positions;
    }

    public static WellPosition parseWellPosition(String wellDescription) {
        int indexOfDot = wellDescription.indexOf(46);
        if (indexOfDot < 1) {
            throw WellPosition.createException("Expecting a '.' in well description", wellDescription);
        }
        int row = WellPosition.getAndCheckRowNumber(indexOfDot, wellDescription);
        int col = WellPosition.getAndCheckColumnNumber(indexOfDot, wellDescription);
        return new WellPosition(row, col);
    }

    private static int getAndCheckColumnNumber(int indexOfDot, String well) {
        int col;
        try {
            col = Integer.parseInt(well.substring(indexOfDot + 1));
        }
        catch (NumberFormatException ex) {
            throw WellPosition.createException("String after '.' isn't a number", well);
        }
        if (col < 1) {
            throw WellPosition.createException("First column < 1", well);
        }
        return col;
    }

    private static int getAndCheckRowNumber(int indexOfDot, String well) {
        int row;
        try {
            row = Integer.parseInt(well.substring(0, indexOfDot));
        }
        catch (NumberFormatException ex) {
            throw WellPosition.createException("String before '.' isn't a number", well);
        }
        if (row < 1) {
            throw WellPosition.createException("First row < 1", well);
        }
        return row;
    }

    private static IllegalArgumentException createException(String description, String well) {
        return new IllegalArgumentException("Invalid well description: " + description + ": " + well);
    }

    public WellPosition(int wellRow, int wellColumn) {
        this.wellRow = wellRow;
        this.wellColumn = wellColumn;
    }

    public int getWellRow() {
        return this.wellRow;
    }

    public int getWellColumn() {
        return this.wellColumn;
    }

    public String toString() {
        return "[" + this.wellRow + ", " + this.wellColumn + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.wellColumn;
        result = 31 * result + this.wellRow;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WellPosition other = (WellPosition)obj;
        if (this.wellColumn != other.wellColumn) {
            return false;
        }
        return this.wellRow == other.wellRow;
    }

    @Override
    public int compareTo(WellPosition other) {
        int diff = this.wellRow - other.wellRow;
        return diff != 0 ? diff : this.wellColumn - other.wellColumn;
    }

    private WellPosition() {
    }

    private void setWellRow(int wellRow) {
        this.wellRow = wellRow;
    }

    private void setWellColumn(int wellColumn) {
        this.wellColumn = wellColumn;
    }
}

