/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto;

import ch.systemsx.cisd.openbis.generic.shared.basic.annotation.DoNotEscape;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CodeAndLabel;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.DatasetReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.FeatureList;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.FeatureVectorValues;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;

@DoNotEscape
public class FeatureVectorDataset
implements Serializable {
    private static final long serialVersionUID = 35L;
    private DatasetReference datasetReference;
    private String analysisProcedure;
    private List<CodeAndLabel> featureNames;
    private List<FeatureVectorValues> datasetFeatures;
    private List<FeatureList> featureLists;

    private FeatureVectorDataset() {
    }

    public FeatureVectorDataset(DatasetReference datasetReference, List<FeatureVectorValues> datasetFeatures, List<FeatureList> featureLists, String analysisProcedure) {
        this.datasetReference = datasetReference;
        this.datasetFeatures = datasetFeatures;
        this.featureLists = featureLists;
        this.analysisProcedure = analysisProcedure;
    }

    public FeatureVectorDataset(DatasetReference datasetReference, List<FeatureVectorValues> datasetFeatures, List<CodeAndLabel> featureNames) {
        this.datasetReference = datasetReference;
        this.datasetFeatures = datasetFeatures;
        this.featureNames = featureNames;
    }

    public DatasetReference getDatasetReference() {
        return this.datasetReference;
    }

    public String getAnalysisProcedure() {
        return this.analysisProcedure;
    }

    public List<CodeAndLabel> getFeatureNames() {
        if (this.featureNames == null && this.datasetFeatures != null && !this.datasetFeatures.isEmpty()) {
            this.featureNames = new LinkedList<CodeAndLabel>();
            for (CodeAndLabel cal : this.datasetFeatures.get(0).getCodesAndLabels()) {
                this.featureNames.add(cal);
            }
        }
        return this.featureNames;
    }

    public List<? extends FeatureVectorValues> getDatasetFeatures() {
        return this.datasetFeatures;
    }

    public List<FeatureList> getFeatureLists() {
        return this.featureLists;
    }
}

