/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto;

import ch.systemsx.cisd.openbis.generic.shared.basic.annotation.DoNotEscape;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CodeAndLabel;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.FeatureValue;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.PlateWellFeatureVectorReference;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellLocation;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellReference;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;

@DoNotEscape
public class FeatureVectorValues
implements Serializable {
    private static final long serialVersionUID = 35L;
    private PlateWellFeatureVectorReference featureVectorReference;
    private CodeAndLabel[] codesAndLabels;
    private FeatureValue[] featureValues;
    private Map<String, FeatureValue> featureMap;

    private static Map<String, FeatureValue> asValueMap(CodeAndLabel[] codesAndLabels, FeatureValue[] featureValues) {
        LinkedHashMap<String, FeatureValue> result = new LinkedHashMap<String, FeatureValue>();
        for (int i = 0; i < featureValues.length; ++i) {
            result.put(codesAndLabels[i].getLabel(), featureValues[i]);
        }
        return result;
    }

    private FeatureVectorValues() {
    }

    public FeatureVectorValues(FeatureVectorValues featureVector) {
        this(featureVector.getFeatureVectorReference(), featureVector.getCodesAndLabels(), featureVector.getFeatureValues(), featureVector.tryFeatureMap());
    }

    public FeatureVectorValues(String dataSetCode, WellLocation wellLocation, String platePermId, CodeAndLabel[] codesAndLabels, FeatureValue[] featureValues) {
        this(new PlateWellFeatureVectorReference(dataSetCode, wellLocation, platePermId), codesAndLabels, featureValues);
    }

    public FeatureVectorValues(PlateWellFeatureVectorReference featureVectorReference, CodeAndLabel[] codesAndLabels, FeatureValue[] featureValues) {
        this(featureVectorReference, codesAndLabels, featureValues, null);
    }

    private FeatureVectorValues(PlateWellFeatureVectorReference featureVectorReference, CodeAndLabel[] codesAndLabels, FeatureValue[] featureValues, Map<String, FeatureValue> featureMap) {
        assert (codesAndLabels.length == featureValues.length);
        this.featureVectorReference = featureVectorReference;
        this.codesAndLabels = codesAndLabels;
        this.featureValues = featureValues;
        this.featureMap = featureMap;
    }

    public CodeAndLabel[] getCodesAndLabels() {
        return this.codesAndLabels;
    }

    public FeatureValue[] getFeatureValues() {
        return this.featureValues;
    }

    public Map<String, FeatureValue> getFeatureMap() {
        if (null == this.featureMap) {
            this.featureMap = FeatureVectorValues.asValueMap(this.codesAndLabels, this.featureValues);
        }
        return this.featureMap;
    }

    private Map<String, FeatureValue> tryFeatureMap() {
        return this.featureMap;
    }

    public String getDataSetCode() {
        return this.featureVectorReference.getDatasetCode();
    }

    public WellLocation getWellLocation() {
        return this.featureVectorReference.getWellLocation();
    }

    public String getPlatePermId() {
        return this.featureVectorReference.getPlatePermId();
    }

    public PlateWellFeatureVectorReference getFeatureVectorReference() {
        return this.featureVectorReference;
    }

    public WellReference getWellReference() {
        return new WellReference(this.getWellLocation(), this.getPlatePermId());
    }
}

