/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto;

import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.InternalImageChannel;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.InternalImageTransformationInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ImageDatasetParameters
implements Serializable {
    private static final long serialVersionUID = 35L;
    private String datasetCode;
    private Integer rowsNumOrNull;
    private Integer colsNumOrNull;
    private int tileRowsNum;
    private int tileColsNum;
    private List<InternalImageChannel> channels;
    private boolean isMultidimensional;
    private String mergedChannelTransformerFactorySignatureOrNull;

    public Integer tryGetRowsNum() {
        return this.rowsNumOrNull;
    }

    public void setRowsNum(int rowsNum) {
        this.rowsNumOrNull = rowsNum;
    }

    public Integer tryGetColsNum() {
        return this.colsNumOrNull;
    }

    public void setColsNum(int colsNum) {
        this.colsNumOrNull = colsNum;
    }

    public int getTileRowsNum() {
        return this.tileRowsNum;
    }

    public void setTileRowsNum(int tileRowsNum) {
        this.tileRowsNum = tileRowsNum;
    }

    public int getTileColsNum() {
        return this.tileColsNum;
    }

    public void setTileColsNum(int tileColsNum) {
        this.tileColsNum = tileColsNum;
    }

    public String getDatasetCode() {
        return this.datasetCode;
    }

    public void setDatasetCode(String datasetCode) {
        this.datasetCode = datasetCode;
    }

    public List<String> getChannelsCodes() {
        ArrayList<String> channelCodes = new ArrayList<String>();
        for (InternalImageChannel channel : this.channels) {
            channelCodes.add(channel.getCode());
        }
        return channelCodes;
    }

    public List<String> getChannelsLabels() {
        ArrayList<String> channelLabels = new ArrayList<String>();
        for (InternalImageChannel channel : this.channels) {
            channelLabels.add(channel.getLabel());
        }
        return channelLabels;
    }

    public int getChannelsNumber() {
        return this.channels.size();
    }

    public List<InternalImageChannel> getChannels() {
        return this.channels;
    }

    public List<InternalImageTransformationInfo> getAvailableImageTransformationsFor(String channelCode) {
        ArrayList<InternalImageTransformationInfo> result = new ArrayList<InternalImageTransformationInfo>();
        result.add(new InternalImageTransformationInfo("$USER_DEFINED_RESCALING$", "User defined", "User defined intensity rescaling", "", false));
        for (InternalImageChannel channel : this.channels) {
            if (!channel.getCode().equalsIgnoreCase(channelCode)) continue;
            result.addAll(channel.getAvailableImageTransformations());
            return result;
        }
        return result;
    }

    public boolean isMultidimensional() {
        return this.isMultidimensional;
    }

    public void setIsMultidimensional(boolean isMultidimensional) {
        this.isMultidimensional = isMultidimensional;
    }

    public void setInternalChannels(List<InternalImageChannel> channels) {
        this.channels = channels;
    }

    public List<InternalImageChannel> getInternalChannels() {
        return this.channels;
    }

    public String tryGetTransformerFactorySignature(String channelCodeOrNull, String transformationCode) {
        if (channelCodeOrNull == null) {
            return this.mergedChannelTransformerFactorySignatureOrNull;
        }
        List<InternalImageTransformationInfo> transformations = this.getAvailableImageTransformationsFor(channelCodeOrNull);
        for (InternalImageTransformationInfo transformation : transformations) {
            if (!transformation.getCode().equalsIgnoreCase(transformationCode)) continue;
            return transformation.getTransformationSignature();
        }
        return null;
    }

    public String tryGetMergedChannelTransformerFactorySignature() {
        return this.mergedChannelTransformerFactorySignatureOrNull;
    }

    public void setMergedChannelTransformerFactorySignature(String mergedChannelTransformerFactorySignatureOrNull) {
        this.mergedChannelTransformerFactorySignatureOrNull = mergedChannelTransformerFactorySignatureOrNull;
    }
}

