/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto;

import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.PlateUtils;
import java.io.Serializable;

public class WellLocation
implements Serializable {
    private static final long serialVersionUID = 35L;
    private static final int MAX_LETTER_NUMBER = WellLocation.getLetterNumber('Z');
    private int row;
    private int column;

    public static WellLocation parseLocationStr(String locationStr) {
        int indexOfFirstDigit;
        if (locationStr == null || locationStr.length() == 0) {
            throw new IllegalArgumentException("Unspecified location.");
        }
        for (indexOfFirstDigit = 0; indexOfFirstDigit < locationStr.length() && !Character.isDigit(locationStr.charAt(indexOfFirstDigit)); ++indexOfFirstDigit) {
        }
        if (indexOfFirstDigit == 0) {
            throw new IllegalArgumentException("Missing row part of the location: " + locationStr);
        }
        return WellLocation.parseLocationStr(locationStr.substring(0, indexOfFirstDigit), locationStr.substring(indexOfFirstDigit));
    }

    public static WellLocation tryParseLocationStr(String locationStr) {
        try {
            return WellLocation.parseLocationStr(locationStr);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public static WellLocation parseLocationStr(String rowLocationStr, String colLocationStr) {
        int col;
        if (colLocationStr.length() == 0) {
            throw new IllegalArgumentException("No column location given.");
        }
        try {
            col = Integer.parseInt(colLocationStr);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Column part of the location is not a number: " + colLocationStr);
        }
        if (col < 1) {
            throw new IllegalArgumentException("Column part of the location is not a positive number: " + colLocationStr);
        }
        return WellLocation.parseLocationStr(rowLocationStr, col);
    }

    public static WellLocation parseLocationStr(String rowLocationStr, int column) {
        if (rowLocationStr.length() == 0) {
            throw new IllegalArgumentException("No row location given.");
        }
        int row = 0;
        if (Character.isDigit(rowLocationStr.charAt(0))) {
            try {
                row = Integer.parseInt(rowLocationStr);
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("Row part of the location starts with a digit but is not a valid number: " + rowLocationStr);
            }
            if (row < 1) {
                throw new IllegalArgumentException("Row part of the location is not a positive number: " + rowLocationStr);
            }
        } else {
            for (int i = 0; i < rowLocationStr.length(); ++i) {
                char letter = rowLocationStr.charAt(i);
                int digit = WellLocation.getLetterNumber(letter);
                if (digit < 0 || digit > MAX_LETTER_NUMBER) {
                    throw new IllegalArgumentException("Invalid letter '" + letter + "' in row location: " + rowLocationStr);
                }
                row = row * MAX_LETTER_NUMBER + digit;
            }
        }
        if (column < 1) {
            throw new IllegalArgumentException("Column part of the location is not a positive number: " + column);
        }
        return new WellLocation(row, column);
    }

    private static int getLetterNumber(char ch) {
        return Character.toUpperCase(ch) - 65 + 1;
    }

    private WellLocation() {
    }

    public WellLocation(int row, int column) {
        if (row <= 0) {
            throw new IllegalArgumentException(this.createNonPositiveErrorMsg("row", row));
        }
        if (column <= 0) {
            throw new IllegalArgumentException(this.createNonPositiveErrorMsg("column", column));
        }
        this.row = row;
        this.column = column;
    }

    private String createNonPositiveErrorMsg(String field, int value) {
        return "Given coordinate '" + field + "' must be > 0 (" + value + " <= 0).";
    }

    public int getRow() {
        return this.row;
    }

    public int getColumn() {
        return this.column;
    }

    public String toString() {
        return "(" + this.row + "," + this.column + ")";
    }

    public String toWellIdString() {
        return PlateUtils.translateRowNumberIntoLetterCode(this.row) + this.column;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.column;
        result = 31 * result + this.row;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WellLocation other = (WellLocation)obj;
        if (this.column != other.column) {
            return false;
        }
        return this.row == other.row;
    }
}

