/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.shared.dto;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.util.EntityHelper;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.Geometry;
import ch.systemsx.cisd.openbis.plugin.screening.shared.dto.PlateDimension;
import java.util.List;

public class PlateDimensionParser {
    public static final String PLATE_GEOMETRY_PROPERTY_NAME = "$PLATE_GEOMETRY";

    public static PlateDimension getPlateDimension(IEntityProperty[] properties) {
        PlateDimension plateDimension = PlateDimensionParser.tryToGetPlateDimension(properties);
        if (plateDimension == null) {
            throw new IllegalArgumentException("Cannot find property $PLATE_GEOMETRY");
        }
        return plateDimension;
    }

    public static PlateDimension tryToGetPlateDimension(IEntityProperty[] properties) {
        if (properties == null) {
            return null;
        }
        IEntityProperty plateGeometryProperty = EntityHelper.tryFindProperty((IEntityProperty[])properties, (String)PLATE_GEOMETRY_PROPERTY_NAME);
        if (plateGeometryProperty == null) {
            return null;
        }
        String plateGeometryString = plateGeometryProperty.tryGetAsString();
        PlateDimension dimension = PlateDimensionParser.tryParsePlateDimension(plateGeometryString);
        if (dimension == null) {
            throw new IllegalArgumentException("Cannot parse plate geometry " + plateGeometryString);
        }
        return dimension;
    }

    private static PlateDimension tryParsePlateDimension(String plateGeometryString) {
        String[] tokens = plateGeometryString.split("_");
        String sizeToken = tokens[tokens.length - 1];
        String[] dims = sizeToken.toUpperCase().split("X");
        if (dims.length != 2) {
            return null;
        }
        Integer rows = PlateDimensionParser.tryParseInteger(dims[0]);
        Integer cols = PlateDimensionParser.tryParseInteger(dims[1]);
        if (rows == null || cols == null) {
            return null;
        }
        return new PlateDimension(rows, cols);
    }

    private static Integer tryParseInteger(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Geometry getPlateGeometry(List<IEntityProperty> properties) {
        return PlateDimensionParser.getPlateDimension(properties.toArray(new IEntityProperty[0])).getPlateGeometry();
    }
}

