/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.shared.imaging;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.security.MD5ChecksumCalculator;
import ch.systemsx.cisd.openbis.generic.shared.basic.utils.GroupByMap;
import ch.systemsx.cisd.openbis.generic.shared.basic.utils.IGroupKeyExtractor;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ImageChannelStack;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ImageDatasetParameters;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.InternalImageChannel;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.InternalImageTransformationInfo;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.WellLocation;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.IImageDatasetLoader;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.IImagingReadonlyQueryDAO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgChannelDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgChannelStackDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgContainerDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgExperimentDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgImageDatasetDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgImageTransformationDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.log4j.Logger;

public class HCSDatasetLoader
implements IImageDatasetLoader {
    protected static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, HCSDatasetLoader.class);
    protected final IImagingReadonlyQueryDAO query;
    protected final ImgImageDatasetDTO dataset;
    protected ImgContainerDTO containerOrNull;
    protected ImgExperimentDTO experimentOrNull;
    protected Integer channelCount;
    protected List<ImgChannelDTO> channels;
    protected Map<Long, List<ImgImageTransformationDTO>> availableImageTransformationsMap;
    private final String mergedChannelTransformerFactorySignatureOrNull;

    public static HCSDatasetLoader tryCreate(IImagingReadonlyQueryDAO query, String datasetPermId) {
        ImgImageDatasetDTO dataset = query.tryGetImageDatasetByPermId(datasetPermId);
        if (dataset == null) {
            operationLog.warn((Object)String.format("No dataset with code '%s' found in the imaging database.", datasetPermId));
            return null;
        }
        return new HCSDatasetLoader(query, dataset);
    }

    protected HCSDatasetLoader(IImagingReadonlyQueryDAO query, ImgImageDatasetDTO dataset) {
        this.query = query;
        this.dataset = dataset;
        Long containerId = dataset.getContainerId();
        if (containerId != null) {
            this.containerOrNull = query.getContainerById(containerId);
            this.experimentOrNull = query.tryGetExperimentById(this.containerOrNull.getExperimentId());
        } else {
            this.containerOrNull = null;
            this.experimentOrNull = null;
        }
        this.mergedChannelTransformerFactorySignatureOrNull = this.tryGetImageTransformerFactorySignatureForMergedChannels();
        this.channels = this.loadChannels();
        this.availableImageTransformationsMap = this.loadAvailableImageTransformations();
    }

    private Map<Long, List<ImgImageTransformationDTO>> loadAvailableImageTransformations() {
        List<ImgImageTransformationDTO> imageTransformations = this.query.listImageTransformationsByDatasetId(this.dataset.getId());
        if (imageTransformations.size() == 0 && this.containerOrNull != null) {
            imageTransformations = this.query.listImageTransformationsByExperimentId(this.containerOrNull.getExperimentId());
        }
        return GroupByMap.create(imageTransformations, (IGroupKeyExtractor)new IGroupKeyExtractor<Long, ImgImageTransformationDTO>(){

            public Long getKey(ImgImageTransformationDTO transformation) {
                return transformation.getChannelId();
            }
        }).getMap();
    }

    private List<ImgChannelDTO> loadChannels() {
        List<ImgChannelDTO> myChannels = this.query.getChannelsByDatasetId(this.dataset.getId());
        if (myChannels.size() == 0 && this.containerOrNull != null) {
            myChannels = this.query.getChannelsByExperimentId(this.containerOrNull.getExperimentId());
        }
        return myChannels;
    }

    private String tryGetImageTransformerFactorySignatureForMergedChannels() {
        byte[] imageTransformerFactory = this.dataset.getSerializedImageTransformerFactory();
        if (imageTransformerFactory == null && this.experimentOrNull != null) {
            imageTransformerFactory = this.experimentOrNull.getSerializedImageTransformerFactory();
        }
        return HCSDatasetLoader.tryGetSignature(imageTransformerFactory);
    }

    protected final ImgContainerDTO tryGetContainer() {
        return this.containerOrNull;
    }

    protected final ImgImageDatasetDTO getDataset() {
        return this.dataset;
    }

    public int getChannelCount() {
        return this.channels.size();
    }

    @Override
    public List<ImageChannelStack> listImageChannelStacks(WellLocation wellLocationOrNull) {
        List<ImgChannelStackDTO> stacks;
        if (wellLocationOrNull != null) {
            int spotYRow = wellLocationOrNull.getRow();
            int spotXColumn = wellLocationOrNull.getColumn();
            stacks = this.query.listChannelStacks(this.dataset.getId(), spotXColumn, spotYRow);
        } else {
            stacks = this.query.listSpotlessChannelStacks(this.dataset.getId());
        }
        return HCSDatasetLoader.convert(stacks);
    }

    private static List<ImageChannelStack> convert(List<ImgChannelStackDTO> stacks) {
        ArrayList<ImageChannelStack> result = new ArrayList<ImageChannelStack>();
        for (ImgChannelStackDTO stack : stacks) {
            result.add(HCSDatasetLoader.convert(stack));
        }
        return result;
    }

    private static ImageChannelStack convert(ImgChannelStackDTO stack) {
        return new ImageChannelStack(stack.getId(), stack.getRow(), stack.getColumn(), stack.getT(), stack.getZ(), stack.getSeriesNumber());
    }

    @Override
    public ImageDatasetParameters getImageParameters() {
        ImageDatasetParameters params = new ImageDatasetParameters();
        params.setDatasetCode(this.dataset.getPermId());
        if (this.containerOrNull != null) {
            params.setRowsNum(this.containerOrNull.getNumberOfRows());
            params.setColsNum(this.containerOrNull.getNumberOfColumns());
        }
        params.setTileRowsNum(this.getDataset().getFieldNumberOfRows());
        params.setTileColsNum(this.getDataset().getFieldNumberOfColumns());
        params.setIsMultidimensional(this.dataset.getIsMultidimensional());
        params.setMergedChannelTransformerFactorySignature(this.mergedChannelTransformerFactorySignatureOrNull);
        params.setInternalChannels(this.convertChannels());
        return params;
    }

    private List<InternalImageChannel> convertChannels() {
        ArrayList<InternalImageChannel> convertedChannels = new ArrayList<InternalImageChannel>();
        for (ImgChannelDTO channelDTO : this.channels) {
            InternalImageChannel channel = this.convert(channelDTO);
            convertedChannels.add(channel);
        }
        return convertedChannels;
    }

    private InternalImageChannel convert(ImgChannelDTO channelDTO) {
        List<InternalImageTransformationInfo> availableImageTransformations = HCSDatasetLoader.convertTransformations(this.availableImageTransformationsMap.get(channelDTO.getId()));
        return new InternalImageChannel(channelDTO.getCode(), channelDTO.getLabel(), channelDTO.getDescription(), channelDTO.getWavelength(), availableImageTransformations);
    }

    private static List<InternalImageTransformationInfo> convertTransformations(List<ImgImageTransformationDTO> transformationsOrNull) {
        if (transformationsOrNull == null) {
            return new ArrayList<InternalImageTransformationInfo>();
        }
        Collection transformations = CollectionUtils.collect(transformationsOrNull, (Transformer)new Transformer<ImgImageTransformationDTO, InternalImageTransformationInfo>(){

            public InternalImageTransformationInfo transform(ImgImageTransformationDTO transformation) {
                return HCSDatasetLoader.convert(transformation);
            }
        });
        return new LinkedList<InternalImageTransformationInfo>(transformations);
    }

    private static InternalImageTransformationInfo convert(ImgImageTransformationDTO transformation) {
        String transformationSignature = HCSDatasetLoader.tryGetSignature(transformation.getSerializedImageTransformerFactory());
        return new InternalImageTransformationInfo(transformation.getCode(), transformation.getLabel(), transformation.getDescription(), transformationSignature, transformation.getIsDefault());
    }

    private static String tryGetSignature(byte[] bytesOrNull) {
        if (bytesOrNull == null) {
            return null;
        }
        return MD5ChecksumCalculator.calculate((byte[])bytesOrNull).substring(0, 10);
    }
}

