/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hcs;

import ch.systemsx.cisd.common.geometry.ConversionUtils;
import ch.systemsx.cisd.common.geometry.Point;
import ch.systemsx.cisd.hcs.Geometry;
import java.io.Serializable;

public final class Location
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final String NOT_POSITIVE = "Given coordinate '%s' must be > 0 (%d <= 0).";
    private final int x;
    private final int y;

    public Location(int x, int y) {
        assert (x > 0) : String.format("Given coordinate '%s' must be > 0 (%d <= 0).", "x", x);
        this.x = x;
        assert (y > 0) : String.format("Given coordinate '%s' must be > 0 (%d <= 0).", "y", y);
        this.y = y;
    }

    public static final Location createLocationFromRowAndColumn(int row, int column) {
        return new Location(column, row);
    }

    public static final Location tryCreateLocationFromRowwisePosition(int position, Geometry geometry) {
        return Location.tryCreateLocationFromPosition(position, geometry, false);
    }

    public static final Location tryCreateLocationFromColumnwisePosition(int position, Geometry geometry) {
        return Location.tryCreateLocationFromPosition(position, geometry, true);
    }

    private static final Location tryCreateLocationFromPosition(int position, Geometry geometry, boolean isColumnwise) {
        assert (geometry != null) : "Given geometry can not be null.";
        int rows = geometry.getRows();
        int columns = geometry.getColumns();
        int divisor = isColumnwise ? rows : columns;
        int max = columns * rows;
        if (position > 0 && position <= max) {
            int modulo = position % divisor;
            int x = modulo == 0 ? divisor : modulo;
            int y = (int)Math.ceil((float)position / (float)divisor);
            if (isColumnwise) {
                return new Location(y, x);
            }
            return new Location(x, y);
        }
        return null;
    }

    public static final Location tryCreateLocationFromTransposedMatrixCoordinate(String coordinate) {
        try {
            Point point = ConversionUtils.parseSpreadsheetLocation((String)coordinate);
            return new Location(point.getY() + 1, point.getX() + 1);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public static final Location tryCreateLocationFromTransposedSplitMatrixCoordinate(String columnCoord, String rowCoord) {
        return Location.tryCreateLocationFromTransposedMatrixCoordinate(columnCoord + rowCoord);
    }

    public final String createMatrixCoordinateFromLocation() {
        Point point = new Point(this.getY() - 1, this.getX() - 1);
        return ConversionUtils.convertToSpreadsheetLocation((Point)point);
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Location)) {
            return false;
        }
        Location location = (Location)obj;
        return location.x == this.x && location.y == this.y;
    }

    public final int hashCode() {
        int hashCode = 17;
        hashCode = hashCode * 37 + this.x;
        hashCode = hashCode * 37 + this.y;
        return hashCode;
    }

    public final String toString() {
        return "[x=" + this.x + ",y=" + this.y + "]";
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }
}

