/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.common.api.server.json.deserializer;

import ch.systemsx.cisd.base.annotation.JsonObject;
import ch.systemsx.cisd.openbis.common.api.server.json.common.JsonConstants;
import ch.systemsx.cisd.openbis.common.api.server.json.mapping.IJsonClassValueToClassObjectsMapping;
import ch.systemsx.cisd.openbis.common.api.server.json.mapping.JsonStaticClassValueToClassObjectsMapping;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.util.JsonParserSequence;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.impl.AsPropertyTypeDeserializer;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class JsonTypeAndClassDeserializer
extends AsPropertyTypeDeserializer {
    private boolean hasSubtypes;
    private IJsonClassValueToClassObjectsMapping classValueToClassObjectsMapping = new JsonStaticClassValueToClassObjectsMapping();

    public JsonTypeAndClassDeserializer(JsonTypeAndClassDeserializer src, BeanProperty property) {
        super((AsPropertyTypeDeserializer)src, property);
        this.hasSubtypes = src.hasSubtypes;
        this.classValueToClassObjectsMapping = src.classValueToClassObjectsMapping;
    }

    public JsonTypeAndClassDeserializer(JavaType type, Collection<NamedType> subtypes, TypeIdResolver idRes, String typePropName, boolean typeIdVisible) {
        super(type, idRes, typePropName, typeIdVisible, null);
        this.hasSubtypes = subtypes != null && subtypes.size() > 1;
    }

    public TypeDeserializer forProperty(BeanProperty prop) {
        return new JsonTypeAndClassDeserializer(this, prop);
    }

    public Object deserializeTypedFromAny(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        return this.deserializeTypedFromObject(jp, ctxt);
    }

    public Object deserializeTypedFromArray(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        return this.deserializeTypedFromObject(jp, ctxt);
    }

    public Object deserializeTypedFromObject(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.START_OBJECT) {
            t = jp.nextToken();
        } else {
            if (t == JsonToken.START_ARRAY) {
                return this._deserializeTypedUsingDefaultImpl(jp, ctxt, null);
            }
            if (t != JsonToken.FIELD_NAME) {
                return this._deserializeTypedUsingDefaultImpl(jp, ctxt, null);
            }
        }
        TokenBuffer tb = null;
        while (t == JsonToken.FIELD_NAME) {
            String name = jp.getCurrentName();
            jp.nextToken();
            if (JsonConstants.getTypeField().equals(name)) {
                return this.deserializeWithType(jp, ctxt, tb, jp.getText());
            }
            if (JsonConstants.getLegacyClassField().equals(name)) {
                return this.deserializeWithLegacyClass(jp, ctxt, tb);
            }
            if (tb == null) {
                tb = new TokenBuffer(null, false);
            }
            tb.writeFieldName(name);
            tb.copyCurrentStructure(jp);
            t = jp.nextToken();
        }
        if (this.hasSubtypes) {
            throw new JsonMappingException("Cannot deserialize a polymorphic type without type information");
        }
        return this.deserializeWithoutType(jp, ctxt, tb);
    }

    private Object deserializeWithType(JsonParser jp, DeserializationContext ctxt, TokenBuffer tb, String type) throws IOException, JsonProcessingException {
        JsonParser actualJp = jp;
        TokenBuffer actualTb = tb;
        JsonDeserializer deser = this._findDeserializer(ctxt, type);
        if (this._typeIdVisible) {
            if (actualTb == null) {
                actualTb = new TokenBuffer(null, false);
            }
            actualTb.writeFieldName(actualJp.getCurrentName());
            actualTb.writeString(type);
        }
        if (actualTb != null) {
            actualJp = JsonParserSequence.createFlattened((JsonParser)actualTb.asParser(actualJp), (JsonParser)actualJp);
        }
        actualJp.nextToken();
        return deser.deserialize(actualJp, ctxt);
    }

    private Object deserializeWithLegacyClass(JsonParser jp, DeserializationContext ctxt, TokenBuffer tb) throws IOException, JsonProcessingException {
        String classValue = jp.getText();
        List<Class<?>> classObjects = this.classValueToClassObjectsMapping.getClasses(classValue);
        if (classObjects != null && classObjects.size() > 0) {
            ArrayList matchingClassObjects = new ArrayList();
            for (Class<?> classObject : classObjects) {
                if (classObject == null || !this._baseType.getRawClass().isAssignableFrom(classObject)) continue;
                matchingClassObjects.add(classObject);
            }
            if (matchingClassObjects.isEmpty()) {
                throw new NoMatchingLegacyClassFoundException(classValue);
            }
            if (matchingClassObjects.size() > 1) {
                throw new MoreThanOneMatchingLegacyClassFoundException(classValue, matchingClassObjects);
            }
            JsonObject objectAnnotation = ((Class)matchingClassObjects.get(0)).getAnnotation(JsonObject.class);
            if (objectAnnotation != null) {
                return this.deserializeWithType(jp, ctxt, tb, objectAnnotation.value());
            }
            throw new MissingAnnotationForLegacyClassException(classValue, (Class)matchingClassObjects.get(0));
        }
        throw new NoMatchingLegacyClassesException(classValue);
    }

    public Object deserializeWithoutType(JsonParser jp, DeserializationContext ctxt, TokenBuffer tb) throws IOException, JsonProcessingException {
        JsonParser actualJp;
        JsonToken t = jp.getCurrentToken();
        JavaType type = this._baseType;
        if (type.getRawClass().equals(Object.class)) {
            if (t == JsonToken.START_ARRAY) {
                type = ctxt.getConfig().getTypeFactory().constructRawCollectionType(Collection.class);
            } else if (t == JsonToken.START_OBJECT) {
                type = ctxt.getConfig().getTypeFactory().constructRawMapType(Map.class);
            }
        }
        JsonDeserializer deserializer = ctxt.findContextualValueDeserializer(type, this._property);
        if (tb != null) {
            tb.writeEndObject();
            actualJp = tb.asParser(jp);
            actualJp.nextToken();
        } else {
            actualJp = jp;
        }
        return deserializer.deserialize(actualJp, ctxt);
    }

    public void setClassValueToClassObjectsMapping(IJsonClassValueToClassObjectsMapping classValueToClassObjectsMapping) {
        this.classValueToClassObjectsMapping = classValueToClassObjectsMapping != null ? classValueToClassObjectsMapping : new JsonStaticClassValueToClassObjectsMapping();
    }

    private class MissingAnnotationForLegacyClassException
    extends JsonMappingException {
        private static final long serialVersionUID = 1L;

        public MissingAnnotationForLegacyClassException(String classValue, Class<?> matchingClass) {
            super("Couldn't deserialize a JSON object with a legacy @class field value: '" + classValue + "'. Class defined in @class => Java classes mapping: '" + matchingClass + "' can be assigned to a base type: '" + JsonTypeAndClassDeserializer.this._baseType + "' but it doesn't contain @JsonObject annotation.");
        }
    }

    private class MoreThanOneMatchingLegacyClassFoundException
    extends JsonMappingException {
        private static final long serialVersionUID = 1L;

        public MoreThanOneMatchingLegacyClassFoundException(String classValue, List<Class<?>> matchingClasses) {
            super("Couldn't deserialize a JSON object with a legacy @class field value: '" + classValue + "'. All of the classes: " + matchingClasses + " definded in @class => Java classes mapping can be assigned to a base type: '" + JsonTypeAndClassDeserializer.this._baseType + "'.");
        }
    }

    private class NoMatchingLegacyClassFoundException
    extends JsonMappingException {
        private static final long serialVersionUID = 1L;

        public NoMatchingLegacyClassFoundException(String classValue) {
            super("Couldn't deserialize a JSON object with a legacy @class field value: '" + classValue + "'. None of the classes: " + JsonTypeAndClassDeserializer.this.classValueToClassObjectsMapping.getClasses(classValue) + " definded in @class => Java classes mapping can be assigned to a base type: '" + JsonTypeAndClassDeserializer.this._baseType + "'.");
        }
    }

    private class NoMatchingLegacyClassesException
    extends JsonMappingException {
        private static final long serialVersionUID = 1L;

        public NoMatchingLegacyClassesException(String classValue) {
            super("Couldn't deserialize a JSON object with a legacy @class field value: '" + classValue + "'. No classes have been definded in @class => Java classes mapping for that value.");
        }
    }
}

