/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.common.api.server.json.deserializer;

import ch.systemsx.cisd.base.annotation.JsonObject;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.impl.AsPropertyTypeSerializer;
import java.io.IOException;

public class JsonTypeAndClassSerializer
extends AsPropertyTypeSerializer {
    public JsonTypeAndClassSerializer(TypeIdResolver idRes, BeanProperty property, String propName) {
        super(idRes, property, propName);
    }

    public JsonTypeAndClassSerializer forProperty(BeanProperty prop) {
        if (this._property == prop) {
            return this;
        }
        return new JsonTypeAndClassSerializer(this._idResolver, prop, this._typePropertyName);
    }

    public WritableTypeId writeTypePrefix(JsonGenerator g, WritableTypeId idMetadata) throws IOException {
        Object value = idMetadata.forValue;
        JsonToken valueShape = idMetadata.valueShape;
        if (JsonToken.START_OBJECT == valueShape) {
            g.writeStartObject();
            if (this.isValueWithType(value)) {
                g.writeStringField(this._typePropertyName, this.idFromValue(value));
            }
        } else if (JsonToken.VALUE_STRING == valueShape) {
            if (this.isValueWithType(value)) {
                g.writeTypePrefix(idMetadata);
            }
        } else if (JsonToken.START_ARRAY == valueShape) {
            g.writeStartArray();
        } else {
            g.writeTypePrefix(idMetadata);
        }
        return idMetadata;
    }

    public WritableTypeId writeTypeSuffix(JsonGenerator g, WritableTypeId idMetadata) throws IOException {
        Object value = idMetadata.forValue;
        JsonToken valueShape = idMetadata.valueShape;
        if (JsonToken.START_OBJECT == valueShape) {
            g.writeEndObject();
        } else if (JsonToken.VALUE_STRING == valueShape) {
            if (this.isValueWithType(value)) {
                g.writeTypeSuffix(idMetadata);
            }
        } else if (JsonToken.START_ARRAY == valueShape) {
            g.writeEndArray();
        } else {
            g.writeTypeSuffix(idMetadata);
        }
        return idMetadata;
    }

    private boolean isValueWithType(Object value) {
        return value != null && value.getClass().isAnnotationPresent(JsonObject.class) && !value.getClass().isEnum();
    }
}

