/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.common.conversation.client;

import ch.systemsx.cisd.common.serviceconversation.IServiceMessageTransport;
import ch.systemsx.cisd.common.serviceconversation.ServiceConversationDTO;
import ch.systemsx.cisd.common.serviceconversation.ServiceMessage;
import ch.systemsx.cisd.common.serviceconversation.client.IRemoteServiceConversationServer;
import ch.systemsx.cisd.common.serviceconversation.client.IServiceConversation;
import ch.systemsx.cisd.common.serviceconversation.client.ServiceConversationClient;
import ch.systemsx.cisd.common.spring.HttpInvokerUtils;
import ch.systemsx.cisd.openbis.common.conversation.manager.IServiceConversationServerManagerRemote;

public class ServiceConversationClientWithConversationTracking {
    private ServiceConversationClient client;

    public ServiceConversationClientWithConversationTracking(String serverUrl, Object clientId, int clientTimeout) {
        IServiceConversationServerManagerRemote serverManager = this.createServerManager(serverUrl, clientTimeout);
        IRemoteServiceConversationServer server = this.createServer(serverManager, clientId, clientTimeout);
        this.client = new ServiceConversationClient(server, (IServiceMessageTransport)serverManager);
    }

    public IServiceConversation startConversation(Class<?> serviceInterface, String sessionToken) {
        TypeId typeId = new TypeId(serviceInterface.getName(), sessionToken);
        IServiceConversation conversation = this.client.startConversation(typeId.format());
        this.onConversationStart(conversation);
        return conversation;
    }

    public void onConversationStart(IServiceConversation conversation) {
    }

    public void receiveMessage(ServiceMessage message) {
        this.client.getIncomingResponseMessageTransport().send(message);
    }

    public void closeConversation(IServiceConversation conversation) {
        conversation.close();
        this.onConversationClose(conversation);
    }

    public void onConversationClose(IServiceConversation conversation) {
    }

    private IServiceConversationServerManagerRemote createServerManager(String serverUrl, int clientTimeout) {
        return (IServiceConversationServerManagerRemote)HttpInvokerUtils.createServiceStub(IServiceConversationServerManagerRemote.class, (String)serverUrl, (long)clientTimeout);
    }

    private IRemoteServiceConversationServer createServer(final IServiceConversationServerManagerRemote serverManager, final Object clientId, final int clientTimeout) {
        return new IRemoteServiceConversationServer(){

            public ServiceConversationDTO startConversation(String typeIdStr) {
                TypeId typeId = TypeId.parse(typeIdStr);
                ServiceConversationDTO conversation = serverManager.startConversation(typeId.getSessionToken(), typeId.getServiceName(), clientId);
                return new ServiceConversationDTO(conversation.getServiceConversationId(), clientTimeout, conversation.getWorkQueueSize());
            }
        };
    }

    private static class TypeId {
        private String serviceName;
        private String sessionToken;

        public TypeId(String serviceName, String sessionToken) {
            this.serviceName = serviceName;
            this.sessionToken = sessionToken;
        }

        private String format() {
            return this.serviceName + "," + this.sessionToken;
        }

        private static TypeId parse(String str) {
            String[] parts = str.split(",");
            return new TypeId(parts[0], parts[1]);
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public String getSessionToken() {
            return this.sessionToken;
        }
    }
}

