/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.common.conversation.manager;

import ch.systemsx.cisd.common.serviceconversation.IServiceMessageTransport;
import ch.systemsx.cisd.common.serviceconversation.ServiceConversationDTO;
import ch.systemsx.cisd.common.serviceconversation.ServiceMessage;
import ch.systemsx.cisd.common.serviceconversation.UnknownServiceConversationException;
import ch.systemsx.cisd.common.serviceconversation.server.IServiceFactory;
import ch.systemsx.cisd.common.serviceconversation.server.ServiceConversationServer;
import ch.systemsx.cisd.common.spring.HttpInvokerUtils;
import ch.systemsx.cisd.openbis.common.conversation.client.ServiceConversationClientDetails;
import ch.systemsx.cisd.openbis.common.conversation.manager.IServiceConversationClientManagerRemote;
import ch.systemsx.cisd.openbis.common.conversation.manager.IServiceConversationServerManagerRemote;
import ch.systemsx.cisd.openbis.common.conversation.manager.ServiceConversationServiceFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class BaseServiceConversationServerManager
implements IServiceConversationServerManagerRemote {
    private ServiceConversationServer server = new ServiceConversationServer();
    private Map<ServiceConversationClientDetails, IServiceConversationClientManagerRemote> clientDetailsToClientMap = Collections.synchronizedMap(new HashMap());
    private Map<String, ServiceConversationClientDetails> conversationIdToClientDetailsMap = Collections.synchronizedMap(new HashMap());

    protected void addService(Class<?> serviceInterface, Object service) {
        ServiceConversationServiceFactory serviceFactory = new ServiceConversationServiceFactory(this.server, serviceInterface.getName(), service){

            @Override
            protected int getProgressInterval(String conversationId) {
                ServiceConversationClientDetails clientDetails = (ServiceConversationClientDetails)BaseServiceConversationServerManager.this.conversationIdToClientDetailsMap.get(conversationId);
                if (clientDetails == null) {
                    throw new UnknownServiceConversationException(String.format("Tried to report progress for an unknown service conversation '%s'", conversationId));
                }
                return Math.min(Math.max(clientDetails.getTimeout() / 10, 1), 60000);
            }

            @Override
            protected void onConversationFinish(String conversationId) {
                BaseServiceConversationServerManager.this.conversationIdToClientDetailsMap.remove(conversationId);
            }
        };
        this.server.addServiceType((IServiceFactory)serviceFactory);
    }

    @Override
    public ServiceConversationDTO startConversation(String sessionToken, String serviceName, Object clientId) {
        ServiceConversationClientDetails clientDetails = this.getClientDetailsForClientId(clientId);
        if (clientDetails == null) {
            throw new IllegalArgumentException("Received a service conversation request from an unknown client (" + clientId + ")");
        }
        this.server.addClientResponseTransport(sessionToken, (IServiceMessageTransport)this.getClientForClientDetails(clientDetails));
        ServiceConversationDTO conversation = this.server.startConversation(serviceName, sessionToken, clientDetails.getTimeout());
        this.conversationIdToClientDetailsMap.put(conversation.getServiceConversationId(), clientDetails);
        return conversation;
    }

    public void send(ServiceMessage message) {
        this.server.getIncomingMessageTransport().send(message);
    }

    @Override
    public void ping() {
    }

    public int getConversationCount() {
        return this.conversationIdToClientDetailsMap.size();
    }

    public int getClientCount() {
        return this.clientDetailsToClientMap.size();
    }

    protected abstract ServiceConversationClientDetails getClientDetailsForClientId(Object var1);

    private synchronized IServiceConversationClientManagerRemote getClientForClientDetails(ServiceConversationClientDetails clientDetails) {
        IServiceConversationClientManagerRemote client = this.clientDetailsToClientMap.get(clientDetails);
        if (client == null) {
            client = (IServiceConversationClientManagerRemote)HttpInvokerUtils.createServiceStub(IServiceConversationClientManagerRemote.class, (String)clientDetails.getUrl(), (long)clientDetails.getTimeout());
            this.clientDetailsToClientMap.put(clientDetails, client);
        }
        return client;
    }
}

