/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.common.io;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.base.io.IRandomAccessFile;
import ch.systemsx.cisd.base.io.RandomAccessFileImpl;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class FileBasedContentNode
implements IHierarchicalContentNode {
    private final File file;

    public FileBasedContentNode(File file) {
        this.file = file;
    }

    public String tryGetName() {
        return this.file.getName();
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public InputStream getInputStream() {
        try {
            return new BufferedInputStream(new FileInputStream(this.file));
        }
        catch (FileNotFoundException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public String getRelativePath() {
        return this.file.getPath();
    }

    @Override
    public String getParentRelativePath() {
        return this.file.getParent();
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public long getLastModified() {
        return this.file.lastModified();
    }

    @Override
    public List<IHierarchicalContentNode> getChildNodes() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public File getFile() throws UnsupportedOperationException {
        return this.file;
    }

    @Override
    public File tryGetFile() {
        return this.file;
    }

    @Override
    public long getFileLength() throws UnsupportedOperationException {
        return this.file.length();
    }

    @Override
    public String getChecksum() throws UnsupportedOperationException {
        return null;
    }

    @Override
    public int getChecksumCRC32() throws UnsupportedOperationException {
        try {
            return (int)FileUtils.checksumCRC32((File)this.file);
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
    }

    @Override
    public boolean isChecksumCRC32Precalculated() {
        return false;
    }

    @Override
    public IRandomAccessFile getFileContent() throws UnsupportedOperationException, IOExceptionUnchecked {
        return new RandomAccessFileImpl(this.file, "r");
    }
}

