/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.common.io.hierarchical_content;

import ch.systemsx.cisd.base.io.IRandomAccessFile;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import java.io.InputStream;
import java.util.List;

public abstract class AbstractHierarchicalContentNode
implements IHierarchicalContentNode {
    static final String OPERATION_NOT_SUPPORTED_FOR_A_DIRECTORY = "Operation not supported for a directory: ";
    static final String OPERATION_SUPPORTED_ONLY_FOR_A_DIRECTORY = "Operation supported only for a directory: ";
    private String relativePath;

    protected abstract String doGetRelativePath();

    protected abstract List<IHierarchicalContentNode> doGetChildNodes();

    protected abstract long doGetFileLength();

    protected abstract int doGetChecksumCRC32();

    protected abstract IRandomAccessFile doGetFileContent();

    protected abstract InputStream doGetInputStream();

    @Override
    public final String getRelativePath() {
        if (this.relativePath == null) {
            this.relativePath = this.doGetRelativePath();
        }
        return this.relativePath;
    }

    private final void requireDirectory() {
        if (!this.isDirectory()) {
            throw new UnsupportedOperationException(OPERATION_SUPPORTED_ONLY_FOR_A_DIRECTORY + this.getRelativePath());
        }
    }

    protected boolean isPhysicalFile() {
        return !this.isDirectory();
    }

    private final void requirePhysicalFile() {
        if (this.isDirectory() && !this.isPhysicalFile()) {
            throw new UnsupportedOperationException(OPERATION_NOT_SUPPORTED_FOR_A_DIRECTORY + this.getRelativePath());
        }
    }

    private final void requireFile() {
        if (this.isDirectory() && !this.isPhysicalFile()) {
            throw new UnsupportedOperationException(OPERATION_NOT_SUPPORTED_FOR_A_DIRECTORY + this.getRelativePath());
        }
    }

    @Override
    public final List<IHierarchicalContentNode> getChildNodes() {
        this.requireDirectory();
        return this.doGetChildNodes();
    }

    @Override
    public final long getFileLength() throws UnsupportedOperationException {
        return this.doGetFileLength();
    }

    @Override
    public final int getChecksumCRC32() throws UnsupportedOperationException {
        this.requirePhysicalFile();
        return this.doGetChecksumCRC32();
    }

    @Override
    public final String getChecksum() throws UnsupportedOperationException {
        this.requireFile();
        return this.doGetChecksum();
    }

    protected String doGetChecksum() {
        return null;
    }

    @Override
    public final IRandomAccessFile getFileContent() {
        this.requirePhysicalFile();
        return this.doGetFileContent();
    }

    @Override
    public final InputStream getInputStream() {
        this.requirePhysicalFile();
        return this.doGetInputStream();
    }

    @Override
    public final String getParentRelativePath() {
        return FileUtilities.getParentRelativePath((String)this.getRelativePath());
    }
}

