/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.common.io.hierarchical_content;

import ch.systemsx.cisd.openbis.common.io.hierarchical_content.H5FolderFlags;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.HierarchicalContentUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class H5FolderChecker {
    private boolean h5FoldersDefault;
    private boolean h5arFoldersDefault;
    private Map<String, H5FolderFlags> h5FolderFlagsByTreeRoot = new HashMap<String, H5FolderFlags>();

    public H5FolderChecker(List<H5FolderFlags> h5FolderFlags) {
        if (h5FolderFlags.size() == 1) {
            this.h5FoldersDefault = h5FolderFlags.get(0).isH5Folders();
            this.h5arFoldersDefault = h5FolderFlags.get(0).isH5arFolders();
        }
        for (H5FolderFlags flags : h5FolderFlags) {
            this.h5FolderFlagsByTreeRoot.put(flags.getTreeRoot(), flags);
        }
    }

    public boolean hasOnlyDefaults() {
        return this.h5FolderFlagsByTreeRoot.isEmpty();
    }

    public boolean handleHdf5AsFolder(String relativeFilePath) {
        String treeRoot;
        H5FolderFlags flags;
        if (relativeFilePath != null && (flags = this.h5FolderFlagsByTreeRoot.get(treeRoot = relativeFilePath.split("/")[0])) != null) {
            return HierarchicalContentUtils.handleHdf5AsFolder(relativeFilePath, flags.isH5Folders(), flags.isH5arFolders());
        }
        return this.handleHdf5AsFolderByDefault(relativeFilePath);
    }

    public boolean handleHdf5AsFolderByDefault(String relativeFilePath) {
        return HierarchicalContentUtils.handleHdf5AsFolder(relativeFilePath, this.h5FoldersDefault, this.h5arFoldersDefault);
    }
}

