/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.common.io.hierarchical_content;

import ch.systemsx.cisd.common.action.IDelegatedAction;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.DefaultFileBasedHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.DefaultFileBasedHierarchicalContentNode;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.H5FolderChecker;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.H5FolderFlags;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.HDF5ContainerBasedHierarchicalContentNode;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.IHierarchicalContentFactory;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.VirtualHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

public class Hdf5AwareHierarchicalContentFactory
implements IHierarchicalContentFactory {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, Hdf5AwareHierarchicalContentFactory.class);
    private H5FolderChecker folderChecker;

    public Hdf5AwareHierarchicalContentFactory(boolean h5Folders, boolean h5arFolders) {
        this(Arrays.asList(new H5FolderFlags("", h5Folders, h5arFolders)));
    }

    public Hdf5AwareHierarchicalContentFactory(List<H5FolderFlags> h5FolderFlags) {
        this.folderChecker = new H5FolderChecker(h5FolderFlags);
    }

    @Override
    public IHierarchicalContent asVirtualHierarchicalContent(List<IHierarchicalContent> components) {
        return new VirtualHierarchicalContent(components);
    }

    @Override
    public IHierarchicalContent asHierarchicalContent(File file, IDelegatedAction onCloseAction) {
        return new DefaultFileBasedHierarchicalContent(this, file, onCloseAction);
    }

    @Override
    public IHierarchicalContentNode asHierarchicalContentNode(IHierarchicalContent rootContent, File file) {
        if (this.handleHdf5AsFolder(rootContent, file)) {
            try {
                HDF5ContainerBasedHierarchicalContentNode node = new HDF5ContainerBasedHierarchicalContentNode(rootContent, file);
                if (node.isFileAbstractionOk()) {
                    return node;
                }
            }
            catch (Exception e) {
                operationLog.warn((Object)("File " + file + " can not be opened as HDF5 container: " + e));
            }
        }
        return new DefaultFileBasedHierarchicalContentNode(this, rootContent, file);
    }

    private boolean handleHdf5AsFolder(IHierarchicalContent rootContent, File file) {
        File rootFile;
        IHierarchicalContentNode rootNode;
        if (!FileUtilities.isHDF5ContainerFile((File)file)) {
            return false;
        }
        String filename = file.getName();
        if (!this.folderChecker.hasOnlyDefaults() && (rootNode = rootContent.getRootNode()) != null && (rootFile = rootNode.tryGetFile()) != null) {
            String relativeFilePath = FileUtilities.getRelativeFilePath((File)rootFile, (File)file);
            return this.folderChecker.handleHdf5AsFolder(relativeFilePath);
        }
        return this.folderChecker.handleHdf5AsFolderByDefault(filename);
    }
}

