/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.common.io.hierarchical_content.api;

import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentExecuteOnAccess;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import java.util.ArrayList;
import java.util.List;

public class HierarchicalContentProxy
implements IHierarchicalContent {
    private final IHierarchicalContent hierarchicalContent;
    private final List<IHierarchicalContentExecuteOnAccess> executeOnAccessList;

    private HierarchicalContentProxy(IHierarchicalContent hierarchicalContent, List<IHierarchicalContentExecuteOnAccess> executeOnAccessList) {
        if (hierarchicalContent == null) {
            throw new IllegalArgumentException("hierarchicalContent was null");
        }
        this.hierarchicalContent = hierarchicalContent;
        this.executeOnAccessList = executeOnAccessList == null ? new ArrayList<IHierarchicalContentExecuteOnAccess>() : executeOnAccessList;
    }

    public static IHierarchicalContent getProxyFor(IHierarchicalContent hierarchicalContent, List<IHierarchicalContentExecuteOnAccess> executeOnAccessList) {
        if (hierarchicalContent != null) {
            HierarchicalContentProxy newIntance = new HierarchicalContentProxy(hierarchicalContent, executeOnAccessList);
            return newIntance;
        }
        return null;
    }

    public void addExecuteOnAccessMethod(IHierarchicalContentExecuteOnAccess executeOnAccessMethod) {
        this.executeOnAccessList.add(executeOnAccessMethod);
    }

    private void executeOnAccessMethods() {
        for (IHierarchicalContentExecuteOnAccess executeOnAccess : this.executeOnAccessList) {
            executeOnAccess.execute();
        }
    }

    @Override
    public IHierarchicalContentNode getRootNode() {
        this.executeOnAccessMethods();
        return this.hierarchicalContent.getRootNode();
    }

    @Override
    public IHierarchicalContentNode getNode(String relativePath) throws IllegalArgumentException {
        this.executeOnAccessMethods();
        return this.hierarchicalContent.getNode(relativePath);
    }

    @Override
    public IHierarchicalContentNode tryGetNode(String relativePath) {
        this.executeOnAccessMethods();
        return this.hierarchicalContent.tryGetNode(relativePath);
    }

    @Override
    public List<IHierarchicalContentNode> listMatchingNodes(String relativePathPattern) {
        this.executeOnAccessMethods();
        return this.hierarchicalContent.listMatchingNodes(relativePathPattern);
    }

    @Override
    public List<IHierarchicalContentNode> listMatchingNodes(String startingPath, String fileNamePattern) {
        this.executeOnAccessMethods();
        return this.hierarchicalContent.listMatchingNodes(startingPath, fileNamePattern);
    }

    @Override
    public void close() {
        this.hierarchicalContent.close();
    }

    public int hashCode() {
        return this.hierarchicalContent != null ? this.hierarchicalContent.hashCode() : 0;
    }

    public boolean equals(Object obj) {
        return this.hierarchicalContent == obj || this.hierarchicalContent != null && this.hierarchicalContent.equals(obj);
    }

    public String toString() {
        return this.hierarchicalContent.toString();
    }
}

