/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.common.spring;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.reflection.MethodUtils;
import ch.systemsx.cisd.openbis.common.logging.ServiceCallLogConfiguration;
import ch.systemsx.cisd.openbis.common.spring.IInvocationLoggerContext;
import ch.systemsx.cisd.openbis.common.spring.IInvocationLoggerFactory;
import java.io.Serializable;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.log4j.Logger;

public final class LogInterceptor
implements MethodInterceptor,
Serializable {
    private static final long serialVersionUID = 1L;

    public final Object invoke(MethodInvocation invocation) throws Throwable {
        Object wrappedObject = invocation.getThis();
        if (!(wrappedObject instanceof IInvocationLoggerFactory)) {
            throw new IllegalArgumentException("Wrapped object isn't a " + IInvocationLoggerFactory.class.getName() + ": " + wrappedObject);
        }
        IInvocationLoggerFactory loggerFactory = (IInvocationLoggerFactory)wrappedObject;
        Object[] arguments = invocation.getArguments();
        String sessionTokenOrNull = this.tryToGetSessionToken(arguments);
        InvocationLoggerContext invocationLoggerContext = new InvocationLoggerContext(sessionTokenOrNull);
        Object logger = loggerFactory.createLogger(invocationLoggerContext);
        Method method = invocation.getMethod();
        StopWatch timer = new StopWatch();
        try {
            timer.start();
            if (ServiceCallLogConfiguration.getInstance().isLogServiceCallStartEnabled()) {
                method.invoke(logger, arguments);
            }
            Object result = invocation.proceed();
            invocationLoggerContext.invocationSuccessful = true;
            Object object = result;
            return object;
        }
        catch (Throwable th) {
            this.logError(invocation, wrappedObject, th);
            throw th;
        }
        finally {
            timer.stop();
            invocationLoggerContext.invocationFinished = true;
            invocationLoggerContext.elapsedTime = timer.getTime();
            try {
                method.invoke(logger, arguments);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    private void logError(MethodInvocation invocation, Object wrappedObject, Throwable th) {
        Class<?> clazz = wrappedObject.getClass();
        Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, clazz);
        String errorMsg = String.format("An exception has occurred while processing method: '%s'.", MethodUtils.describeMethod((Method)invocation.getMethod()));
        try {
            operationLog.error((Object)errorMsg, th);
        }
        catch (Exception ex) {
            operationLog.error((Object)errorMsg);
            operationLog.error((Object)"It was not possible to log the exception which caused the problem", (Throwable)ex);
        }
    }

    private String tryToGetSessionToken(Object[] arguments) {
        if (arguments.length == 0) {
            return null;
        }
        Object firstArgument = arguments[0];
        return firstArgument instanceof String ? (String)firstArgument : null;
    }

    private static final class InvocationLoggerContext
    implements IInvocationLoggerContext {
        private final String sessionToken;
        boolean invocationFinished;
        boolean invocationSuccessful;
        long elapsedTime;

        InvocationLoggerContext(String sessionTokenOrNull) {
            this.sessionToken = sessionTokenOrNull;
        }

        @Override
        public String tryToGetSessionToken() {
            return this.sessionToken;
        }

        @Override
        public boolean invocationFinished() {
            return this.invocationFinished;
        }

        @Override
        public boolean invocationWasSuccessful() {
            return this.invocationSuccessful;
        }

        @Override
        public long getElapsedTime() {
            return this.elapsedTime;
        }
    }
}

