/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.test.server;

import ch.systemsx.cisd.common.process.ProcessExecutionHelper;
import ch.systemsx.cisd.common.process.ProcessResult;
import ch.systemsx.cisd.common.string.Template;
import ch.systemsx.cisd.dbmigration.DatabaseEngine;
import ch.systemsx.cisd.dbmigration.postgresql.DumpPreparator;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class TestDatabase {
    private static final Logger logger = Logger.getLogger(TestDatabase.class);
    private static final String CLEAN_DATABASE_PROPERTY = "ch.systemsx.cisd.openbis.test.TestDatabase.clean";
    private static final Template EXISTS_DATABASE_TEMPLATE = new Template("select count(*) from pg_database where datname = '${database-name}'");
    private static final Template DROP_DATABASE_TEMPLATE = new Template("drop database if exists ${database-name}");
    private static final Template CREATE_DATABASE_TEMPLATE = new Template("create database ${database-name} with owner ${database-owner}");

    public static void restoreDumps(String dumpFolderPathOrNull) {
        if (dumpFolderPathOrNull == null) {
            return;
        }
        File dumpFolder = new File(dumpFolderPathOrNull);
        if (dumpFolder.exists() && dumpFolder.isDirectory()) {
            File[] dumpFiles;
            for (File dumpFile : dumpFiles = dumpFolder.listFiles()) {
                TestDatabase.restoreDump(dumpFile, FilenameUtils.getBaseName((String)dumpFile.getName()));
            }
        }
    }

    public static void restoreDump(File dumpFile, String databaseName) {
        String databaseClean = System.getProperty(CLEAN_DATABASE_PROPERTY);
        if (dumpFile.isFile()) {
            String databaseOwner = System.getProperty("user.name");
            boolean databaseExists = TestDatabase.existsDatabase(databaseName);
            if (!databaseExists || databaseClean == null || databaseClean.equalsIgnoreCase("true")) {
                TestDatabase.dropDatabase(databaseName);
                TestDatabase.createEmptyDatabase(databaseOwner, databaseName);
                if (dumpFile.getName().endsWith(".sql")) {
                    TestDatabase.restoreSqlDatabaseDump(databaseOwner, databaseName, dumpFile);
                } else if (dumpFile.getName().endsWith(".dmp")) {
                    TestDatabase.restoreBinDatabaseDump(databaseOwner, databaseName, dumpFile);
                } else {
                    throw new IllegalArgumentException("Database dump format not supported: " + dumpFile.getAbsolutePath());
                }
            }
        }
    }

    private static void dropDatabase(String databaseName) {
        System.out.println("Droping database " + databaseName);
        Template template = DROP_DATABASE_TEMPLATE.createFreshCopy();
        template.bind("database-name", databaseName);
        TestDatabase.executeSql("postgres", template.createText());
    }

    private static boolean existsDatabase(String databaseName) {
        Template template = EXISTS_DATABASE_TEMPLATE.createFreshCopy();
        template.bind("database-name", databaseName);
        List<String> output = TestDatabase.executeSql("postgres", template.createText());
        Integer count = Integer.valueOf(output.get(2).trim());
        return count > 0;
    }

    private static void createEmptyDatabase(String databaseOwner, String databaseName) {
        System.out.println("Creating database " + databaseName);
        Template template = CREATE_DATABASE_TEMPLATE.createFreshCopy();
        template.bind("database-name", databaseName);
        template.bind("database-owner", databaseOwner);
        TestDatabase.executeSql("postgres", template.createText());
    }

    private static void restoreSqlDatabaseDump(String databaseOwner, String databaseName, File databaseDump) {
        System.out.println("Restoring database " + databaseName + " from an sql dump " + databaseDump.getAbsolutePath());
        String psql = DumpPreparator.getPSQLExecutable();
        List<String> command = Arrays.asList(psql, "-h", DatabaseEngine.getTestEnvironmentHostOrConfigured((String)"localhost"), "-U", databaseOwner, "-d", databaseName, "-f", databaseDump.getAbsolutePath());
        TestDatabase.executeCommand(command);
    }

    private static void restoreBinDatabaseDump(String databaseOwner, String databaseName, File databaseDump) {
        System.out.println("Restoring database " + databaseName + " from a binary dump " + databaseDump.getAbsolutePath());
        String restore = DumpPreparator.getRestoreExecutable();
        List<String> command = Arrays.asList(restore, "-h", DatabaseEngine.getTestEnvironmentHostOrConfigured((String)"localhost"), "-U", databaseOwner, "-d", databaseName, "-n", "public", "-j", "4", "-Fc", "-O", databaseDump.getAbsolutePath());
        TestDatabase.executeCommand(command);
    }

    private static List<String> executeSql(String userName, String sql) {
        String psql = DumpPreparator.getPSQLExecutable();
        List<String> command = Arrays.asList(psql, "-h", DatabaseEngine.getTestEnvironmentHostOrConfigured((String)"localhost"), "-U", userName, "-c", sql);
        return TestDatabase.executeCommand(command);
    }

    private static List<String> executeCommand(List<String> command) {
        ProcessResult run = ProcessExecutionHelper.run(command, (Logger)logger, (Logger)logger);
        if (run.isOK()) {
            if (run.isOutputAvailable()) {
                return run.getOutput();
            }
            return null;
        }
        throw new IllegalArgumentException("Couldn't execute a command: " + command + " because: " + run.getOutput());
    }
}

