/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.ipad.v2.server;

import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v2.ISearchService;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.api.IRowBuilderAdaptor;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.api.ISimpleTableModelBuilderAdaptor;
import ch.systemsx.cisd.openbis.ipad.v2.server.IRequestHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class AbstractRequestHandler
implements IRequestHandler {
    protected final Map<String, Object> parameters;
    protected final ISimpleTableModelBuilderAdaptor builder;
    protected final ISearchService searchService;
    protected final List<String> headers;

    public static void setCell(IRowBuilderAdaptor row, String key, Object value) {
        if (value instanceof String) {
            row.setCell(key, (String)value);
        } else if (value instanceof Long) {
            row.setCell(key, ((Long)value).longValue());
        } else if (value instanceof Double) {
            row.setCell(key, ((Double)value).doubleValue());
        } else if (value instanceof Date) {
            row.setCell(key, (Date)value);
        } else {
            row.setCell(key, value.toString());
        }
    }

    private static List<String> responseHeaders(List<String> optionalHeaders) {
        List<String> requiredHeaders = Arrays.asList("PERM_ID", "REFCON");
        ArrayList<String> allHeaders = new ArrayList<String>(requiredHeaders);
        allHeaders.addAll(optionalHeaders);
        return allHeaders;
    }

    protected AbstractRequestHandler(Map<String, Object> parameters, ISimpleTableModelBuilderAdaptor builder, ISearchService searchService, List<String> optionalHeaders) {
        this.parameters = parameters;
        this.builder = builder;
        this.searchService = searchService;
        this.headers = AbstractRequestHandler.responseHeaders(optionalHeaders);
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public ISimpleTableModelBuilderAdaptor getBuilder() {
        return this.builder;
    }

    public List<String> getHeaders() {
        return this.headers;
    }

    public ISearchService getSearchService() {
        return this.searchService;
    }

    protected List<String> getEntitiesParameter() {
        List entities = (List)this.parameters.get("entities");
        if (entities == null) {
            return Collections.emptyList();
        }
        return entities;
    }

    protected void retrieveData() {
    }

    protected void addDataRows() {
    }

    protected void addHeaders() {
        for (String header : this.headers) {
            this.builder.addHeader(header);
        }
    }

    protected void addRow(Map<String, Object> entry) {
        IRowBuilderAdaptor row = this.builder.addRow();
        for (String header : this.headers) {
            Object value = entry.get(header);
            if (value != null) {
                AbstractRequestHandler.setCell(row, header, value);
                continue;
            }
            row.setCell(header, "");
        }
    }

    protected void addRows(List<Map<String, Object>> entries) {
        for (Map<String, Object> entry : entries) {
            this.addRow(entry);
        }
    }

    @Override
    public void processRequest() {
        this.addHeaders();
        this.retrieveData();
        this.addDataRows();
    }
}

