/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.ipad.v2.server;

import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v2.ISearchService;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.api.IRowBuilderAdaptor;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.api.ISimpleTableModelBuilderAdaptor;
import ch.systemsx.cisd.openbis.ipad.v2.server.AbstractRequestHandler;
import ch.systemsx.cisd.openbis.ipad.v2.server.IRequestHandler;
import ch.systemsx.cisd.openbis.ipad.v2.server.IpadServiceUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClientPreferencesRequestHandler
implements IRequestHandler {
    protected final Map<String, Object> parameters;
    protected final ISimpleTableModelBuilderAdaptor builder;
    protected final List<String> headers;

    protected ClientPreferencesRequestHandler(Map<String, Object> parameters, ISimpleTableModelBuilderAdaptor builder, ISearchService searchService) {
        this.parameters = parameters;
        this.builder = builder;
        this.headers = Arrays.asList("KEY", "VALUE");
    }

    protected Map<String, Object> getPreferencesDict() {
        return this.getDefaultPreferencesDict();
    }

    protected final Map<String, Object> getDefaultPreferencesDict() {
        HashMap<String, Object> prefs = new HashMap<String, Object>();
        prefs.put("ROOT_SET_REFRESH_INTERVAL", 1800);
        prefs.put("SEARCH_DOMAINS", IpadServiceUtilities.jsonEncodedValue(this.getSearchDomains()));
        return prefs;
    }

    protected List<Map<String, String>> getSearchDomains() {
        ArrayList<Map<String, String>> searchDomains = new ArrayList<Map<String, String>>();
        searchDomains.add(this.getSearchDomain("GLOBAL", "Global"));
        if (this.areBarcodesSupported()) {
            searchDomains.add(this.getSearchDomain("BARCODE", "Barcode"));
        }
        return searchDomains;
    }

    protected boolean areBarcodesSupported() {
        return false;
    }

    protected HashMap<String, String> getSearchDomain(String key, String label) {
        HashMap<String, String> globalSearchDomain = new HashMap<String, String>();
        globalSearchDomain.put("key", key);
        globalSearchDomain.put("label", label);
        return globalSearchDomain;
    }

    protected void addDataRows() {
        Map<String, Object> prefs = this.getPreferencesDict();
        for (String key : prefs.keySet()) {
            IRowBuilderAdaptor row = this.builder.addRow();
            row.setCell("KEY", key);
            AbstractRequestHandler.setCell(row, "VALUE", prefs.get(key));
        }
    }

    protected void addHeaders() {
        for (String header : this.headers) {
            this.builder.addHeader(header);
        }
    }

    @Override
    public void processRequest() {
        this.addHeaders();
        this.addDataRows();
    }
}

