/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.ipad.v2.server;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v2.ISampleImmutable;
import ch.systemsx.cisd.openbis.ipad.v2.server.SamplesByType;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class IpadServiceUtilities {
    public static String jsonEncodedValue(Object thing) {
        try {
            return new ObjectMapper().writeValueAsString(thing);
        }
        catch (JsonGenerationException e) {
            CheckedExceptionTunnel.wrapIfNecessary((Exception)((Object)e));
        }
        catch (JsonMappingException e) {
            CheckedExceptionTunnel.wrapIfNecessary((Exception)((Object)e));
        }
        catch (IOException e) {
            CheckedExceptionTunnel.wrapIfNecessary((Exception)e);
        }
        return null;
    }

    public static String jsonEmptyList() {
        return IpadServiceUtilities.jsonEncodedValue(Collections.emptyList());
    }

    public static String jsonEmptyDict() {
        try {
            return new ObjectMapper().writeValueAsString(new HashMap());
        }
        catch (JsonGenerationException e) {
            CheckedExceptionTunnel.wrapIfNecessary((Exception)((Object)e));
        }
        catch (JsonMappingException e) {
            CheckedExceptionTunnel.wrapIfNecessary((Exception)((Object)e));
        }
        catch (IOException e) {
            CheckedExceptionTunnel.wrapIfNecessary((Exception)e);
        }
        return null;
    }

    public static SamplesByType groupSamplesByType(List<ISampleImmutable> allSamples) {
        HashMap<String, List<ISampleImmutable>> samplesByType = new HashMap<String, List<ISampleImmutable>>();
        for (ISampleImmutable sample : allSamples) {
            String sampleType = sample.getSampleType();
            List<ISampleImmutable> samples = samplesByType.get(sampleType);
            if (samples == null) {
                samples = new ArrayList<ISampleImmutable>();
                samples.add(sample);
                samplesByType.put(sampleType, samples);
                continue;
            }
            samples.add(sample);
        }
        return new SamplesByType(samplesByType);
    }
}

