/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.ipad.v2.server;

import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v2.ISearchService;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.api.ISimpleTableModelBuilderAdaptor;
import ch.systemsx.cisd.openbis.ipad.v2.server.ClientPreferencesRequestHandler;
import ch.systemsx.cisd.openbis.ipad.v2.server.EmptyDataRequestHandler;
import ch.systemsx.cisd.openbis.ipad.v2.server.IRequestHandler;
import ch.systemsx.cisd.openbis.ipad.v2.server.IRequestHandlerFactory;
import java.util.Map;

public class RequestHandlerDispatcher {
    private IRequestHandlerFactory clientPreferencesRequestHandlerFactory = new IRequestHandlerFactory(){

        @Override
        public IRequestHandler createRequestHandler(Map<String, Object> parameters, ISimpleTableModelBuilderAdaptor builder, ISearchService searchService) {
            return new ClientPreferencesRequestHandler(parameters, builder, searchService);
        }
    };
    private IRequestHandlerFactory navigationRequestHandlerFactory;
    private IRequestHandlerFactory rootRequestHandlerFactory;
    private IRequestHandlerFactory drillRequestHandlerFactory;
    private IRequestHandlerFactory detailRequestHandlerFactory;
    private IRequestHandlerFactory searchRequestHandlerFactory;
    private IRequestHandlerFactory emptyDataRequestHandlerFactory = new IRequestHandlerFactory(){

        @Override
        public IRequestHandler createRequestHandler(Map<String, Object> parameters, ISimpleTableModelBuilderAdaptor builder, ISearchService searchService) {
            return new EmptyDataRequestHandler(parameters, builder, searchService);
        }
    };

    public IRequestHandlerFactory getClientPreferencesRequestHandlerFactory() {
        return this.clientPreferencesRequestHandlerFactory;
    }

    public void setClientPreferencesRequestHandlerFactory(IRequestHandlerFactory clientPreferencesRequestHandlerFactory) {
        this.clientPreferencesRequestHandlerFactory = clientPreferencesRequestHandlerFactory;
    }

    public IRequestHandlerFactory getNavigationRequestHandlerFactory() {
        return this.navigationRequestHandlerFactory;
    }

    public void setNavigationRequestHandlerFactory(IRequestHandlerFactory navigationRequestHandlerFactory) {
        this.navigationRequestHandlerFactory = navigationRequestHandlerFactory;
    }

    public IRequestHandlerFactory getRootRequestHandlerFactory() {
        return this.rootRequestHandlerFactory;
    }

    public void setRootRequestHandlerFactory(IRequestHandlerFactory rootRequestHandlerFactory) {
        this.rootRequestHandlerFactory = rootRequestHandlerFactory;
    }

    public IRequestHandlerFactory getDrillRequestHandlerFactory() {
        return this.drillRequestHandlerFactory;
    }

    public void setDrillRequestHandlerFactory(IRequestHandlerFactory drillRequestHandlerFactory) {
        this.drillRequestHandlerFactory = drillRequestHandlerFactory;
    }

    public IRequestHandlerFactory getDetailRequestHandlerFactory() {
        return this.detailRequestHandlerFactory;
    }

    public void setDetailRequestHandlerFactory(IRequestHandlerFactory detailRequestHandlerFactory) {
        this.detailRequestHandlerFactory = detailRequestHandlerFactory;
    }

    public IRequestHandlerFactory getSearchRequestHandlerFactory() {
        return this.searchRequestHandlerFactory;
    }

    public void setSearchRequestHandlerFactory(IRequestHandlerFactory searchRequestHandlerFactory) {
        this.searchRequestHandlerFactory = searchRequestHandlerFactory;
    }

    public IRequestHandlerFactory getEmptyDataRequestHandlerFactory() {
        return this.emptyDataRequestHandlerFactory;
    }

    public void setEmptyDataRequestHandlerFactory(IRequestHandlerFactory emptyDataRequestHandlerFactory) {
        this.emptyDataRequestHandlerFactory = emptyDataRequestHandlerFactory;
    }

    public void dispatch(Map<String, Object> parameters, ISimpleTableModelBuilderAdaptor builder, ISearchService searchService) {
        RequestType requestType = this.tryRequestType(parameters);
        IRequestHandlerFactory handlerFactory = this.getHandlerFactory(requestType);
        handlerFactory.createRequestHandler(parameters, builder, searchService).processRequest();
    }

    protected RequestType tryRequestType(Map<String, Object> parameters) {
        RequestType requestType;
        String requestKey = (String)parameters.get("requestKey");
        if (requestKey == null) {
            return null;
        }
        try {
            requestType = RequestType.valueOf(requestKey);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            requestType = null;
        }
        return requestType;
    }

    protected IRequestHandlerFactory getHandlerFactory(RequestType requestType) {
        IRequestHandlerFactory handlerFactory;
        if (requestType == null) {
            return this.emptyDataRequestHandlerFactory;
        }
        switch (requestType) {
            case CLIENT_PREFS: {
                handlerFactory = this.clientPreferencesRequestHandlerFactory;
                break;
            }
            case DETAIL: {
                handlerFactory = this.detailRequestHandlerFactory;
                break;
            }
            case DRILL: {
                handlerFactory = this.drillRequestHandlerFactory;
                break;
            }
            case NAVIGATION: {
                handlerFactory = this.navigationRequestHandlerFactory;
                break;
            }
            case ROOT: {
                handlerFactory = this.rootRequestHandlerFactory;
                break;
            }
            case SEARCH: {
                handlerFactory = this.searchRequestHandlerFactory;
                break;
            }
            default: {
                handlerFactory = this.emptyDataRequestHandlerFactory;
            }
        }
        return handlerFactory != null ? handlerFactory : this.emptyDataRequestHandlerFactory;
    }

    public static enum RequestType {
        CLIENT_PREFS,
        NAVIGATION,
        ROOT,
        DRILL,
        DETAIL,
        SEARCH;

    }
}

