/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.dataprovider;

import com.lyncode.builder.Builder;
import org.apache.log4j.Logger;
import org.dspace.xoai.dataprovider.exceptions.BadArgumentException;
import org.dspace.xoai.dataprovider.exceptions.BadResumptionToken;
import org.dspace.xoai.dataprovider.exceptions.DuplicateDefinitionException;
import org.dspace.xoai.dataprovider.exceptions.HandlerException;
import org.dspace.xoai.dataprovider.exceptions.IllegalVerbException;
import org.dspace.xoai.dataprovider.exceptions.OAIException;
import org.dspace.xoai.dataprovider.exceptions.UnknownParameterException;
import org.dspace.xoai.dataprovider.handlers.ErrorHandler;
import org.dspace.xoai.dataprovider.handlers.GetRecordHandler;
import org.dspace.xoai.dataprovider.handlers.IdentifyHandler;
import org.dspace.xoai.dataprovider.handlers.ListIdentifiersHandler;
import org.dspace.xoai.dataprovider.handlers.ListMetadataFormatsHandler;
import org.dspace.xoai.dataprovider.handlers.ListRecordsHandler;
import org.dspace.xoai.dataprovider.handlers.ListSetsHandler;
import org.dspace.xoai.dataprovider.model.Context;
import org.dspace.xoai.dataprovider.parameters.OAICompiledRequest;
import org.dspace.xoai.dataprovider.parameters.OAIRequest;
import org.dspace.xoai.dataprovider.repository.Repository;
import org.dspace.xoai.exceptions.InvalidResumptionTokenException;
import org.dspace.xoai.model.oaipmh.OAIPMH;
import org.dspace.xoai.model.oaipmh.Request;
import org.dspace.xoai.model.oaipmh.Verb;
import org.dspace.xoai.services.api.DateProvider;
import org.dspace.xoai.services.impl.UTCDateProvider;

public class DataProvider {
    private static Logger log = Logger.getLogger(DataProvider.class);
    private Repository repository;
    private DateProvider dateProvider;
    private final IdentifyHandler identifyHandler;
    private final GetRecordHandler getRecordHandler;
    private final ListSetsHandler listSetsHandler;
    private final ListRecordsHandler listRecordsHandler;
    private final ListIdentifiersHandler listIdentifiersHandler;
    private final ListMetadataFormatsHandler listMetadataFormatsHandler;
    private final ErrorHandler errorsHandler;

    public static DataProvider dataProvider(Context context, Repository repository) {
        return new DataProvider(context, repository);
    }

    public DataProvider(Context context, Repository repository) {
        this.repository = repository;
        this.dateProvider = new UTCDateProvider();
        this.identifyHandler = new IdentifyHandler(context, repository);
        this.listSetsHandler = new ListSetsHandler(context, repository);
        this.listMetadataFormatsHandler = new ListMetadataFormatsHandler(context, repository);
        this.listRecordsHandler = new ListRecordsHandler(context, repository);
        this.listIdentifiersHandler = new ListIdentifiersHandler(context, repository);
        this.getRecordHandler = new GetRecordHandler(context, repository);
        this.errorsHandler = new ErrorHandler();
    }

    public OAIPMH handle(Builder<OAIRequest> builder) throws OAIException {
        return this.handle((OAIRequest)builder.build());
    }

    public OAIPMH handle(OAIRequest requestParameters) throws OAIException {
        log.debug((Object)"Starting handling OAI request");
        Request request = new Request(this.repository.getConfiguration().getBaseUrl()).withVerbType(requestParameters.get(OAIRequest.Parameter.Verb)).withResumptionToken(requestParameters.get(OAIRequest.Parameter.ResumptionToken)).withIdentifier(requestParameters.get(OAIRequest.Parameter.Identifier)).withMetadataPrefix(requestParameters.get(OAIRequest.Parameter.MetadataPrefix)).withSet(requestParameters.get(OAIRequest.Parameter.Set)).withFrom(requestParameters.get(OAIRequest.Parameter.From)).withUntil(requestParameters.get(OAIRequest.Parameter.Until));
        OAIPMH response = new OAIPMH().withRequest(request).withResponseDate(this.dateProvider.now());
        try {
            OAICompiledRequest parameters = this.compileParameters(requestParameters);
            switch (request.getVerbType()) {
                case Identify: {
                    response.withVerb((Verb)this.identifyHandler.handle(parameters));
                    break;
                }
                case ListSets: {
                    response.withVerb((Verb)this.listSetsHandler.handle(parameters));
                    break;
                }
                case ListMetadataFormats: {
                    response.withVerb((Verb)this.listMetadataFormatsHandler.handle(parameters));
                    break;
                }
                case GetRecord: {
                    response.withVerb((Verb)this.getRecordHandler.handle(parameters));
                    break;
                }
                case ListIdentifiers: {
                    response.withVerb((Verb)this.listIdentifiersHandler.handle(parameters));
                    break;
                }
                case ListRecords: {
                    response.withVerb((Verb)this.listRecordsHandler.handle(parameters));
                }
            }
        }
        catch (HandlerException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            response.withError(this.errorsHandler.handle(e));
        }
        return response;
    }

    private OAICompiledRequest compileParameters(OAIRequest requestParameters) throws IllegalVerbException, UnknownParameterException, BadArgumentException, DuplicateDefinitionException, BadResumptionToken {
        try {
            return requestParameters.compile();
        }
        catch (InvalidResumptionTokenException e) {
            throw new BadResumptionToken("The resumption token is invalid");
        }
    }
}

