/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.dataprovider.handlers.helpers;

import com.lyncode.xml.exceptions.XmlWriteException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.dspace.xoai.dataprovider.filter.FilterResolver;
import org.dspace.xoai.dataprovider.handlers.helpers.ItemIdentifyHelper;
import org.dspace.xoai.dataprovider.model.Context;
import org.dspace.xoai.dataprovider.model.Item;
import org.dspace.xoai.dataprovider.model.Set;
import org.dspace.xoai.xml.XmlWriter;

public class ItemHelper
extends ItemIdentifyHelper {
    private Item item;

    public ItemHelper(Item item) {
        super(item);
        this.item = item;
    }

    public Item getItem() {
        return this.item;
    }

    public InputStream toStream() throws XMLStreamException, XmlWriteException {
        if (this.item.getMetadata() != null) {
            return new ByteArrayInputStream(this.item.getMetadata().toString().getBytes());
        }
        ByteArrayOutputStream mdOUT = new ByteArrayOutputStream();
        XmlWriter writer = new XmlWriter((OutputStream)mdOUT);
        this.item.getMetadata().write(writer);
        writer.flush();
        writer.close();
        return new ByteArrayInputStream(mdOUT.toByteArray());
    }

    public List<Set> getSets(Context context, FilterResolver resolver) {
        ArrayList<Set> result = new ArrayList<Set>();
        for (Set set : context.getSets()) {
            if (!set.getCondition().getFilter(resolver).isItemShown(this.item)) continue;
            result.add(set);
        }
        result.addAll(this.item.getSets());
        return result;
    }
}

