/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.dataprovider.handlers.helpers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.dspace.xoai.dataprovider.exceptions.CannotDisseminateFormatException;
import org.dspace.xoai.dataprovider.exceptions.IdDoesNotExistException;
import org.dspace.xoai.dataprovider.exceptions.OAIException;
import org.dspace.xoai.dataprovider.filter.Scope;
import org.dspace.xoai.dataprovider.filter.ScopedFilter;
import org.dspace.xoai.dataprovider.handlers.results.ListItemIdentifiersResult;
import org.dspace.xoai.dataprovider.handlers.results.ListItemsResults;
import org.dspace.xoai.dataprovider.model.Context;
import org.dspace.xoai.dataprovider.model.Item;
import org.dspace.xoai.dataprovider.model.MetadataFormat;
import org.dspace.xoai.dataprovider.repository.ItemRepository;

public class ItemRepositoryHelper {
    private ItemRepository itemRepository;

    public ItemRepositoryHelper(ItemRepository itemRepository) {
        this.itemRepository = itemRepository;
    }

    public ListItemIdentifiersResult getItemIdentifiers(Context context, int offset, int length, String metadataPrefix) throws CannotDisseminateFormatException, OAIException {
        return this.itemRepository.getItemIdentifiers(this.getScopedFilters(context, metadataPrefix), offset, length);
    }

    public ListItemIdentifiersResult getItemIdentifiers(Context context, int offset, int length, String metadataPrefix, Date from) throws CannotDisseminateFormatException, OAIException {
        List<ScopedFilter> filters = this.getScopedFilters(context, metadataPrefix);
        return this.itemRepository.getItemIdentifiers(filters, offset, length, from);
    }

    private List<ScopedFilter> getScopedFilters(Context context, String metadataPrefix) throws CannotDisseminateFormatException {
        MetadataFormat metadataFormat;
        ArrayList<ScopedFilter> filters = new ArrayList<ScopedFilter>();
        if (context.hasCondition()) {
            filters.add(new ScopedFilter(context.getCondition(), Scope.Context));
        }
        if ((metadataFormat = context.formatForPrefix(metadataPrefix)).hasCondition()) {
            filters.add(new ScopedFilter(metadataFormat.getCondition(), Scope.MetadataFormat));
        }
        return filters;
    }

    public ListItemIdentifiersResult getItemIdentifiersUntil(Context context, int offset, int length, String metadataPrefix, Date until) throws CannotDisseminateFormatException, OAIException {
        List<ScopedFilter> filters = this.getScopedFilters(context, metadataPrefix);
        return this.itemRepository.getItemIdentifiersUntil(filters, offset, length, until);
    }

    public ListItemIdentifiersResult getItemIdentifiers(Context context, int offset, int length, String metadataPrefix, Date from, Date until) throws CannotDisseminateFormatException, OAIException {
        return this.itemRepository.getItemIdentifiers(this.getScopedFilters(context, metadataPrefix), offset, length, from, until);
    }

    public ListItemIdentifiersResult getItemIdentifiers(Context context, int offset, int length, String metadataPrefix, String setSpec) throws CannotDisseminateFormatException, OAIException {
        List<ScopedFilter> filters = this.getScopedFilters(context, metadataPrefix);
        if (context.isStaticSet(setSpec)) {
            filters.add(new ScopedFilter(context.getSet(setSpec).getCondition(), Scope.Set));
            return this.itemRepository.getItemIdentifiers(filters, offset, length);
        }
        return this.itemRepository.getItemIdentifiers(filters, offset, length, setSpec);
    }

    public ListItemIdentifiersResult getItemIdentifiers(Context context, int offset, int length, String metadataPrefix, String setSpec, Date from) throws CannotDisseminateFormatException, OAIException {
        List<ScopedFilter> filters = this.getScopedFilters(context, metadataPrefix);
        if (context.isStaticSet(setSpec)) {
            filters.add(new ScopedFilter(context.getSet(setSpec).getCondition(), Scope.Set));
            return this.itemRepository.getItemIdentifiers(filters, offset, length, from);
        }
        return this.itemRepository.getItemIdentifiers(filters, offset, length, setSpec, from);
    }

    public ListItemIdentifiersResult getItemIdentifiersUntil(Context context, int offset, int length, String metadataPrefix, String setSpec, Date until) throws CannotDisseminateFormatException, OAIException {
        List<ScopedFilter> filters = this.getScopedFilters(context, metadataPrefix);
        if (context.isStaticSet(setSpec)) {
            filters.add(new ScopedFilter(context.getSet(setSpec).getCondition(), Scope.Set));
            return this.itemRepository.getItemIdentifiersUntil(filters, offset, length, until);
        }
        return this.itemRepository.getItemIdentifiersUntil(filters, offset, length, setSpec, until);
    }

    public ListItemIdentifiersResult getItemIdentifiers(Context context, int offset, int length, String metadataPrefix, String setSpec, Date from, Date until) throws CannotDisseminateFormatException, OAIException {
        List<ScopedFilter> filters = this.getScopedFilters(context, metadataPrefix);
        if (context.isStaticSet(setSpec)) {
            filters.add(new ScopedFilter(context.getSet(setSpec).getCondition(), Scope.Set));
            return this.itemRepository.getItemIdentifiers(filters, offset, length, from, until);
        }
        return this.itemRepository.getItemIdentifiers(filters, offset, length, setSpec, from, until);
    }

    public ListItemsResults getItems(Context context, int offset, int length, String metadataPrefix) throws CannotDisseminateFormatException, OAIException {
        List<ScopedFilter> filters = this.getScopedFilters(context, metadataPrefix);
        return this.itemRepository.getItems(filters, offset, length);
    }

    public ListItemsResults getItems(Context context, int offset, int length, String metadataPrefix, Date from) throws CannotDisseminateFormatException, OAIException {
        List<ScopedFilter> filters = this.getScopedFilters(context, metadataPrefix);
        return this.itemRepository.getItems(filters, offset, length, from);
    }

    public ListItemsResults getItemsUntil(Context context, int offset, int length, String metadataPrefix, Date until) throws CannotDisseminateFormatException, OAIException {
        List<ScopedFilter> filters = this.getScopedFilters(context, metadataPrefix);
        return this.itemRepository.getItemsUntil(filters, offset, length, until);
    }

    public ListItemsResults getItems(Context context, int offset, int length, String metadataPrefix, Date from, Date until) throws CannotDisseminateFormatException, OAIException {
        List<ScopedFilter> filters = this.getScopedFilters(context, metadataPrefix);
        return this.itemRepository.getItems(filters, offset, length, from, until);
    }

    public ListItemsResults getItems(Context context, int offset, int length, String metadataPrefix, String setSpec) throws CannotDisseminateFormatException, OAIException {
        List<ScopedFilter> filters = this.getScopedFilters(context, metadataPrefix);
        if (context.isStaticSet(setSpec)) {
            filters.add(new ScopedFilter(context.getSet(setSpec).getCondition(), Scope.Set));
            return this.itemRepository.getItems(filters, offset, length);
        }
        return this.itemRepository.getItems(filters, offset, length, setSpec);
    }

    public ListItemsResults getItems(Context context, int offset, int length, String metadataPrefix, String setSpec, Date from) throws CannotDisseminateFormatException, OAIException {
        List<ScopedFilter> filters = this.getScopedFilters(context, metadataPrefix);
        if (context.isStaticSet(setSpec)) {
            filters.add(new ScopedFilter(context.getSet(setSpec).getCondition(), Scope.Set));
            return this.itemRepository.getItems(filters, offset, length, from);
        }
        return this.itemRepository.getItems(filters, offset, length, setSpec, from);
    }

    public ListItemsResults getItemsUntil(Context context, int offset, int length, String metadataPrefix, String setSpec, Date until) throws CannotDisseminateFormatException, OAIException {
        List<ScopedFilter> filters = this.getScopedFilters(context, metadataPrefix);
        if (context.isStaticSet(setSpec)) {
            filters.add(new ScopedFilter(context.getSet(setSpec).getCondition(), Scope.Set));
            return this.itemRepository.getItemsUntil(filters, offset, length, until);
        }
        return this.itemRepository.getItemsUntil(filters, offset, length, setSpec, until);
    }

    public ListItemsResults getItems(Context context, int offset, int length, String metadataPrefix, String setSpec, Date from, Date until) throws CannotDisseminateFormatException, OAIException {
        List<ScopedFilter> filters = this.getScopedFilters(context, metadataPrefix);
        if (context.isStaticSet(setSpec)) {
            filters.add(new ScopedFilter(context.getSet(setSpec).getCondition(), Scope.Set));
            return this.itemRepository.getItems(filters, offset, length, from, until);
        }
        return this.itemRepository.getItems(filters, offset, length, setSpec, from, until);
    }

    public Item getItem(String identifier) throws IdDoesNotExistException, OAIException {
        return this.itemRepository.getItem(identifier);
    }
}

