/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.dataprovider.model;

import com.google.common.base.Function;
import com.lyncode.builder.ListBuilder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.RandomStringUtils;
import org.dspace.xoai.dataprovider.model.Item;
import org.dspace.xoai.dataprovider.model.Set;
import org.dspace.xoai.model.oaipmh.About;
import org.dspace.xoai.model.oaipmh.Metadata;
import org.dspace.xoai.model.xoai.Element;
import org.dspace.xoai.model.xoai.XOAIMetadata;

public class InMemoryItem
implements Item {
    private Map<String, Object> values = new HashMap<String, Object>();

    public static InMemoryItem item() {
        return new InMemoryItem();
    }

    public static InMemoryItem randomItem() {
        return new InMemoryItem().with("identifier", RandomStringUtils.randomAlphabetic((int)10)).with("datestamp", new Date()).with("sets", new ListBuilder().add((Object[])new String[]{RandomStringUtils.randomAlphabetic((int)3)}).build()).with("deleted", Integer.parseInt(RandomStringUtils.randomNumeric((int)1)) > 5);
    }

    public InMemoryItem with(String name, Object value) {
        this.values.put(name, value);
        return this;
    }

    public InMemoryItem withSet(String name) {
        ((List)this.values.get("sets")).add(name);
        return this;
    }

    @Override
    public List<About> getAbout() {
        return new ArrayList<About>();
    }

    @Override
    public Metadata getMetadata() {
        return new Metadata(this.toMetadata());
    }

    private XOAIMetadata toMetadata() {
        XOAIMetadata builder = new XOAIMetadata();
        for (String key : this.values.keySet()) {
            Element elementBuilder = new Element(key);
            Object value = this.values.get(key);
            if (value instanceof String) {
                elementBuilder.withField(key, (String)value);
            } else if (value instanceof Date) {
                elementBuilder.withField(key, ((Date)value).toString());
            } else if (value instanceof List) {
                List obj = (List)value;
                int i = 1;
                for (String e : obj) {
                    elementBuilder.withField(key + i++, e);
                }
            }
            builder.withElement(elementBuilder);
        }
        return builder;
    }

    @Override
    public String getIdentifier() {
        return (String)this.values.get("identifier");
    }

    @Override
    public Date getDatestamp() {
        return (Date)this.values.get("datestamp");
    }

    @Override
    public List<Set> getSets() {
        List list = (List)this.values.get("sets");
        return new ListBuilder().add((Object[])list.toArray(new String[list.size()])).build((Function)new Function<String, Set>(){

            public Set apply(String elem) {
                return new Set(elem);
            }
        });
    }

    @Override
    public boolean isDeleted() {
        return (Boolean)this.values.get("deleted");
    }

    public InMemoryItem withDefaults() {
        this.with("identifier", RandomStringUtils.randomAlphabetic((int)10)).with("datestamp", new Date()).with("sets", new ListBuilder().add((Object[])new String[]{RandomStringUtils.randomAlphabetic((int)3)}).build()).with("deleted", Integer.parseInt(RandomStringUtils.randomNumeric((int)1)) > 5);
        return this;
    }

    public InMemoryItem withIdentifier(String identifier) {
        this.with("identifier", identifier);
        return this;
    }
}

