/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.dataprovider.model;

import java.util.ArrayList;
import java.util.List;
import org.dspace.xoai.dataprovider.model.conditions.Condition;
import org.dspace.xoai.model.xoai.XOAIMetadata;

public class Set {
    private final String spec;
    private String name;
    private List<XOAIMetadata> descriptions = new ArrayList<XOAIMetadata>();
    private Condition condition;

    public static Set set(String spec) {
        return new Set(spec);
    }

    public Set(String spec) {
        this.spec = spec;
    }

    public String getName() {
        return this.name;
    }

    public Set withName(String name) {
        this.name = name;
        return this;
    }

    public List<XOAIMetadata> getDescriptions() {
        return this.descriptions;
    }

    public Set withDescription(XOAIMetadata description) {
        this.descriptions.add(description);
        return this;
    }

    public boolean hasDescription() {
        return !this.descriptions.isEmpty();
    }

    public Condition getCondition() {
        return this.condition;
    }

    public boolean hasCondition() {
        return this.condition != null;
    }

    public Set withCondition(Condition condition) {
        this.condition = condition;
        return this;
    }

    public String getSpec() {
        return this.spec;
    }

    public org.dspace.xoai.model.oaipmh.Set toOAIPMH() {
        org.dspace.xoai.model.oaipmh.Set set = new org.dspace.xoai.model.oaipmh.Set();
        set.withName(this.getName());
        set.withSpec(this.getSpec());
        for (XOAIMetadata description : this.descriptions) {
            set.withDescription(description);
        }
        return set;
    }
}

