/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.dataprovider.parameters;

import com.lyncode.builder.Builder;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.dspace.xoai.dataprovider.exceptions.BadArgumentException;
import org.dspace.xoai.dataprovider.exceptions.DuplicateDefinitionException;
import org.dspace.xoai.dataprovider.exceptions.IllegalVerbException;
import org.dspace.xoai.dataprovider.exceptions.UnknownParameterException;
import org.dspace.xoai.dataprovider.parameters.OAIRequest;
import org.dspace.xoai.exceptions.InvalidResumptionTokenException;
import org.dspace.xoai.model.oaipmh.ResumptionToken;
import org.dspace.xoai.model.oaipmh.Verb;
import org.dspace.xoai.services.api.DateProvider;
import org.dspace.xoai.services.api.ResumptionTokenFormat;
import org.dspace.xoai.services.impl.SimpleResumptionTokenFormat;
import org.dspace.xoai.services.impl.UTCDateProvider;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class OAICompiledRequest {
    private static Logger log = LogManager.getLogger(OAICompiledRequest.class);
    private static DateProvider dateProvider = new UTCDateProvider();
    private Verb.Type verbType;
    private ResumptionToken.Value resumptionToken = null;
    private String identifier;
    private String metadataPrefix;
    private String set;
    private Date until;
    private Date from;

    public static OAICompiledRequest compile(OAIRequest request) throws BadArgumentException, InvalidResumptionTokenException, UnknownParameterException, IllegalVerbException, DuplicateDefinitionException {
        return new OAICompiledRequest(request);
    }

    public static OAICompiledRequest compile(OAIRequest request, ResumptionTokenFormat formatter) throws BadArgumentException, InvalidResumptionTokenException, UnknownParameterException, IllegalVerbException, DuplicateDefinitionException {
        return new OAICompiledRequest(request, formatter);
    }

    public static OAICompiledRequest compile(Builder<OAIRequest> request) throws BadArgumentException, InvalidResumptionTokenException, UnknownParameterException, IllegalVerbException, DuplicateDefinitionException {
        return new OAICompiledRequest((OAIRequest)request.build());
    }

    public static OAICompiledRequest compile(Builder<OAIRequest> request, ResumptionTokenFormat formatter) throws BadArgumentException, InvalidResumptionTokenException, UnknownParameterException, IllegalVerbException, DuplicateDefinitionException {
        return new OAICompiledRequest((OAIRequest)request.build(), formatter);
    }

    private OAICompiledRequest(OAIRequest request) throws IllegalVerbException, BadArgumentException, UnknownParameterException, DuplicateDefinitionException, InvalidResumptionTokenException {
        this(request, (ResumptionTokenFormat)new SimpleResumptionTokenFormat());
    }

    private OAICompiledRequest(OAIRequest request, ResumptionTokenFormat resumptionTokenFormat) throws IllegalVerbException, BadArgumentException, UnknownParameterException, DuplicateDefinitionException, InvalidResumptionTokenException {
        Collection<String> parameterNames = request.getParameterNames();
        if (this.isTrueThat(parameterNames, CoreMatchers.not((Matcher)CoreMatchers.hasItem((Matcher)CoreMatchers.equalTo((Object)"verb"))))) {
            throw new IllegalVerbException("No verb provided");
        }
        for (String parameterName : parameterNames) {
            if (!this.isTrueThat(parameterName, CoreMatchers.not(this.in("verb", "from", "until", "metadataPrefix", "identifier", "set", "resumptionToken")))) continue;
            throw new UnknownParameterException("Unknown parameter '" + parameterName + "'");
        }
        String until = request.getString(OAIRequest.Parameter.Until);
        String from = request.getString(OAIRequest.Parameter.From);
        if (this.isTrueThat(until, CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()))) && this.isTrueThat(from, CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()))) && from.length() != until.length()) {
            throw new BadArgumentException("Distinct granularities provided for until and from parameters");
        }
        this.verbType = request.getVerb();
        this.from = request.getDate(OAIRequest.Parameter.From);
        this.until = request.getDate(OAIRequest.Parameter.Until);
        this.metadataPrefix = request.getString(OAIRequest.Parameter.MetadataPrefix);
        this.set = request.getString(OAIRequest.Parameter.Set);
        this.identifier = request.getString(OAIRequest.Parameter.Identifier);
        this.resumptionToken = request.has(OAIRequest.Parameter.ResumptionToken) ? resumptionTokenFormat.parse(request.getString(OAIRequest.Parameter.ResumptionToken)) : new ResumptionToken.Value();
        this.validate();
        this.loadResumptionToken(this.resumptionToken);
    }

    private Matcher<String> in(final String ... possibilities) {
        return new TypeSafeMatcher<String>(){

            protected boolean matchesSafely(String item) {
                for (String possibility : possibilities) {
                    if (!possibility.equals(item)) continue;
                    return true;
                }
                return false;
            }

            public void describeTo(Description description) {
                description.appendText("in");
            }
        };
    }

    private <T> boolean isTrueThat(T value, Matcher<T> matcher) {
        return matcher.matches(value);
    }

    public boolean hasResumptionToken() {
        return this.resumptionToken != null && !this.resumptionToken.isEmpty();
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public boolean hasIdentifier() {
        return this.identifier != null;
    }

    public String getMetadataPrefix() {
        return this.metadataPrefix;
    }

    public boolean hasMetadataPrefix() {
        return this.metadataPrefix != null;
    }

    public String getSet() {
        return this.set;
    }

    public boolean hasSet() {
        return this.set != null;
    }

    public boolean hasFrom() {
        return this.from != null;
    }

    public boolean hasUntil() {
        return this.until != null;
    }

    private Date getDate(String date, String param) throws BadArgumentException {
        if (date == null) {
            return null;
        }
        try {
            return dateProvider.parse(date);
        }
        catch (ParseException e) {
            throw new BadArgumentException("The " + param + " parameter given is not valid");
        }
    }

    public Date getFrom() {
        return this.from;
    }

    public ResumptionToken.Value getResumptionToken() {
        return this.resumptionToken;
    }

    public Date getUntil() {
        return this.until;
    }

    public Verb.Type getVerbType() {
        return this.verbType;
    }

    private void validate() throws IllegalVerbException, BadArgumentException {
        if (this.hasResumptionToken() && (this.hasFrom() || this.hasSet() || this.hasUntil() || this.hasMetadataPrefix())) {
            throw new BadArgumentException("ResumptionToken cannot be sent together with from, until, metadataPrefix or set parameters");
        }
        switch (this.getVerbType()) {
            case Identify: {
                if (!this.hasIdentifier() && !this.hasResumptionToken() && !this.hasSet() && !this.hasMetadataPrefix() && !this.hasFrom() && !this.hasUntil()) break;
                throw new BadArgumentException("Identify verb does not accept any extra parameter");
            }
            case ListMetadataFormats: {
                if (!this.hasResumptionToken() && !this.hasSet() && !this.hasMetadataPrefix() && !this.hasFrom() && !this.hasUntil()) break;
                throw new BadArgumentException("ListMetadataFormats verb only accepts one optional parameter - identifier");
            }
            case ListSets: {
                if (!this.hasIdentifier() && !this.hasSet() && !this.hasMetadataPrefix() && !this.hasFrom() && !this.hasUntil()) break;
                throw new BadArgumentException("ListSets verb only accepts one optional parameter - resumptionTokenResolver");
            }
            case GetRecord: {
                if (!this.hasIdentifier() || !this.hasMetadataPrefix() || this.hasSet() || this.hasFrom() || this.hasUntil()) {
                    throw new BadArgumentException("GetRecord verb requires the use of the parameters - identifier and metadataPrefix");
                }
                if (!this.hasResumptionToken()) break;
                throw new BadArgumentException("GetRecord verb does not accept the resumptionTokenResolver parameter. It requires the use of the parameters - identifier and metadataPrefix");
            }
            case ListIdentifiers: {
                if (!this.hasResumptionToken() && !this.hasMetadataPrefix()) {
                    throw new BadArgumentException("ListIdentifiers verb must receive the metadataPrefix parameter");
                }
                if (this.hasIdentifier()) {
                    throw new BadArgumentException("ListIdentifiers verb does not accept the identifier parameter");
                }
                if (!this.hasFrom() || !this.hasUntil()) break;
                this.validateDates();
                break;
            }
            case ListRecords: {
                if (!this.hasResumptionToken() && !this.hasMetadataPrefix()) {
                    throw new BadArgumentException("ListRecords verb must receive the metadataPrefix parameter");
                }
                if (this.hasIdentifier()) {
                    throw new BadArgumentException("ListRecords verb does not accept the identifier parameter");
                }
                if (!this.hasFrom() || !this.hasUntil()) break;
                this.validateDates();
            }
        }
    }

    private void validateDates() throws BadArgumentException {
        Calendar from = Calendar.getInstance();
        Calendar until = Calendar.getInstance();
        from.setTime(this.from);
        until.setTime(this.until);
        if (from.after(until)) {
            throw new BadArgumentException("The 'from' date must be less then the 'until' one");
        }
    }

    private void loadResumptionToken(ResumptionToken.Value resumptionToken) {
        if (resumptionToken.hasFrom()) {
            this.from = resumptionToken.getFrom();
        }
        if (resumptionToken.hasMetadataPrefix()) {
            this.metadataPrefix = resumptionToken.getMetadataPrefix();
        }
        if (resumptionToken.hasSetSpec()) {
            this.set = resumptionToken.getSetSpec();
        }
        if (resumptionToken.hasUntil()) {
            this.until = resumptionToken.getUntil();
        }
    }

    public ResumptionToken.Value extractResumptionToken() {
        return new ResumptionToken.Value().withOffset(0L).withMetadataPrefix(this.metadataPrefix).withSetSpec(this.set).withFrom(this.from).withUntil(this.until);
    }
}

