/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.dataprovider.parameters;

import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.dspace.xoai.dataprovider.exceptions.BadArgumentException;
import org.dspace.xoai.dataprovider.exceptions.DuplicateDefinitionException;
import org.dspace.xoai.dataprovider.exceptions.IllegalVerbException;
import org.dspace.xoai.dataprovider.exceptions.UnknownParameterException;
import org.dspace.xoai.dataprovider.parameters.OAICompiledRequest;
import org.dspace.xoai.exceptions.InvalidResumptionTokenException;
import org.dspace.xoai.model.oaipmh.Verb;
import org.dspace.xoai.services.api.DateProvider;
import org.dspace.xoai.services.impl.UTCDateProvider;

public class OAIRequest {
    private Map<String, List<String>> map;
    private DateProvider dateProvider = new UTCDateProvider();

    public OAIRequest(Map<String, List<String>> map) {
        this.map = map;
    }

    public void validate(Parameter parameter) throws IllegalVerbException, DuplicateDefinitionException {
        List<String> values = this.map.get((Object)parameter);
        if (values != null && !values.isEmpty()) {
            if (parameter == Parameter.Verb) {
                if (values.size() > 1) {
                    throw new IllegalVerbException("Illegal verb");
                }
            } else if (values.size() > 1) {
                throw new DuplicateDefinitionException("Duplicate definition of parameter '" + (Object)((Object)parameter) + "'");
            }
        }
    }

    public boolean has(Parameter parameter) {
        return this.get(parameter) != null;
    }

    public String get(Parameter parameter) {
        List<String> values = this.map.get(parameter.toString());
        if (values == null || values.isEmpty()) {
            return null;
        }
        String value = values.get(0);
        return "".equals(value) ? null : value;
    }

    public Date getDate(Parameter parameter) throws BadArgumentException {
        if (!this.has(parameter)) {
            return null;
        }
        try {
            return this.dateProvider.parse(this.get(parameter));
        }
        catch (ParseException e) {
            throw new BadArgumentException("The " + (Object)((Object)parameter) + " parameter given is not valid");
        }
    }

    public String getString(Parameter parameter) throws DuplicateDefinitionException, IllegalVerbException {
        if (!this.has(parameter)) {
            return null;
        }
        this.validate(parameter);
        return this.get(parameter);
    }

    public Verb.Type getVerb() throws DuplicateDefinitionException, IllegalVerbException {
        this.validate(Parameter.Verb);
        String verb = this.get(Parameter.Verb);
        if (verb == null) {
            throw new IllegalVerbException("The verb given by the request is null, assuming identify");
        }
        try {
            return Verb.Type.fromValue((String)verb);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalVerbException("The verb given by the request is unknown, assuming identify");
        }
    }

    public Collection<String> getParameterNames() {
        return this.map.keySet();
    }

    public OAICompiledRequest compile() throws IllegalVerbException, InvalidResumptionTokenException, UnknownParameterException, BadArgumentException, DuplicateDefinitionException {
        return OAICompiledRequest.compile(this);
    }

    public static enum Parameter {
        From("from"),
        Until("until"),
        Identifier("identifier"),
        MetadataPrefix("metadataPrefix"),
        ResumptionToken("resumptionToken"),
        Set("set"),
        Verb("verb");

        private String representation;

        private Parameter(String rep) {
            this.representation = rep;
        }

        public String toString() {
            return this.representation;
        }

        public static Parameter fromRepresentation(String representation) {
            for (Parameter param : Parameter.values()) {
                if (!param.representation.equals(representation)) continue;
                return param;
            }
            throw new IllegalArgumentException("Given representation is not a valid value for Parameter");
        }
    }
}

