/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xoai.dataprovider.repository;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.RandomStringUtils;
import org.dspace.xoai.dataprovider.handlers.results.ListSetsResult;
import org.dspace.xoai.dataprovider.model.Set;
import org.dspace.xoai.dataprovider.repository.SetRepository;

public class InMemorySetRepository
implements SetRepository {
    private boolean supportSets = true;
    private List<Set> sets = new ArrayList<Set>();

    public InMemorySetRepository doesNotSupportSets() {
        this.supportSets = false;
        return this;
    }

    public InMemorySetRepository withSet(String name, String spec) {
        this.sets.add(new Set(spec).withName(name));
        return this;
    }

    public InMemorySetRepository withRandomSets(int number) {
        for (int i = 0; i < number; ++i) {
            this.sets.add(new Set(RandomStringUtils.randomAlphabetic((int)number)).withName("Set" + (i + 1)));
        }
        return this;
    }

    @Override
    public boolean supportSets() {
        return this.supportSets;
    }

    @Override
    public ListSetsResult retrieveSets(int offset, int length) {
        return new ListSetsResult(offset + length < this.sets.size(), this.sets.subList(offset, Math.min(offset + length, this.sets.size())));
    }

    @Override
    public boolean exists(String setSpec) {
        for (Set s : this.sets) {
            if (!s.getSpec().equals(setSpec)) continue;
            return true;
        }
        return false;
    }
}

