/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.bsse.cisd.dsu.dss;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.filesystem.FastRecursiveHardLinkMaker;
import ch.systemsx.cisd.common.filesystem.FileOperations;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.filesystem.IImmutableCopier;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.process.ProcessExecutionHelper;
import ch.systemsx.cisd.common.process.ProcessIOStrategy;
import ch.systemsx.cisd.common.process.ProcessResult;
import ch.systemsx.cisd.common.properties.ExtendedProperties;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.common.time.TimingParameters;
import ch.systemsx.cisd.etlserver.AbstractPostRegistrationDataSetHandlerForFileBasedUndo;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.RSyncConfig;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityTypePropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ListSampleCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifierFactory;
import java.io.File;
import java.io.FileFilter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.log4j.Logger;

class FlowLaneFeeder
extends AbstractPostRegistrationDataSetHandlerForFileBasedUndo {
    static final String META_DATA_FILE_TYPE = ".tsv";
    static final String META_DATA_FILE_PREFIX = "meta-data-file-prefix";
    static final String TRANSFER_PREFIX = "transfer.";
    static final String AFFILIATION_KEY = "AFFILIATION";
    static final String DATA_TRANSFERRED = "DATA_TRANSFERRED";
    static final String EXTERNAL_SAMPLE_NAME_KEY = "EXTERNAL_SAMPLE_NAME";
    static final String FLOW_LANE_DROP_BOX_TEMPLATE = "flow-lane-drop-box-template";
    static final String SRF_INFO_PATH = "srf-info-path";
    static final String ENTITY_SEPARATOR_KEY = "entity-separator";
    static final String DEFAULT_ENTITY_SEPARATOR = "_";
    static final String SRF_FILE_EXTENSION = "srf";
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, FlowLaneFeeder.class);
    private final IEncapsulatedOpenBISService service;
    private final MessageFormat flowLaneDropBoxTemplate;
    private final String metaDataFilePrefix;
    private final String entitySepaparator;
    private final IImmutableCopier copier;
    private final Map<String, File> transferDropBoxes = new HashMap<String, File>();
    private final String srfInfoPathOrNull;
    private boolean updateDataTransferredProperty = true;

    FlowLaneFeeder(Properties properties, IEncapsulatedOpenBISService service) {
        super(FileOperations.getInstance());
        File srfInfo;
        this.service = service;
        this.flowLaneDropBoxTemplate = new MessageFormat(PropertyUtils.getMandatoryProperty((Properties)properties, (String)FLOW_LANE_DROP_BOX_TEMPLATE));
        this.metaDataFilePrefix = PropertyUtils.getMandatoryProperty((Properties)properties, (String)META_DATA_FILE_PREFIX);
        this.entitySepaparator = properties.getProperty(ENTITY_SEPARATOR_KEY, DEFAULT_ENTITY_SEPARATOR);
        this.srfInfoPathOrNull = properties.getProperty(SRF_INFO_PATH);
        if (this.srfInfoPathOrNull != null && !(srfInfo = new File(this.srfInfoPathOrNull)).isFile()) {
            throw new ConfigurationFailureException("File '" + srfInfo.getAbsolutePath() + "' does not exists or is a folder.");
        }
        this.copier = FastRecursiveHardLinkMaker.tryCreate((TimingParameters)TimingParameters.getDefaultParameters(), (List)RSyncConfig.getInstance().getAdditionalCommandLineOptions());
        ExtendedProperties transferDropBoxMapping = ExtendedProperties.getSubset((Properties)properties, (String)TRANSFER_PREFIX, (boolean)true);
        Set<Map.Entry<Object, Object>> entries = transferDropBoxMapping.entrySet();
        for (Map.Entry<Object, Object> entry : entries) {
            String affiliation = entry.getKey().toString();
            String dropBoxPath = entry.getValue().toString();
            File dropBox = new File(dropBoxPath);
            if (!dropBox.isDirectory()) {
                throw new EnvironmentFailureException("Transfer drop box for " + affiliation + " doen't exist or isn't a folder: " + dropBox.getAbsolutePath());
            }
            this.transferDropBoxes.put(affiliation, dropBox);
        }
    }

    void setUpdateDataTransferredProperty(boolean updateDataTransferredProperty) {
        this.updateDataTransferredProperty = updateDataTransferredProperty;
    }

    public Status handle(File originalData, DataSetInformation dataSetInformation, Map<String, String> parameterBindings) {
        Map<String, Sample> flowLaneSampleMap = this.createFlowLaneSampleMap(dataSetInformation);
        String flowcellID = originalData.getName();
        ArrayList srfFiles = new ArrayList();
        FileUtilities.findFiles((File)originalData, srfFiles, (FileFilter)this.createSrfFileFilter());
        if (srfFiles.size() < flowLaneSampleMap.size()) {
            throw new EnvironmentFailureException("Only " + srfFiles.size() + " flow lane files found instead of " + flowLaneSampleMap.size() + ".");
        }
        LinkedHashSet<String> processedFlowLanes = new LinkedHashSet<String>();
        for (File srfFile : srfFiles) {
            String fileName;
            List<String> srfInfo = this.getSRFInfo(srfFile);
            String flowLane = this.extractFlowLane(srfFile);
            if (processedFlowLanes.contains(flowLane)) {
                throw new UserFailureException("Flow lane " + flowLane + " already registered.");
            }
            Sample flowLaneSample = flowLaneSampleMap.get(flowLane);
            if (flowLaneSample == null) {
                throw new UserFailureException("No flow lane sample for flow lane " + flowLane + " found.");
            }
            File flowLaneDropBox = this.createDropBoxFile(flowLane);
            File flowLaneDataSet = new File(flowLaneDropBox, fileName = flowLaneSample.getSpace().getCode() + this.entitySepaparator + flowcellID + "." + flowLane);
            if (flowLaneDataSet.exists()) {
                throw new EnvironmentFailureException("There is already a data set for flow lane " + flowLane + ".");
            }
            this.addFileForUndo(flowLaneDataSet);
            boolean success = flowLaneDataSet.mkdir();
            if (!success) {
                throw new EnvironmentFailureException("Couldn't create folder '" + flowLaneDataSet.getAbsolutePath() + "'.");
            }
            this.createHardLink(srfFile, flowLaneDataSet);
            this.createMetaDataFileAndHardLinkInTransferDropBox(flowLaneDataSet, flowLaneSample, flowLane, srfInfo);
            ArrayList flowLaneFiles = new ArrayList();
            FileUtilities.findFiles((File)originalData, flowLaneFiles, (FileFilter)this.createPrefixFileFilter(FilenameUtils.getBaseName((String)srfFile.getName())));
            for (File file : flowLaneFiles) {
                if (FilenameUtils.getExtension((String)file.getName()).equals(SRF_FILE_EXTENSION)) continue;
                this.createHardLink(file, flowLaneDataSet);
            }
            if (this.updateDataTransferredProperty) {
                this.service.updateSample(FlowLaneFeeder.createUpdates(flowLaneSample, this.createDataTransferredProperty(flowLaneSample)));
            }
            File markerFile = new File(flowLaneDropBox, ".MARKER_is_finished_" + fileName);
            this.addFileForUndo(markerFile);
            FileUtilities.writeToFile((File)markerFile, (String)"");
            if (operationLog.isInfoEnabled()) {
                operationLog.info((Object)("Flow lane file '" + srfFile + "' successfully dropped into drop box '" + flowLaneDropBox + "' as '" + flowLaneDataSet.getName() + "'."));
            }
            processedFlowLanes.add(flowLane);
        }
        return Status.OK;
    }

    private List<String> getSRFInfo(File file) {
        if (this.srfInfoPathOrNull == null) {
            return Collections.emptyList();
        }
        List<String> command = Arrays.asList(this.srfInfoPathOrNull, "-l1", file.getAbsolutePath());
        ProcessResult result = ProcessExecutionHelper.run(command, (Logger)operationLog, (Logger)operationLog, (long)-1L, (ProcessIOStrategy)ProcessIOStrategy.DEFAULT_IO_STRATEGY, (boolean)true);
        List output = result.getOutput();
        if (!result.isOK()) {
            StringBuilder builder = new StringBuilder();
            String startupFailureMessage = result.getStartupFailureMessage();
            if (StringUtils.isNotBlank((CharSequence)startupFailureMessage)) {
                builder.append("\nStartup failure message:").append(startupFailureMessage);
            }
            builder.append("\nStandard out and error:");
            for (String outputLine : output) {
                builder.append("\n").append(outputLine);
            }
            throw new UserFailureException("Invalid SRF file '" + file.getAbsolutePath() + "':" + builder);
        }
        return output;
    }

    private Map<String, Sample> createFlowLaneSampleMap(DataSetInformation dataSetInformation) {
        SampleIdentifier sampleIdentifier = dataSetInformation.getSampleIdentifier();
        Sample flowCell = this.service.tryGetSampleWithExperiment(sampleIdentifier);
        if (flowCell == null) {
            throw new UserFailureException("Unkown flow cell sample: " + sampleIdentifier);
        }
        TechId flowCellID = new TechId(flowCell.getId());
        ListSampleCriteria criteria = ListSampleCriteria.createForContainer((TechId)flowCellID);
        List flowLaneSamples = this.service.listSamples(criteria);
        LinkedHashMap<String, Sample> flowLaneSampleMap = new LinkedHashMap<String, Sample>();
        for (Sample flowLaneSample : flowLaneSamples) {
            flowLaneSampleMap.put(flowLaneSample.getSubCode(), flowLaneSample);
        }
        return flowLaneSampleMap;
    }

    private void createMetaDataFileAndHardLinkInTransferDropBox(File flowLaneDataSet, Sample flowLaneSample, String flowLane, List<String> srfInfo) {
        if (flowLaneSample == null) {
            throw new UserFailureException("No flow lane sample for flow lane " + flowLane + " exists");
        }
        StringBuilder builder = new StringBuilder();
        this.addLine(builder, "Parent", flowLaneSample.getGeneratedFrom().getIdentifier());
        this.addLine(builder, "Code", flowLaneSample.getCode());
        this.addLine(builder, "Contact Person Email", flowLaneSample.getRegistrator().getEmail());
        SampleIdentifier identifier = SampleIdentifierFactory.parse((String)flowLaneSample.getIdentifier());
        IEntityProperty[] propertiesOrNull = this.service.tryGetPropertiesOfTopSample(identifier);
        File dropBox = null;
        if (propertiesOrNull != null) {
            for (IEntityProperty property : propertiesOrNull) {
                PropertyType propertyType = property.getPropertyType();
                String value = property.tryGetAsString();
                this.addLine(builder, propertyType.getCode(), value);
                String code = propertyType.getCode();
                if (!code.equals(AFFILIATION_KEY)) continue;
                dropBox = this.transferDropBoxes.get(value);
            }
        }
        if (!srfInfo.isEmpty()) {
            builder.append("\n==== SRF Info ====\t\n");
            for (String line : srfInfo) {
                builder.append(line).append("\t\n");
            }
        }
        String sampleCode = flowLaneSample.getCode();
        String metaFileName = this.metaDataFilePrefix + FlowLaneFeeder.escapeSampleCode(sampleCode) + META_DATA_FILE_TYPE;
        FileUtilities.writeToFile((File)new File(flowLaneDataSet, metaFileName), (String)builder.toString());
        this.copyToDropBox(dropBox, flowLaneDataSet);
    }

    private IEntityProperty createDataTransferredProperty(Sample flowLaneSample) {
        PropertyType propertyType = this.extractDataTransferredProperty(flowLaneSample);
        String currentDate = DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss Z");
        EntityProperty result = new EntityProperty();
        result.setPropertyType(propertyType);
        result.setValue(currentDate);
        return result;
    }

    private PropertyType extractDataTransferredProperty(Sample flowLaneSample) {
        SampleType flowLaneType = this.service.getSampleType(flowLaneSample.getSampleType().getCode());
        PropertyType propertyType = null;
        for (EntityTypePropertyType entityTypePropertyType : flowLaneType.getAssignedPropertyTypes()) {
            if (!entityTypePropertyType.getPropertyType().getCode().equals(DATA_TRANSFERRED)) continue;
            propertyType = entityTypePropertyType.getPropertyType();
        }
        if (propertyType == null) {
            throw new UserFailureException("DATA_TRANSFERRED property type doesn't exist or is not assigned to Flow Lane samples");
        }
        return propertyType;
    }

    public static SampleUpdatesDTO createUpdates(Sample sample, IEntityProperty newEntityProperty) {
        TechId sampleId = TechId.create((IIdHolder)sample);
        ArrayList<IEntityProperty> properties = new ArrayList<IEntityProperty>(sample.getProperties());
        properties.add(newEntityProperty);
        ExperimentIdentifier experimentIdentifierOrNull = sample.getExperiment() != null ? new ExperimentIdentifier(sample.getExperiment()) : null;
        ArrayList attachments = new ArrayList();
        int version = sample.getVersion();
        SampleIdentifier sampleIdentifier = SampleIdentifierFactory.parse((String)sample.getIdentifier());
        String containerIdentifierOrNull = sample.getContainer() != null ? sample.getContainer().getIdentifier() : null;
        String[] modifiedParentCodesOrNull = null;
        return new SampleUpdatesDTO(sampleId, properties, experimentIdentifierOrNull, null, attachments, version, sampleIdentifier, containerIdentifierOrNull, modifiedParentCodesOrNull);
    }

    private void copyToDropBox(File dropBoxOrNull, File flowLaneDataSet) {
        if (dropBoxOrNull != null) {
            File[] files;
            for (File file : files = flowLaneDataSet.listFiles()) {
                this.createHardLink(file, dropBoxOrNull);
                this.addFileForUndo(new File(dropBoxOrNull, file.getName()));
            }
            if (operationLog.isInfoEnabled()) {
                operationLog.info((Object)("Flow lane data set '" + flowLaneDataSet.getName() + "' successfully transfered to drop box '" + dropBoxOrNull + "'"));
            }
        }
    }

    static String escapeSampleCode(String sampleCode) {
        return sampleCode == null ? null : sampleCode.replace(":", DEFAULT_ENTITY_SEPARATOR);
    }

    private void addLine(StringBuilder builder, String key, String value) {
        builder.append(key).append('\t').append(value).append('\n');
    }

    private void createHardLink(File file, File folder) {
        Status status = this.copier.copyImmutably(file, folder, null);
        if (status.isError()) {
            throw new EnvironmentFailureException("Couldn't create a hard-link copy of '" + file.getAbsolutePath() + "' in folder '" + folder.getAbsolutePath() + "'. [" + status + "]");
        }
    }

    private File createDropBoxFile(String flowLane) {
        File dropBox = new File(this.flowLaneDropBoxTemplate.format(new Object[]{flowLane}));
        if (!dropBox.exists()) {
            throw new ConfigurationFailureException("Drop box '" + dropBox + "' does not exist.");
        }
        if (!dropBox.isDirectory()) {
            throw new ConfigurationFailureException("Drop box '" + dropBox + "' is not a directory.");
        }
        return dropBox;
    }

    private String extractFlowLane(File file) {
        String name = file.getName();
        String nameWithoutType = name.substring(0, name.lastIndexOf(46));
        int lastIndexOfUnderScore = nameWithoutType.lastIndexOf(95);
        String flowLane = nameWithoutType;
        if (lastIndexOfUnderScore >= 0) {
            flowLane = nameWithoutType.substring(lastIndexOfUnderScore + 1);
        }
        return flowLane;
    }

    private FileFilter createSrfFileFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile() && FilenameUtils.getExtension((String)file.getName()).equals(FlowLaneFeeder.SRF_FILE_EXTENSION);
            }
        };
    }

    private FileFilter createPrefixFileFilter(final String prefix) {
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().startsWith(prefix);
            }
        };
    }
}

