/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.bsse.cisd.dsu.tracking.email;

import ch.systemsx.cisd.common.mail.EMailAddress;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import java.util.ArrayList;
import java.util.List;

public class EntityTrackingEmailData {
    private List<Sample> sequencingSamplesToBeProcessed = new ArrayList<Sample>(0);
    private List<Sample> sequencingSamplesProcessed = new ArrayList<Sample>(0);
    private final List<AbstractExternalData> dataSets = new ArrayList<AbstractExternalData>(0);
    private final EMailAddress recipient;

    public EntityTrackingEmailData(EMailAddress recipient) {
        this.recipient = recipient;
    }

    public EMailAddress getRecipient() {
        return this.recipient;
    }

    public List<Sample> getSequencingSamplesToBeProcessed() {
        return this.sequencingSamplesToBeProcessed;
    }

    public List<Sample> getSequencingSamplesProcessed() {
        return this.sequencingSamplesProcessed;
    }

    public List<AbstractExternalData> getDataSets() {
        return this.dataSets;
    }

    public void addSequencingSampleToBeProcessed(Sample sequencingSample) {
        this.sequencingSamplesToBeProcessed.add(sequencingSample);
    }

    public void addSequencingSampleProcessed(Sample sequencingSample) {
        this.sequencingSamplesProcessed.add(sequencingSample);
    }

    public void addDataSet(AbstractExternalData dataSet) {
        this.dataSets.add(dataSet);
    }

    public String getDescription() {
        StringBuilder sb = new StringBuilder();
        this.appendSamplesInfo(sb, this.sequencingSamplesToBeProcessed, "possible for processing");
        this.appendSamplesInfo(sb, this.sequencingSamplesProcessed, "successfully processed");
        this.appendDataSetsInfo(sb);
        return sb.toString();
    }

    private void appendSamplesInfo(StringBuilder sb, List<Sample> samples, String actionDescription) {
        if (samples.isEmpty()) {
            sb.append(String.format("no new samples are %s\n", actionDescription));
        } else {
            for (Sample seqencingSample : samples) {
                String sequencingSampleIdentifier = seqencingSample.getIdentifier();
                sb.append(String.format("Sequencing sample: '%s' is %s", sequencingSampleIdentifier, actionDescription));
                sb.append("\n");
            }
        }
    }

    private void appendDataSetsInfo(StringBuilder sb) {
        if (this.getDataSets().isEmpty()) {
            sb.append("no new data sets tracked");
        } else {
            sb.append(this.getDataSets().size() + " new data set(s) tracked: ");
            for (AbstractExternalData dataSet : this.getDataSets()) {
                sb.append(dataSet.getIdentifier() + ", ");
            }
        }
        sb.append("\n");
    }

    public String toString() {
        return this.getDescription();
    }
}

