/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.bsse.cisd.dsu.tracking.email;

import ch.ethz.bsse.cisd.dsu.tracking.dto.TrackedEntities;
import ch.ethz.bsse.cisd.dsu.tracking.email.EntityTrackingEmailData;
import ch.systemsx.cisd.common.mail.EMailAddress;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class EntityTrackingEmailDataManager {
    private static final String CONTACT_PERSON_EMAIL = "CONTACT_PERSON_EMAIL";
    private static final String PRINCIPAL_INVESTIGATOR_EMAIL = "PRINCIPAL_INVESTIGATOR_EMAIL";
    private static final String CONTACT_DATA_MANAGER_EMAIL = "CONTACT_DATA_MANAGER_EMAIL";
    private static Map<String, String> recipientsBySpace;

    EntityTrackingEmailDataManager() {
    }

    public static void initialize(Map<String, String> recipients) {
        recipientsBySpace = recipients;
    }

    public static Collection<EntityTrackingEmailData> groupByRecipient(TrackedEntities trackedEntities) {
        assert (recipientsBySpace != null) : "recipientsBySpace not initialized";
        HashMap<EMailAddress, EntityTrackingEmailData> dataByRecipient = new HashMap<EMailAddress, EntityTrackingEmailData>();
        EntityTrackingEmailDataManager.groupSequencingSamplesToBeProcessed(dataByRecipient, trackedEntities);
        EntityTrackingEmailDataManager.groupSequencingSamplesProcessed(dataByRecipient, trackedEntities);
        EntityTrackingEmailDataManager.groupDataSetSamples(dataByRecipient, trackedEntities);
        return dataByRecipient.values();
    }

    public static Collection<EntityTrackingEmailData> groupByRecipientDataSets(TrackedEntities trackedEntities) {
        assert (recipientsBySpace != null) : "recipientsBySpace not initialized";
        HashMap<EMailAddress, EntityTrackingEmailData> dataByRecipient = new HashMap<EMailAddress, EntityTrackingEmailData>();
        EntityTrackingEmailDataManager.groupDataSetSamples(dataByRecipient, trackedEntities);
        return dataByRecipient.values();
    }

    private static void groupSequencingSamplesToBeProcessed(Map<EMailAddress, EntityTrackingEmailData> result, TrackedEntities trackedEntities) {
        for (Sample sequencingSample : trackedEntities.getSequencingSamplesToBeProcessed()) {
            for (EMailAddress recipient : EntityTrackingEmailDataManager.getSequencingSampleTrackingRecipients(Collections.singleton(sequencingSample))) {
                EntityTrackingEmailData emailData = EntityTrackingEmailDataManager.getOrCreateRecipientEmailData(result, recipient);
                emailData.addSequencingSampleToBeProcessed(sequencingSample);
            }
        }
    }

    private static void groupSequencingSamplesProcessed(Map<EMailAddress, EntityTrackingEmailData> result, TrackedEntities trackedEntities) {
        for (Sample sequencingSample : trackedEntities.getSequencingSamplesProcessed()) {
            for (EMailAddress recipient : EntityTrackingEmailDataManager.getSequencingSampleTrackingRecipients(Collections.singleton(sequencingSample))) {
                EntityTrackingEmailData emailData = EntityTrackingEmailDataManager.getOrCreateRecipientEmailData(result, recipient);
                emailData.addSequencingSampleProcessed(sequencingSample);
            }
        }
    }

    private static void groupDataSetSamples(Map<EMailAddress, EntityTrackingEmailData> result, TrackedEntities trackedEntities) {
        for (AbstractExternalData dataSet : trackedEntities.getDataSets()) {
            for (EMailAddress recipient : EntityTrackingEmailDataManager.getDataSetTrackingRecipients(dataSet)) {
                EntityTrackingEmailData emailData = EntityTrackingEmailDataManager.getOrCreateRecipientEmailData(result, recipient);
                emailData.addDataSet(dataSet);
            }
        }
    }

    private static EntityTrackingEmailData getOrCreateRecipientEmailData(Map<EMailAddress, EntityTrackingEmailData> dataByRecipient, EMailAddress recipient) {
        EntityTrackingEmailData emailDataOrNull = dataByRecipient.get(recipient);
        if (emailDataOrNull == null) {
            emailDataOrNull = new EntityTrackingEmailData(recipient);
            dataByRecipient.put(recipient, emailDataOrNull);
        }
        return emailDataOrNull;
    }

    private static Set<EMailAddress> getSequencingSampleTrackingRecipients(Collection<Sample> sequencingSamples) {
        assert (sequencingSamples != null);
        HashSet<EMailAddress> recipients = new HashSet<EMailAddress>();
        HashSet<String> recipientPropertyTypeCodes = new HashSet<String>();
        recipientPropertyTypeCodes.add(CONTACT_PERSON_EMAIL);
        recipientPropertyTypeCodes.add(PRINCIPAL_INVESTIGATOR_EMAIL);
        recipientPropertyTypeCodes.add(CONTACT_DATA_MANAGER_EMAIL);
        for (Sample sequencingSample : sequencingSamples) {
            for (Map.Entry<String, String> space : recipientsBySpace.entrySet()) {
                String spaceRecipientOrNull;
                if (!sequencingSample.getIdentifier().split("/")[1].equals(space.getKey()) || (spaceRecipientOrNull = recipientsBySpace.get(space.getKey())) == null) continue;
                EMailAddress myEmail = new EMailAddress(spaceRecipientOrNull);
                recipients.add(myEmail);
            }
            for (IEntityProperty property : sequencingSample.getProperties()) {
                String propertyCode = property.getPropertyType().getCode();
                String propertyValue = property.tryGetAsString();
                if (!recipientPropertyTypeCodes.contains(propertyCode)) continue;
                EMailAddress myEmail = new EMailAddress(propertyValue);
                recipients.add(myEmail);
            }
        }
        return recipients;
    }

    private static Set<EMailAddress> getFlowLaneSampleTrackingRecipients(Sample flowLaneSample) {
        assert (flowLaneSample != null);
        return EntityTrackingEmailDataManager.getSequencingSampleTrackingRecipients(flowLaneSample.getParents());
    }

    private static Set<EMailAddress> getDataSetTrackingRecipients(AbstractExternalData dataSet) {
        assert (dataSet != null);
        return EntityTrackingEmailDataManager.getFlowLaneSampleTrackingRecipients(dataSet.getSample());
    }
}

