/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.bsse.cisd.dsu.tracking.main;

import ch.ethz.bsse.cisd.dsu.tracking.dto.TrackingStateDTO;
import ch.ethz.bsse.cisd.dsu.tracking.main.ITrackingDAO;
import ch.ethz.bsse.cisd.dsu.tracking.utils.LogUtils;
import ch.systemsx.cisd.common.io.PropertyIOUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class FileBasedTrackingDAO
implements ITrackingDAO {
    static String LAST_SEEN_DATASET_ID = "lastSeenDatasetId";
    static String TO_BE_PROCESSED = "trackedSamplesToBeProcessed";
    static String PROCESSED = "trackedSamplesProcessedSuccessfully";
    static String SEPARATOR = " ";
    static String EQUAL = "=";
    private final String filePathSampleDb;
    private final String filePathDatasetDb;

    public FileBasedTrackingDAO(String filePathSampleDb, String filePathDatasetDb) {
        this.filePathSampleDb = filePathSampleDb;
        this.filePathDatasetDb = filePathDatasetDb;
    }

    @Override
    public void saveTrackingState(TrackingStateDTO state) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(TO_BE_PROCESSED + SEPARATOR + this.sampleIdsAsString(state.getAlreadyTrackedSampleIdsToBeProcessed()));
        lines.add(PROCESSED + SEPARATOR + this.sampleIdsAsString(state.getAlreadyTrackedSampleIdsProcessed()));
        FileBasedTrackingDAO.writeLines(new File(this.filePathSampleDb), lines);
        lines = new ArrayList();
        for (Map.Entry<String, Long> entry : state.getLastSeenDataSetIdMap().entrySet()) {
            lines.add(entry.getKey() + EQUAL + entry.getValue());
        }
        FileBasedTrackingDAO.writeLines(new File(this.filePathDatasetDb), lines);
    }

    private String sampleIdsAsString(Collection<Long> sampleIds) {
        return StringUtils.join(sampleIds, (String)SEPARATOR);
    }

    @Override
    public TrackingStateDTO getTrackingState() {
        try {
            TrackingStateDTO state = new TrackingStateDTO();
            Properties props = PropertyIOUtils.loadProperties((String)this.filePathDatasetDb);
            TreeMap<String, Long> propsMap = new TreeMap<String, Long>();
            for (Object o : props.keySet()) {
                propsMap.put(o.toString(), Long.parseLong(props.get(o).toString()));
            }
            state.setLastSeenProperties(props);
            state.setLastSeenDataSetIdMap(propsMap);
            List lines = IOUtils.readLines((Reader)new FileReader(this.filePathSampleDb));
            String[] toBeProcessed = ((String)lines.get(0)).split(SEPARATOR);
            String[] processed = ((String)lines.get(1)).split(SEPARATOR);
            state.setAlreadyTrackedSampleIdsToBeProcessed(FileBasedTrackingDAO.parseIds(toBeProcessed));
            state.setAlreadyTrackedSampleIdsProcessed(FileBasedTrackingDAO.parseIds(processed));
            return state;
        }
        catch (Exception e) {
            throw LogUtils.environmentError("Incorrect file format", e);
        }
    }

    private static Set<Long> parseIds(String[] array) {
        TreeSet<Long> ids = new TreeSet<Long>();
        for (int i = 1; i < array.length; ++i) {
            ids.add(Long.parseLong(array[i]));
        }
        return ids;
    }

    private static void writeLines(File file, List<String> lines) {
        try {
            IOUtils.writeLines(lines, (String)"\n", (OutputStream)new FileOutputStream(file));
        }
        catch (IOException ex) {
            throw LogUtils.environmentError(String.format("Cannot save the file %s with content: %s", file.getPath(), lines), ex);
        }
    }
}

