/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.bsse.cisd.dsu.tracking.main;

import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.common.mail.MailClient;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class Parameters {
    private static final String OPENBIS_USER = "openbis-user";
    private static final String OPENBIS_PASSWORD = "openbis-password";
    private static final String OPENBIS_SERVER_URL = "openbis-server-url";
    private static final String PERMLINK_URL = "permlink-url";
    private static final String TRACKING_ADMIN_EMAIL = "tracking-admin-email";
    private static final String NOTIFICATION_EMAIL_FROM = "mail.from";
    private static final String SPACE_WHITELIST = "space-whitelist";
    private static final String DBM_SPACE_PREFIX = "dbm-space-prefix";
    private static final String DEBUG = "debug";
    private static final String OLD_DATA_SET_BACKLOG_NUMBER = "old-data-set-backlog-number";
    private static final String DATA_SET_TYPE_LIST = "dataset-type-list";
    private static final String DESTINATION_FOLDER = "destination-folder";
    private static final String DESTINATION_FOLDER_SUFFIX = "destination-folder";
    private static final String RSYNC_BINARY = "rsync-binary";
    private static final String RSYNC_FLAGS = "rsync-flags";
    private static final String DSS_ROOT_DIR = "dss-root-dir";
    private final String openbisUser;
    private final String openbisPassword;
    private final String openbisServerURL;
    private final String permlinkURL;
    private final IMailClient mailClient;
    private final String adminEmail;
    private final String notificationEmail;
    private final String spaceWhitelist;
    private final String dbmSpacePrefix;
    private final boolean debug;
    private final long oldDataSetBacklogNumber;
    private final String dataSetTypeList;
    private final String destinationFolder;
    private final String rsyncBinary;
    private final String rsyncFlags;
    private final String dssRootDir;
    private final Map<String, String> destinationFolderMap;

    public Parameters(Properties props) {
        this.openbisUser = PropertyUtils.getMandatoryProperty((Properties)props, (String)OPENBIS_USER);
        this.openbisPassword = PropertyUtils.getMandatoryProperty((Properties)props, (String)OPENBIS_PASSWORD);
        this.openbisServerURL = PropertyUtils.getMandatoryProperty((Properties)props, (String)OPENBIS_SERVER_URL);
        this.permlinkURL = PropertyUtils.getProperty((Properties)props, (String)PERMLINK_URL, (String)this.openbisServerURL);
        this.mailClient = new MailClient(props);
        this.adminEmail = PropertyUtils.getProperty((Properties)props, (String)TRACKING_ADMIN_EMAIL);
        this.notificationEmail = PropertyUtils.getProperty((Properties)props, (String)NOTIFICATION_EMAIL_FROM);
        this.spaceWhitelist = PropertyUtils.getProperty((Properties)props, (String)SPACE_WHITELIST);
        this.dbmSpacePrefix = PropertyUtils.getProperty((Properties)props, (String)DBM_SPACE_PREFIX);
        this.debug = PropertyUtils.getBoolean((Properties)props, (String)DEBUG, (boolean)false);
        this.oldDataSetBacklogNumber = PropertyUtils.getInt((Properties)props, (String)OLD_DATA_SET_BACKLOG_NUMBER, (int)0);
        this.dataSetTypeList = PropertyUtils.getProperty((Properties)props, (String)DATA_SET_TYPE_LIST);
        this.destinationFolder = PropertyUtils.getProperty((Properties)props, (String)"destination-folder");
        this.rsyncBinary = PropertyUtils.getProperty((Properties)props, (String)RSYNC_BINARY);
        this.rsyncFlags = PropertyUtils.getProperty((Properties)props, (String)RSYNC_FLAGS);
        this.dssRootDir = PropertyUtils.getProperty((Properties)props, (String)DSS_ROOT_DIR);
        this.destinationFolderMap = this.setDataDestinationFolder(props);
    }

    public String getOpenbisUser() {
        return this.openbisUser;
    }

    public String getOpenbisPassword() {
        return this.openbisPassword;
    }

    public String getOpenbisServerURL() {
        return this.openbisServerURL;
    }

    public IMailClient getMailClient() {
        return this.mailClient;
    }

    public String getPermlinkURL() {
        return this.permlinkURL;
    }

    public String getAdminEmail() {
        return this.adminEmail;
    }

    public String getNotificationEmail() {
        return this.notificationEmail;
    }

    public String getSpaceWhitelist() {
        return this.spaceWhitelist;
    }

    public String getDbmSpacePrefix() {
        return this.dbmSpacePrefix;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public long getoldDataSetBacklogNumber() {
        return this.oldDataSetBacklogNumber;
    }

    public String getdataSetTypeList() {
        return this.dataSetTypeList;
    }

    public String getDestinationFolder() {
        return this.destinationFolder;
    }

    public String getRsyncBinary() {
        return this.rsyncBinary;
    }

    public String[] getRsyncFlags() {
        return this.rsyncFlags.split("\\s+");
    }

    public String getDssRoot() {
        return this.dssRootDir;
    }

    public Map<String, String> getDestinationFolderMap() {
        return this.destinationFolderMap;
    }

    private Map<String, String> setDataDestinationFolder(Properties properties) {
        HashMap<String, String> destinationFolderMap = new HashMap<String, String>();
        for (Object key : properties.keySet()) {
            String propertyKey = (String)key;
            if (!propertyKey.endsWith("destination-folder")) continue;
            String datasetTypePrefix = propertyKey.split("-")[0];
            destinationFolderMap.put(datasetTypePrefix, PropertyUtils.getMandatoryProperty((Properties)properties, (String)propertyKey));
        }
        return destinationFolderMap;
    }
}

