/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.bsse.cisd.dsu.tracking.main;

import ch.ethz.bsse.cisd.dsu.tracking.dto.TrackedEntities;
import ch.ethz.bsse.cisd.dsu.tracking.dto.TrackingStateDTO;
import ch.ethz.bsse.cisd.dsu.tracking.email.Email;
import ch.ethz.bsse.cisd.dsu.tracking.email.EmailWithSummary;
import ch.ethz.bsse.cisd.dsu.tracking.email.IEntityTrackingEmailGenerator;
import ch.ethz.bsse.cisd.dsu.tracking.main.ITrackingDAO;
import ch.ethz.bsse.cisd.dsu.tracking.main.Parameters;
import ch.ethz.bsse.cisd.dsu.tracking.utils.LogUtils;
import ch.ethz.sis.openbis.generic.asapi.v3.IApplicationServerApi;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.SearchResult;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.Sample;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.fetchoptions.SampleFetchOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.ISampleId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.search.SampleSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.update.SampleUpdate;
import ch.systemsx.cisd.common.collection.CollectionUtils;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.filesystem.rsync.RsyncCopier;
import ch.systemsx.cisd.common.mail.EMailAddress;
import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.openbis.generic.shared.ITrackingServer;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetArchivingStatus;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TrackingDataSetCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TrackingSampleCriteria;
import ch.systemsx.cisd.openbis.generic.shared.dto.SessionContextDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class TrackingBO {
    private static final String HIGH_PRIORITY_DATA_SET_TYPE = "FASTQ_GZ";
    private static final String ORIGINAL_PATH = "/original/";
    private static final String PROPERTY_RUN_NAME_FOLDER = "RUN_NAME_FOLDER";
    private static final String SEQUENCING_SAMPLE_TYPE = "ILLUMINA_SEQUENCING";
    private static final String FLOW_LANE_SAMPLE_TYPE = "ILLUMINA_FLOW_LANE";
    private static final String PROCESSING_POSSIBLE_PROPERTY_CODE = "LIBRARY_PROCESSING_POSSIBLE";
    private static final String PROCESSING_SUCCESSFUL_PROPERTY_CODE = "LIBRARY_PROCESSING_SUCCESSFUL";
    private static final String PROPERTY_DATA_TRANSFERRED = "DATA_TRANSFERRED";
    public static final String DATE_FORMAT_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private static final String TRUE = "true";
    private final ITrackingServer trackingServer;
    private final IEntityTrackingEmailGenerator emailGenerator;
    private final IMailClient mailClient;
    private static final SimpleDateFormat LIST_TIMESTAMP_FORMAT = new SimpleDateFormat("yyyyMMddHHmmssSSSS");

    public TrackingBO(ITrackingServer trackingServer, IEntityTrackingEmailGenerator emailGenerator, IMailClient mailClient) {
        this.trackingServer = trackingServer;
        this.emailGenerator = emailGenerator;
        this.mailClient = mailClient;
    }

    public void trackAndNotify(ITrackingDAO trackingDAO, HashMap<String, String[]> commandLineMap, Parameters params, SessionContextDTO session, IApplicationServerApi v3, String v3SessionToken) {
        Boolean sendEmails = true;
        TrackingStateDTO prevTrackingState = trackingDAO.getTrackingState();
        this.extractCommandLineFlags(commandLineMap);
        LogUtils.debug("prevTrackingState: " + prevTrackingState.getLastSeenDataSetIdMap().toString());
        TrackedEntities changedEntities = null;
        List<EmailWithSummary> emailsWithSummary = null;
        if (commandLineMap.get("lanes") != null) {
            String[] laneCodeList = commandLineMap.get("lanes");
            changedEntities = TrackingBO.fetchChangedDataSets(prevTrackingState, this.trackingServer, params, commandLineMap, laneCodeList, session, v3, v3SessionToken);
        } else if (commandLineMap.get("remove") != null) {
            sendEmails = false;
            String[] laneCodeList = commandLineMap.get("remove");
            changedEntities = TrackingBO.fetchChangedDataSets(prevTrackingState, this.trackingServer, params, commandLineMap, laneCodeList, session, v3, v3SessionToken);
        } else if (commandLineMap.containsKey("all")) {
            System.out.println("This function is deactivated");
        } else if (commandLineMap.containsKey("changed_lanes")) {
            Map<String, String> changed_lanes = TrackingBO.fetchChangedLanes(prevTrackingState, this.trackingServer, params, session);
            sendEmails = false;
        } else if (commandLineMap.containsKey("list_spaces")) {
            sendEmails = false;
            String trimmedSpaceWhiteList = "";
            String spaceWhiteList = params.getSpaceWhitelist();
            trimmedSpaceWhiteList = spaceWhiteList.replace(" ", "");
            System.out.println(trimmedSpaceWhiteList);
        } else {
            LogUtils.debug("Should never be reached.");
        }
        if (sendEmails.booleanValue()) {
            emailsWithSummary = this.emailGenerator.generateDataSetsEmails(changedEntities);
            TrackingBO.sendEmails(emailsWithSummary, this.mailClient);
        } else {
            LogUtils.info("Not sending out any emails.");
        }
        if (!params.getDebug() && changedEntities != null) {
            LogUtils.info("Saving new state to tracking database.");
            TrackingBO.saveTrackingState(prevTrackingState, changedEntities, trackingDAO);
        } else {
            LogUtils.info("Debug mode activated! Won't save anything to the tracking database.");
        }
    }

    private void extractCommandLineFlags(HashMap<String, String[]> commandLineMap) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String[]> entry : commandLineMap.entrySet()) {
            sb.append(entry.getKey() + " ");
            if (entry.getValue() == null) continue;
            for (String value : entry.getValue()) {
                sb.append(value);
            }
        }
        LogUtils.info("Got these command line flags: '" + sb + "'");
    }

    private static void sendEmails(List<EmailWithSummary> emailsWithSummary, IMailClient mailClient) {
        for (EmailWithSummary emailWithSummary : emailsWithSummary) {
            Email email = emailWithSummary.getEmail();
            try {
                TrackingBO.logEmailSummary(emailWithSummary);
                TrackingBO.sendMessage(mailClient, email);
            }
            catch (Exception ex) {
                TrackingBO.sendErrorReport(mailClient, ex, email);
            }
        }
    }

    private static void logEmailSummary(EmailWithSummary emailWithSummary) {
        LogUtils.info("Sending an email [" + emailWithSummary.getEmail().getSubject() + "]. Summary:\n" + emailWithSummary.getSummary());
    }

    private static void sendErrorReport(IMailClient mailClient, Exception exception, Email email) {
        StringBuilder errorReportContentBuilder = new StringBuilder();
        TrackingBO.appendLine(errorReportContentBuilder, "Dear openBIS Admin,");
        TrackingBO.appendLine(errorReportContentBuilder, "This email has been generated automatically from the openBIS Changes Tracking system.");
        TrackingBO.appendLine(errorReportContentBuilder, "There was a failure while trying to send the email:");
        TrackingBO.appendLine(errorReportContentBuilder, exception.getMessage() == null ? "<no details>" : exception.getMessage());
        TrackingBO.appendLine(errorReportContentBuilder, "The possible reason is that the recipient address is not valid.");
        TrackingBO.appendLine(errorReportContentBuilder, "If you know the address of the recipient please correct it and forward this email to him.");
        TrackingBO.appendLine(errorReportContentBuilder, "!!! Note that the Tracking System will not try to send this email again !!!");
        TrackingBO.appendLine(errorReportContentBuilder, "Please correct the recipient email address in openBIS to avoid similar problems in future.");
        TrackingBO.appendLine(errorReportContentBuilder, "");
        TrackingBO.appendLine(errorReportContentBuilder, "Subject:    " + email.getSubject());
        TrackingBO.appendLine(errorReportContentBuilder, "Recipients: " + CollectionUtils.abbreviate((Object[])email.getRecipients(), (int)-1));
        TrackingBO.appendLine(errorReportContentBuilder, "");
        TrackingBO.appendLine(errorReportContentBuilder, "Original content: ");
        TrackingBO.appendLine(errorReportContentBuilder, email.getContent());
        String errorReportContent = errorReportContentBuilder.toString();
        Email errorReportEmail = new Email("[Tracking] Sending an email failed", errorReportContent, null, email.getFromOrNull(), email.getReplyToOrNull());
        TrackingBO.sendMessage(mailClient, errorReportEmail);
    }

    private static void sendMessage(IMailClient mailClient, Email email) {
        String subject = email.getSubject();
        String content = email.getContent();
        EMailAddress replyToOrNull = email.getReplyToOrNull();
        EMailAddress fromOrNull = email.getFromOrNull();
        EMailAddress[] recipients = email.getRecipients();
        mailClient.sendEmailMessage(subject, content, replyToOrNull, fromOrNull, recipients);
    }

    private static void appendLine(StringBuilder sb, String msg) {
        sb.append(msg);
        sb.append("\n");
    }

    private static void saveTrackingState(TrackingStateDTO prevTrackingState, TrackedEntities changedEntities, ITrackingDAO trackingDAO) {
        TrackingStateDTO state = TrackingStateUpdateHelper.calcNewTrackingState(prevTrackingState, changedEntities);
        trackingDAO.saveTrackingState(state);
    }

    private static TrackedEntities fetchChangedEntities(TrackingStateDTO trackingState, ITrackingServer trackingServer, HashMap<String, String[]> clMap, SessionContextDTO session) {
        TrackingDataSetCriteria dataSetCriteria = new TrackingDataSetCriteria(FLOW_LANE_SAMPLE_TYPE, trackingState.getLastSeenDatasetId());
        List dataSets = trackingServer.listDataSets(session.getSessionToken(), dataSetCriteria);
        HashMap<String, ArrayList<Long>> changedTrackingMap = new HashMap<String, ArrayList<Long>>();
        for (AbstractExternalData d : dataSets) {
            TrackingBO.addDataSetTo(changedTrackingMap, d);
        }
        return TrackingBO.gatherTrackedEntities(trackingState, trackingServer, session, dataSets, changedTrackingMap);
    }

    private static Map<String, String> fetchChangedLanes(TrackingStateDTO trackingState, ITrackingServer trackingServer, Parameters params, SessionContextDTO session) {
        long usableDataSetId = TrackingBO.getUsableDataSetId(trackingState, params);
        LogUtils.info("Using maximum DS techId " + usableDataSetId + " for search of changed data sets");
        TrackingDataSetCriteria dataSetCriteria = new TrackingDataSetCriteria(FLOW_LANE_SAMPLE_TYPE, usableDataSetId);
        List dataSets = trackingServer.listDataSets(session.getSessionToken(), dataSetCriteria);
        HashMap<String, String> changedLanesMap = new HashMap<String, String>();
        for (AbstractExternalData d : dataSets) {
            Long newDataSetID = d.getId();
            ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample lane = d.getSample();
            String lanePermId = lane.getPermId();
            String laneSpace = lane.getIdentifier().split("/")[1];
            Long maxDatasetIdForSample = TrackingBO.getMaxDataSetIdForSample(trackingState, lanePermId);
            if (newDataSetID <= maxDatasetIdForSample) continue;
            SampleIdentifier currentLaneId = new SampleIdentifier(d.getSampleCode());
            ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample flowcell = lane.getContainer();
            String runNameFolder = "";
            List flowcellProperties = flowcell.getProperties();
            for (IEntityProperty property : flowcellProperties) {
                if (!property.getPropertyType().getCode().equals(PROPERTY_RUN_NAME_FOLDER)) continue;
                runNameFolder = property.getValue();
                break;
            }
            String laneString = currentLaneId.toString().split(":")[1];
            changedLanesMap.put(runNameFolder + ":" + laneString, laneSpace + " " + lane.getCode());
            LogUtils.debug("DataSetID: " + newDataSetID + " of NEW data Sets > MAX DataSet id for this sample: " + maxDatasetIdForSample);
        }
        Set entrySet = changedLanesMap.entrySet();
        for (Map.Entry entry : entrySet) {
            System.out.println((String)entry.getKey() + " " + (String)entry.getValue());
        }
        LogUtils.debug("changedLanesMap: " + ((Object)changedLanesMap).toString());
        return changedLanesMap;
    }

    private static TrackedEntities fetchChangedDataSets(TrackingStateDTO trackingState, ITrackingServer trackingServer, Parameters params, HashMap<String, String[]> commandLineMap, String[] laneCodeList, SessionContextDTO session, IApplicationServerApi v3, String v3SessionToken) {
        long usableDataSetId = TrackingBO.getUsableDataSetId(trackingState, params);
        List<String> spaceWhiteList = Arrays.asList(params.getSpaceWhitelist().split("\\s*,\\s*"));
        List<String> datasetTypeList = Arrays.asList(params.getdataSetTypeList().split("\\s*,\\s*"));
        LogUtils.info("Using maximum DS techId " + usableDataSetId + " for search of changed data sets");
        TrackingDataSetCriteria dataSetCriteria = new TrackingDataSetCriteria(FLOW_LANE_SAMPLE_TYPE, usableDataSetId);
        List dataSets = trackingServer.listDataSets(session.getSessionToken(), dataSetCriteria);
        ArrayList<SampleIdentifier> filterList = new ArrayList<SampleIdentifier>();
        ArrayList<AbstractExternalData> filteredDataSets = new ArrayList<AbstractExternalData>();
        ArrayList<AbstractExternalData> toTransferDataSets = new ArrayList<AbstractExternalData>();
        ArrayList<AbstractExternalData> toTransferDataSetsHighPriority = new ArrayList<AbstractExternalData>();
        HashMap<String, ArrayList<Long>> changedTrackingMap = new HashMap<String, ArrayList<Long>>();
        for (String lane : laneCodeList) {
            LogUtils.info("Searching for new data sets which belong to " + lane);
            filterList.add(new SampleIdentifier(lane));
        }
        for (AbstractExternalData d : dataSets) {
            Long newDataSetID = d.getId();
            SampleIdentifier currentLaneId = new SampleIdentifier(d.getSampleCode());
            String lanePermId = d.getSample().getPermId();
            Long maxDatasetIdForSample = TrackingBO.getMaxDataSetIdForSample(trackingState, lanePermId);
            if (!filterList.contains(currentLaneId) || newDataSetID <= maxDatasetIdForSample) continue;
            LogUtils.debug("DataSetID: " + newDataSetID + " of NEW data Sets > MAX DataSet id for this sample: " + maxDatasetIdForSample);
            filteredDataSets.add(d);
            TrackingBO.addDataSetTo(changedTrackingMap, d);
            if (!spaceWhiteList.contains(d.getSpace().getCode()) && !d.getSpace().getCode().startsWith(params.getDbmSpacePrefix()) || !datasetTypeList.contains(d.getDataSetType().getCode())) continue;
            if (d.tryGetAsDataSet().getStatus().equals((Object)DataSetArchivingStatus.AVAILABLE) || d.tryGetAsDataSet().getStatus().equals((Object)DataSetArchivingStatus.LOCKED)) {
                if (d.getDataSetType().getCode().equals(HIGH_PRIORITY_DATA_SET_TYPE)) {
                    toTransferDataSetsHighPriority.add(d);
                    continue;
                }
                toTransferDataSets.add(d);
                continue;
            }
            LogUtils.error("Data set " + d.getCode() + " eventually archived!");
        }
        LogUtils.info("TO_TRANSFER: Found " + toTransferDataSets.size() + " data sets which are in the list of 'space-whitelist' and could be transferred to an extra folder");
        if (commandLineMap.containsKey("copy_data_sets")) {
            ArrayList<AbstractExternalData> toTransferDataSetsAll = new ArrayList<AbstractExternalData>(toTransferDataSetsHighPriority.size() + toTransferDataSets.size());
            toTransferDataSetsAll.addAll(toTransferDataSetsHighPriority);
            toTransferDataSetsAll.addAll(toTransferDataSets);
            if (!toTransferDataSetsAll.isEmpty()) {
                TrackingBO.extraSCICOREDataSetListCopy(params, toTransferDataSetsAll);
            }
        }
        LogUtils.info("Found " + filteredDataSets.size() + " data sets which are connected to samples in " + filterList.toString());
        TrackingBO.setLaneProperties(changedTrackingMap, v3, v3SessionToken);
        return TrackingBO.gatherTrackedEntities(trackingState, trackingServer, session, filteredDataSets, changedTrackingMap);
    }

    private static SearchResult<Sample> searchForSamples(String permId, String v3sessionToken, IApplicationServerApi v3) {
        SampleSearchCriteria criterion = new SampleSearchCriteria();
        criterion.withPermId().thatEquals(permId);
        SampleFetchOptions fetchOptions = new SampleFetchOptions();
        fetchOptions.withProperties();
        return v3.searchSamples(v3sessionToken, criterion, fetchOptions);
    }

    private static void setLaneProperties(HashMap<String, ArrayList<Long>> changedTrackingMap, IApplicationServerApi v3, String v3sessionToken) {
        for (String lanePermId : changedTrackingMap.keySet()) {
            SearchResult<Sample> samples = TrackingBO.searchForSamples(lanePermId, v3sessionToken, v3);
            for (Sample sample : samples.getObjects()) {
                SampleUpdate sampleToUpdate = new SampleUpdate();
                sampleToUpdate.setSampleId((ISampleId)sample.getPermId());
                sampleToUpdate.setProperty(PROPERTY_DATA_TRANSFERRED, TrackingBO.getCurrentDateTime());
                v3.updateSamples(v3sessionToken, Arrays.asList(sampleToUpdate));
            }
        }
    }

    private static String getCurrentDateTime() {
        return new SimpleDateFormat(DATE_FORMAT_PATTERN).format(Calendar.getInstance().getTime());
    }

    private static void extraSCICOREDataSetListCopy(Parameters params, List<AbstractExternalData> dataSets) {
        LogUtils.info("SCICORE dataset listing - Start");
        String datasetListFileBytes = "";
        for (AbstractExternalData dataSet : dataSets) {
            datasetListFileBytes = datasetListFileBytes + dataSet.getPermId() + "\n";
        }
        LogUtils.info("SCICORE dataset listing - Content : " + datasetListFileBytes);
        String timestamp = LIST_TIMESTAMP_FORMAT.format(new Date());
        String tempCanonicalPath = null;
        try {
            tempCanonicalPath = Files.createTempDirectory(timestamp + "-tracking-temp-", new FileAttribute[0]).toFile().getCanonicalPath();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        LogUtils.info("SCICORE dataset listing - temp : " + tempCanonicalPath);
        String datasetTypeCode = HIGH_PRIORITY_DATA_SET_TYPE;
        String datasetName = timestamp + "_LIST";
        File datasetSource = new File(tempCanonicalPath + "/" + datasetName);
        datasetSource.mkdirs();
        LogUtils.info("SCICORE dataset listing - datasetSource : " + datasetSource.getPath());
        File datasetListFile = new File(tempCanonicalPath + "/" + datasetName + "/" + timestamp + ".tsv");
        try {
            Files.write(datasetListFile.toPath(), datasetListFileBytes.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        LogUtils.info("SCICORE dataset listing - writing to : " + datasetListFile.getPath());
        File datasetDestination = new File(params.getDestinationFolderMap().get(datasetTypeCode), datasetName);
        datasetDestination.mkdirs();
        LogUtils.info("SCICORE dataset listing - datasetDestination : " + datasetDestination.getPath());
        RsyncCopier copier = null;
        File rsyncBinary = new File(params.getRsyncBinary());
        if (params.getRsyncFlags() != null) {
            LogUtils.info("SCICORE dataset listing - RSYNC WITH EXTRA PARAMETERS ");
            ArrayList cmdLineOptions = new ArrayList(params.getRsyncFlags().length);
            Collections.addAll(cmdLineOptions, params.getRsyncFlags());
            copier = new RsyncCopier(rsyncBinary, null, cmdLineOptions.toArray(new String[cmdLineOptions.size()]));
        } else {
            LogUtils.info("SCICORE dataset listing - RSYNC NO EXTRA PARAMETERS ");
            copier = new RsyncCopier(rsyncBinary, (File)null, new String[]{""});
        }
        long start = System.currentTimeMillis();
        LogUtils.info("SCICORE dataset listing - BEFORE RSYNC");
        Status status = copier.copyContent(datasetSource, datasetDestination, null, null);
        long end = System.currentTimeMillis();
        LogUtils.info("SCICORE dataset listing - AFTER RSYNC TIME: " + (end - start) + " millis.");
        LogUtils.info("SCICORE dataset listing - AFTER RSYNC STATUS: " + status.toString());
        if (status.isError()) {
            String exceptionMsg = status == null ? "" : " Unexpected exception has occured: " + status.toString();
            ArrayList<EMailAddress> adminEmails = new ArrayList<EMailAddress>();
            for (String adminEmail : params.getAdminEmail().split(",")) {
                adminEmails.add(new EMailAddress(adminEmail.trim()));
            }
            EnvironmentFailureException ret = LogUtils.environmentError("Data transfer failed for %s. %s", datasetName, exceptionMsg);
            IMailClient emailClient = params.getMailClient();
            emailClient.sendEmailMessage("GFB Tracker: Data transfer problem", ret.getLocalizedMessage(), null, new EMailAddress(params.getNotificationEmail()), adminEmails.toArray(new EMailAddress[0]));
        }
    }

    private static void extraDataSetCopy(Parameters params, List<AbstractExternalData> dataSets) {
        RsyncCopier copier = null;
        File rsyncBinary = new File(params.getRsyncBinary());
        String base_path_string = params.getDssRoot();
        if (params.getRsyncFlags() != null) {
            ArrayList cmdLineOptions = new ArrayList(params.getRsyncFlags().length);
            Collections.addAll(cmdLineOptions, params.getRsyncFlags());
            copier = new RsyncCopier(rsyncBinary, null, cmdLineOptions.toArray(new String[cmdLineOptions.size()]));
        } else {
            LogUtils.info("No extra rsync parameters found.");
            copier = new RsyncCopier(rsyncBinary, (File)null, new String[]{""});
        }
        for (AbstractExternalData ds : dataSets) {
            File source = new File(base_path_string, ds.tryGetAsDataSet().getFullLocation() + ORIGINAL_PATH);
            File targetName = new File(ds.tryGetAsDataSet().getFullLocation());
            String datasetTypCode = ds.getDataSetType().getCode();
            File omittedSource = new File(base_path_string, ds.tryGetAsDataSet().getFullLocation() + ORIGINAL_PATH + source.list()[0]);
            File destination = new File(params.getDestinationFolderMap().get(datasetTypCode), targetName.getName());
            if (!destination.exists()) {
                destination.mkdirs();
            }
            long start = System.currentTimeMillis();
            LogUtils.info("Start rsyncing " + ds.getCode() + " from " + omittedSource.getPath() + " to " + destination.getPath());
            Status status = copier.copyContent(omittedSource, destination, null, null);
            if (status.isError()) {
                String exceptionMsg = status == null ? "" : " Unexpected exception has occured: " + status.toString();
                ArrayList<EMailAddress> adminEmails = new ArrayList<EMailAddress>();
                for (String adminEmail : params.getAdminEmail().split(",")) {
                    adminEmails.add(new EMailAddress(adminEmail.trim()));
                }
                EnvironmentFailureException ret = LogUtils.environmentError("Data transfer failed for %s. %s", ds.getCode(), exceptionMsg);
                IMailClient emailClient = params.getMailClient();
                emailClient.sendEmailMessage("GFB Tracker: Data transfer problem", ret.getLocalizedMessage(), null, new EMailAddress(params.getNotificationEmail()), adminEmails.toArray(new EMailAddress[0]));
            }
            LogUtils.info(String.format("Got status: " + status + " for " + ds.getCode() + ", finished after %.2f s", (double)(System.currentTimeMillis() - start) / 1000.0));
        }
    }

    private static long getMaxDataSetId(TrackingStateDTO trackingState) {
        long maxDataSetId = 0L;
        for (Long id : trackingState.getLastSeenDataSetIdMap().values()) {
            maxDataSetId = Math.max(maxDataSetId, id);
        }
        return maxDataSetId;
    }

    private static long getUsableDataSetId(TrackingStateDTO trackingState, Parameters params) {
        long maxDataSetId = TrackingBO.getMaxDataSetId(trackingState);
        long oldDataSetBacklogNumber = params.getoldDataSetBacklogNumber();
        long usableDataSetId = Math.max(maxDataSetId - oldDataSetBacklogNumber, 0L);
        return usableDataSetId;
    }

    private static long getMaxDataSetIdForSample(TrackingStateDTO trackingState, String lanePermId) {
        long maxDataSetId = 0L;
        Long maxDatasetIdForSample = trackingState.getLastSeenDataSetIdMap().get(lanePermId);
        if (maxDatasetIdForSample != null) {
            return maxDatasetIdForSample;
        }
        return maxDataSetId;
    }

    private static TrackedEntities gatherTrackedEntities(TrackingStateDTO trackingState, ITrackingServer trackingServer, SessionContextDTO session, List<AbstractExternalData> dataSets, HashMap<String, ArrayList<Long>> changedTrackingMap) {
        List<ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample> sequencingSamplesToBeProcessed = TrackingBO.listSequencingSamples(PROCESSING_POSSIBLE_PROPERTY_CODE, trackingState.getAlreadyTrackedSampleIdsToBeProcessed(), trackingServer, session);
        List<ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample> sequencingSamplesSuccessfullyProcessed = TrackingBO.listSequencingSamples(PROCESSING_SUCCESSFUL_PROPERTY_CODE, trackingState.getAlreadyTrackedSampleIdsProcessed(), trackingServer, session);
        return new TrackedEntities(sequencingSamplesToBeProcessed, sequencingSamplesSuccessfullyProcessed, dataSets, changedTrackingMap);
    }

    private static void addDataSetTo(HashMap<String, ArrayList<Long>> changedTrackingMap, AbstractExternalData dataSet) {
        ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample currentLane = dataSet.getSample();
        String lanePermId = currentLane.getPermId();
        LogUtils.debug("Found lane " + currentLane.getCode() + " with permId: " + lanePermId + " with new DS techId " + dataSet.getId() + " and DS permId " + dataSet.getPermId());
        ArrayList<Long> existingList = changedTrackingMap.get(lanePermId);
        if (existingList == null) {
            existingList = new ArrayList();
            changedTrackingMap.put(lanePermId, existingList);
        }
        existingList.add(dataSet.getId());
    }

    private static List<ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample> listSequencingSamples(String propertyTypeCode, Set<Long> alreadyTrackedSampleIds, ITrackingServer trackingServer, SessionContextDTO session) {
        return TrackingBO.listSamples(SEQUENCING_SAMPLE_TYPE, propertyTypeCode, TRUE, alreadyTrackedSampleIds, trackingServer, session);
    }

    private static List<ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample> listSamples(String sampleType, String propertyTypeCode, String propertyValue, Set<Long> alreadyTrackedSampleIds, ITrackingServer trackingServer, SessionContextDTO session) {
        TrackingSampleCriteria criteria = new TrackingSampleCriteria(sampleType, propertyTypeCode, propertyValue, alreadyTrackedSampleIds);
        return trackingServer.listSamples(session.getSessionToken(), criteria);
    }

    static class TrackingStateUpdateHelper {
        TrackingStateUpdateHelper() {
        }

        static TrackingStateDTO calcNewTrackingState(TrackingStateDTO prevState, TrackedEntities changedEntities) {
            TrackingStateDTO state = new TrackingStateDTO();
            TreeSet<Long> sequencingSamplesToBeProcessed = new TreeSet<Long>(prevState.getAlreadyTrackedSampleIdsToBeProcessed());
            TrackingStateUpdateHelper.addNewSampleIds(sequencingSamplesToBeProcessed, changedEntities.getSequencingSamplesToBeProcessed());
            state.setAlreadyTrackedSampleIdsToBeProcessed(sequencingSamplesToBeProcessed);
            TreeSet<Long> sequencingSamplesProcessed = new TreeSet<Long>(prevState.getAlreadyTrackedSampleIdsProcessed());
            TrackingStateUpdateHelper.addNewSampleIds(sequencingSamplesProcessed, changedEntities.getSequencingSamplesProcessed());
            state.setAlreadyTrackedSampleIdsProcessed(sequencingSamplesProcessed);
            TreeMap<String, Long> newTrackingState = new TreeMap<String, Long>();
            HashMap<String, ArrayList<Long>> changedTrackingMap = changedEntities.getChangedTrackingMap();
            for (Map.Entry<String, ArrayList<Long>> entry : changedTrackingMap.entrySet()) {
                newTrackingState.put(entry.getKey(), (Long)Collections.max((Collection)entry.getValue()));
            }
            for (Map.Entry<String, Serializable> entry : prevState.getLastSeenDataSetIdMap().entrySet()) {
                if (newTrackingState.containsKey(entry.getKey())) continue;
                newTrackingState.put(entry.getKey(), (Long)entry.getValue());
            }
            state.setLastSeenDataSetIdMap(newTrackingState);
            return state;
        }

        static TrackingStateDTO calcNewTrackingStateDataSets(HashMap<String, ArrayList<Long>> changedTrackingMap, TrackedEntities changedEntities) {
            TrackingStateDTO state = new TrackingStateDTO();
            TreeMap<String, Long> newTrackingState = new TreeMap<String, Long>();
            for (Map.Entry<String, ArrayList<Long>> entry : changedTrackingMap.entrySet()) {
                newTrackingState.put(entry.getKey(), (Long)Collections.max((Collection)entry.getValue()));
            }
            LogUtils.info(newTrackingState.toString());
            state.setLastSeenDataSetIdMap(newTrackingState);
            return state;
        }

        private static void addNewSampleIds(Set<Long> alreadyTrackedSampleIdsProcessed, List<ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample> sequencingSamplesProcessed) {
            for (ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample sample : sequencingSamplesProcessed) {
                alreadyTrackedSampleIdsProcessed.add(sample.getId());
            }
        }
    }
}

