/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.CoreMetadata;
import loci.formats.FileInfo;
import loci.formats.FormatException;
import loci.formats.FormatHandler;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.Modulo;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.DummyMetadata;
import loci.formats.meta.FilterMetadata;
import loci.formats.meta.IMetadata;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.services.OMEXMLService;
import ome.xml.model.AffineTransform;
import ome.xml.model.enums.AcquisitionMode;
import ome.xml.model.enums.ArcType;
import ome.xml.model.enums.Binning;
import ome.xml.model.enums.Compression;
import ome.xml.model.enums.ContrastMethod;
import ome.xml.model.enums.Correction;
import ome.xml.model.enums.DetectorType;
import ome.xml.model.enums.DimensionOrder;
import ome.xml.model.enums.ExperimentType;
import ome.xml.model.enums.FilamentType;
import ome.xml.model.enums.FillRule;
import ome.xml.model.enums.FilterType;
import ome.xml.model.enums.FontFamily;
import ome.xml.model.enums.FontStyle;
import ome.xml.model.enums.IlluminationType;
import ome.xml.model.enums.Immersion;
import ome.xml.model.enums.LaserMedium;
import ome.xml.model.enums.LaserType;
import ome.xml.model.enums.Marker;
import ome.xml.model.enums.Medium;
import ome.xml.model.enums.MicrobeamManipulationType;
import ome.xml.model.enums.MicroscopeType;
import ome.xml.model.enums.NamingConvention;
import ome.xml.model.enums.PixelType;
import ome.xml.model.enums.Pulse;

public abstract class FormatReader
extends FormatHandler
implements IFormatReader {
    protected static final int THUMBNAIL_DIMENSION = 128;
    protected transient RandomAccessInputStream in;
    protected Hashtable<String, Object> metadata;
    protected int coreIndex = 0;
    protected int series = 0;
    protected List<CoreMetadata> core;
    protected int resolution = 0;
    protected boolean flattenedResolutions = true;
    protected boolean suffixNecessary = true;
    protected boolean suffixSufficient = true;
    protected boolean hasCompanionFiles = false;
    protected String datasetDescription = "Single file";
    protected boolean normalizeData;
    protected boolean filterMetadata;
    protected boolean saveOriginalMetadata = false;
    protected boolean indexedAsRGB = false;
    protected boolean group = true;
    protected String[] domains = new String[0];
    protected MetadataStore metadataStore = new DummyMetadata();
    private ServiceFactory factory;
    private OMEXMLService service;

    public FormatReader(String format, String suffix) {
        super(format, suffix);
    }

    public FormatReader(String format, String[] suffixes) {
        super(format, suffixes);
    }

    @Override
    public void reopenFile() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
        this.in = new RandomAccessInputStream(this.currentId);
        this.in.order(this.isLittleEndian());
    }

    protected void initFile(String id) throws FormatException, IOException {
        LOGGER.debug("{}.initFile({})", (Object)this.getClass().getName(), (Object)id);
        if (this.currentId != null) {
            String[] s2 = this.getUsedFiles();
            for (int i = 0; i < s2.length; ++i) {
                if (!id.equals(s2[i])) continue;
                return;
            }
        }
        this.coreIndex = 0;
        this.series = 0;
        this.close();
        this.currentId = id;
        this.metadata = new Hashtable();
        this.core = new ArrayList<CoreMetadata>();
        CoreMetadata core0 = new CoreMetadata();
        this.core.add(core0);
        core0.orderCertain = true;
        this.getMetadataStore().createRoot();
    }

    protected boolean isUsedFile(String file2) {
        String[] usedFiles;
        for (String used : usedFiles = this.getUsedFiles()) {
            if (used.equals(file2)) {
                return true;
            }
            String path = new Location(file2).getAbsolutePath();
            if (!used.equals(path)) continue;
            return true;
        }
        return false;
    }

    protected void addMeta(String key, Object value, Hashtable<String, Object> meta) {
        String val;
        if (key == null || value == null || this.getMetadataOptions().getMetadataLevel() == MetadataLevel.MINIMUM) {
            return;
        }
        key = key.trim();
        boolean string = value instanceof String || value instanceof Character;
        String string2 = val = string ? String.valueOf(value) : null;
        if (this.filterMetadata || this.saveOriginalMetadata && this.getMetadataStore() instanceof OMEXMLMetadata) {
            boolean simple;
            boolean bl = simple = string || value instanceof Number || value instanceof Boolean;
            if (!simple) {
                return;
            }
            int maxLen = 8192;
            if (key.length() > maxLen) {
                return;
            }
            if (string && val.length() > maxLen) {
                return;
            }
            key = DataTools.sanitize(key);
            if (string) {
                val = DataTools.sanitize(val);
            }
            if (!key.matches(".*[a-zA-Z].*")) {
                return;
            }
            String[] invalidSequences = new String[]{"&lt;", "&gt;", "&amp;", "<", ">", "&"};
            for (int i = 0; i < invalidSequences.length; ++i) {
                if (key.indexOf(invalidSequences[i]) >= 0) {
                    key = key.replaceAll(invalidSequences[i], "");
                }
                if (!string || val.indexOf(invalidSequences[i]) < 0) continue;
                val = val.replaceAll(invalidSequences[i], "");
            }
            if (key.length() == 0) {
                return;
            }
            if (string && val.trim().length() == 0) {
                return;
            }
            if (string) {
                value = val;
            }
        }
        meta.put(key, val == null ? value : val);
    }

    protected void addGlobalMeta(String key, Object value) {
        this.addMeta(key, value, this.metadata);
    }

    protected void addGlobalMeta(String key, boolean value) {
        this.addGlobalMeta(key, (Object)value);
    }

    protected void addGlobalMeta(String key, byte value) {
        this.addGlobalMeta(key, (Object)value);
    }

    protected void addGlobalMeta(String key, short value) {
        this.addGlobalMeta(key, (Object)value);
    }

    protected void addGlobalMeta(String key, int value) {
        this.addGlobalMeta(key, (Object)value);
    }

    protected void addGlobalMeta(String key, long value) {
        this.addGlobalMeta(key, (Object)value);
    }

    protected void addGlobalMeta(String key, float value) {
        this.addGlobalMeta(key, Float.valueOf(value));
    }

    protected void addGlobalMeta(String key, double value) {
        this.addGlobalMeta(key, (Object)value);
    }

    protected void addGlobalMeta(String key, char value) {
        this.addGlobalMeta(key, Character.valueOf(value));
    }

    protected Object getGlobalMeta(String key) {
        return this.metadata.get(key);
    }

    protected void addMetaList(String key, Object value, Hashtable<String, Object> meta) {
        Vector<Object> list = (Vector<Object>)meta.remove(key);
        this.addMeta(key, value, meta);
        Object newValue = meta.remove(key);
        if (newValue != null) {
            if (list == null) {
                list = new Vector<Object>();
            }
            list.add(newValue);
            meta.put(key, list);
        } else if (list != null) {
            meta.put(key, list);
        }
    }

    protected void addGlobalMetaList(String key, Object value) {
        this.addMetaList(key, value, this.metadata);
    }

    protected void addSeriesMetaList(String key, Object value) {
        this.addMetaList(key, value, this.getCurrentCore().seriesMetadata);
    }

    protected void flattenHashtables() {
        this.updateMetadataLists(this.metadata);
        for (int s2 = 0; s2 < this.core.size(); ++s2) {
            if (this.core.get((int)s2).seriesMetadata.size() <= 0) continue;
            this.updateMetadataLists(this.core.get((int)s2).seriesMetadata);
        }
    }

    protected void updateMetadataLists(Hashtable<String, Object> meta) {
        String[] keys;
        for (String key : keys = meta.keySet().toArray(new String[meta.size()])) {
            Object v = meta.get(key);
            if (!(v instanceof Vector)) continue;
            Vector list = (Vector)v;
            int digits = String.valueOf(list.size()).length();
            for (int i = 0; i < list.size(); ++i) {
                String index = String.valueOf(i + 1);
                while (index.length() < digits) {
                    index = "0" + index;
                }
                meta.put(key + " #" + index, list.get(i));
            }
            meta.remove(key);
        }
    }

    protected void addSeriesMeta(String key, Object value) {
        this.addMeta(key, value, this.getCurrentCore().seriesMetadata);
    }

    protected void addSeriesMeta(String key, boolean value) {
        this.addSeriesMeta(key, (Object)value);
    }

    protected void addSeriesMeta(String key, byte value) {
        this.addSeriesMeta(key, (Object)value);
    }

    protected void addSeriesMeta(String key, short value) {
        this.addSeriesMeta(key, (Object)value);
    }

    protected void addSeriesMeta(String key, int value) {
        this.addSeriesMeta(key, (Object)value);
    }

    protected void addSeriesMeta(String key, long value) {
        this.addSeriesMeta(key, (Object)value);
    }

    protected void addSeriesMeta(String key, float value) {
        this.addSeriesMeta(key, Float.valueOf(value));
    }

    protected void addSeriesMeta(String key, double value) {
        this.addSeriesMeta(key, (Object)value);
    }

    protected void addSeriesMeta(String key, char value) {
        this.addSeriesMeta(key, Character.valueOf(value));
    }

    protected Object getSeriesMeta(String key) {
        return this.getCurrentCore().seriesMetadata.get(key);
    }

    protected byte[] readPlane(RandomAccessInputStream s2, int x, int y, int w, int h2, byte[] buf) throws IOException {
        return this.readPlane(s2, x, y, w, h2, 0, buf);
    }

    protected byte[] readPlane(RandomAccessInputStream s2, int x, int y, int w, int h2, int scanlinePad, byte[] buf) throws IOException {
        int c = this.getRGBChannelCount();
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        if (x == 0 && y == 0 && w == this.getSizeX() && h2 == this.getSizeY() && scanlinePad == 0) {
            s2.read(buf);
        } else if (x == 0 && w == this.getSizeX() && scanlinePad == 0) {
            if (this.isInterleaved()) {
                s2.skipBytes((long)y * (long)w * (long)bpp * (long)c);
                s2.read(buf, 0, h2 * w * bpp * c);
            } else {
                int rowLen = w * bpp;
                for (int channel = 0; channel < c; ++channel) {
                    s2.skipBytes((long)y * (long)rowLen);
                    s2.read(buf, channel * h2 * rowLen, h2 * rowLen);
                    if (channel >= c - 1) continue;
                    s2.skipBytes((long)(this.getSizeY() - y - h2) * (long)rowLen);
                }
            }
        } else {
            long scanlineWidth = this.getSizeX() + scanlinePad;
            if (this.isInterleaved()) {
                s2.skipBytes((long)y * scanlineWidth * (long)bpp * (long)c);
                for (int row = 0; row < h2; ++row) {
                    s2.skipBytes(x * bpp * c);
                    s2.read(buf, row * w * bpp * c, w * bpp * c);
                    if (row >= h2 - 1) continue;
                    s2.skipBytes((long)(bpp * c) * (scanlineWidth - (long)w - (long)x));
                }
            } else {
                for (int channel = 0; channel < c; ++channel) {
                    s2.skipBytes((long)y * scanlineWidth * (long)bpp);
                    for (int row = 0; row < h2; ++row) {
                        s2.skipBytes(x * bpp);
                        s2.read(buf, channel * w * h2 * bpp + row * w * bpp, w * bpp);
                        if (row >= h2 - 1 && channel >= c - 1) continue;
                        s2.skipBytes((long)bpp * (scanlineWidth - (long)w - (long)x));
                    }
                    if (channel >= c - 1) continue;
                    s2.skipBytes(scanlineWidth * (long)bpp * (long)(this.getSizeY() - y - h2));
                }
            }
        }
        return buf;
    }

    protected MetadataStore makeFilterMetadata() {
        return new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isThisType(String name, boolean open) {
        if (!this.suffixSufficient && !open) {
            return false;
        }
        if (this.suffixNecessary || this.suffixSufficient) {
            boolean suffixMatch = super.isThisType(name);
            if (this.suffixNecessary && !suffixMatch) {
                return false;
            }
            if (suffixMatch && this.suffixSufficient) {
                return true;
            }
        }
        if (!open) {
            return false;
        }
        try (RandomAccessInputStream stream = new RandomAccessInputStream(name);){
            boolean bl = this.isThisType(stream);
            return bl;
        }
        catch (IOException exc) {
            LOGGER.debug("", exc);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isThisType(byte[] block) {
        try (RandomAccessInputStream stream = new RandomAccessInputStream(block);){
            boolean bl = this.isThisType(stream);
            return bl;
        }
        catch (IOException e) {
            LOGGER.debug("", e);
            return false;
        }
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        return false;
    }

    @Override
    public int getImageCount() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.getCurrentCore().imageCount;
    }

    @Override
    public boolean isRGB() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.getCurrentCore().rgb;
    }

    @Override
    public int getSizeX() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.getCurrentCore().sizeX;
    }

    @Override
    public int getSizeY() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.getCurrentCore().sizeY;
    }

    @Override
    public int getSizeZ() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.getCurrentCore().sizeZ;
    }

    @Override
    public int getSizeC() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.getCurrentCore().sizeC;
    }

    @Override
    public int getSizeT() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.getCurrentCore().sizeT;
    }

    @Override
    public int getPixelType() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.getCurrentCore().pixelType;
    }

    @Override
    public int getBitsPerPixel() {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.getCurrentCore().bitsPerPixel == 0) {
            this.getCurrentCore().bitsPerPixel = FormatTools.getBytesPerPixel(this.getPixelType()) * 8;
        }
        return this.getCurrentCore().bitsPerPixel;
    }

    @Override
    public int getEffectiveSizeC() {
        int sizeZT = this.getSizeZ() * this.getSizeT();
        if (sizeZT == 0) {
            return 0;
        }
        return this.getImageCount() / sizeZT;
    }

    @Override
    public int getRGBChannelCount() {
        int effSizeC = this.getEffectiveSizeC();
        if (effSizeC == 0) {
            return 0;
        }
        return this.getSizeC() / effSizeC;
    }

    @Override
    public boolean isIndexed() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.getCurrentCore().indexed;
    }

    @Override
    public boolean isFalseColor() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.getCurrentCore().falseColor;
    }

    @Override
    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        return null;
    }

    @Override
    public short[][] get16BitLookupTable() throws FormatException, IOException {
        return null;
    }

    @Override
    public Modulo getModuloZ() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.getCurrentCore().moduloZ;
    }

    @Override
    public Modulo getModuloC() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.getCurrentCore().moduloC;
    }

    @Override
    public Modulo getModuloT() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.getCurrentCore().moduloT;
    }

    @Override
    public int getThumbSizeX() {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.getCurrentCore().thumbSizeX == 0) {
            int sx = this.getSizeX();
            int sy = this.getSizeY();
            int thumbSizeX = 0;
            if (sx < 128 && sy < 128) {
                thumbSizeX = sx;
            } else if (sx > sy) {
                thumbSizeX = 128;
            } else if (sy > 0) {
                thumbSizeX = sx * 128 / sy;
            }
            if (thumbSizeX == 0) {
                thumbSizeX = 1;
            }
            return thumbSizeX;
        }
        return this.getCurrentCore().thumbSizeX;
    }

    @Override
    public int getThumbSizeY() {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.getCurrentCore().thumbSizeY == 0) {
            int sx = this.getSizeX();
            int sy = this.getSizeY();
            int thumbSizeY = 1;
            if (sx < 128 && sy < 128) {
                thumbSizeY = sy;
            } else if (sy > sx) {
                thumbSizeY = 128;
            } else if (sx > 0) {
                thumbSizeY = sy * 128 / sx;
            }
            if (thumbSizeY == 0) {
                thumbSizeY = 1;
            }
            return thumbSizeY;
        }
        return this.getCurrentCore().thumbSizeY;
    }

    @Override
    public boolean isLittleEndian() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.getCurrentCore().littleEndian;
    }

    @Override
    public String getDimensionOrder() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.getCurrentCore().dimensionOrder;
    }

    @Override
    public boolean isOrderCertain() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.getCurrentCore().orderCertain;
    }

    @Override
    public boolean isThumbnailSeries() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.getCurrentCore().thumbnail;
    }

    @Override
    public boolean isInterleaved() {
        return this.isInterleaved(0);
    }

    @Override
    public boolean isInterleaved(int subC) {
        FormatTools.assertId(this.currentId, true, 1);
        return this.getCurrentCore().interleaved;
    }

    @Override
    public byte[] openBytes(int no) throws FormatException, IOException {
        return this.openBytes(no, 0, 0, this.getSizeX(), this.getSizeY());
    }

    @Override
    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        return this.openBytes(no, buf, 0, 0, this.getSizeX(), this.getSizeY());
    }

    @Override
    public byte[] openBytes(int no, int x, int y, int w, int h2) throws FormatException, IOException {
        byte[] newBuffer;
        int ch = this.getRGBChannelCount();
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        try {
            newBuffer = DataTools.allocate(w, h2, ch, bpp);
        }
        catch (IllegalArgumentException e) {
            throw new FormatException("Image plane too large. Only 2GB of data can be extracted at one time. You can work around the problem by opening the plane in tiles; for further details, see: https://docs.openmicroscopy.org/bio-formats/" + FormatTools.VERSION + "/about/bug-reporting.html#common-issues-to-check", e);
        }
        return this.openBytes(no, newBuffer, x, y, w, h2);
    }

    @Override
    public abstract byte[] openBytes(int var1, byte[] var2, int var3, int var4, int var5, int var6) throws FormatException, IOException;

    @Override
    public Object openPlane(int no, int x, int y, int w, int h2) throws FormatException, IOException {
        return this.openBytes(no, x, y, w, h2);
    }

    @Override
    public byte[] openThumbBytes(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        return FormatTools.openThumbBytes(this, no);
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        if (this.in != null) {
            this.in.close();
        }
        if (!fileOnly) {
            this.in = null;
            this.currentId = null;
            this.resolution = 0;
            this.core = null;
        }
    }

    @Override
    public int getSeriesCount() {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.hasFlattenedResolutions()) {
            return this.core.size();
        }
        return this.coreIndexToSeries(this.core.size() - 1) + 1;
    }

    @Override
    public void setSeries(int no) {
        this.coreIndex = this.seriesToCoreIndex(no);
        this.series = no;
        this.resolution = 0;
    }

    @Override
    public int getSeries() {
        return this.series;
    }

    @Override
    public void setGroupFiles(boolean groupFiles) {
        FormatTools.assertId(this.currentId, false, 1);
        this.group = groupFiles;
    }

    @Override
    public boolean isGroupFiles() {
        return this.group;
    }

    @Override
    public int fileGroupOption(String id) throws FormatException, IOException {
        return 2;
    }

    @Override
    public boolean isMetadataComplete() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.getCurrentCore().metadataComplete;
    }

    @Override
    public void setNormalized(boolean normalize) {
        FormatTools.assertId(this.currentId, false, 1);
        this.normalizeData = normalize;
    }

    @Override
    public boolean isNormalized() {
        return this.normalizeData;
    }

    @Override
    public void setOriginalMetadataPopulated(boolean populate) {
        FormatTools.assertId(this.currentId, false, 1);
        this.saveOriginalMetadata = populate;
    }

    @Override
    public boolean isOriginalMetadataPopulated() {
        return this.saveOriginalMetadata;
    }

    @Override
    public String[] getUsedFiles() {
        return this.getUsedFiles(false);
    }

    @Override
    public String[] getUsedFiles(boolean noPixels) {
        int seriesCount = this.getSeriesCount();
        if (seriesCount == 1) {
            String[] seriesUsedFiles = this.getSeriesUsedFiles(noPixels);
            if (null == seriesUsedFiles) {
                seriesUsedFiles = new String[]{};
            }
            return seriesUsedFiles;
        }
        int oldSeries = this.getSeries();
        LinkedHashSet<String> files = new LinkedHashSet<String>();
        for (int i = 0; i < seriesCount; ++i) {
            this.setSeries(i);
            String[] seriesUsedFiles = this.getSeriesUsedFiles(noPixels);
            if (seriesUsedFiles == null) continue;
            files.addAll(Arrays.asList(seriesUsedFiles));
        }
        this.setSeries(oldSeries);
        return files.toArray(new String[files.size()]);
    }

    @Override
    public String[] getSeriesUsedFiles() {
        return this.getSeriesUsedFiles(false);
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        String[] stringArray;
        if (noPixels) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this.currentId;
        }
        return stringArray;
    }

    @Override
    public FileInfo[] getAdvancedUsedFiles(boolean noPixels) {
        String[] files = this.getUsedFiles(noPixels);
        if (files == null) {
            return null;
        }
        FileInfo[] infos = new FileInfo[files.length];
        for (int i = 0; i < infos.length; ++i) {
            infos[i] = new FileInfo();
            infos[i].filename = files[i];
            infos[i].reader = this.getClass();
            infos[i].usedToInitialize = files[i].endsWith(this.getCurrentFile());
        }
        return infos;
    }

    @Override
    public FileInfo[] getAdvancedSeriesUsedFiles(boolean noPixels) {
        String[] files = this.getSeriesUsedFiles(noPixels);
        if (files == null) {
            return null;
        }
        FileInfo[] infos = new FileInfo[files.length];
        for (int i = 0; i < infos.length; ++i) {
            infos[i] = new FileInfo();
            infos[i].filename = files[i];
            infos[i].reader = this.getClass();
            infos[i].usedToInitialize = files[i].endsWith(this.getCurrentFile());
        }
        return infos;
    }

    @Override
    public String getCurrentFile() {
        return this.currentId;
    }

    @Override
    public int getIndex(int z, int c, int t) {
        FormatTools.assertId(this.currentId, true, 1);
        return FormatTools.getIndex(this, z, c, t);
    }

    @Override
    public int getIndex(int z, int c, int t, int moduloZ, int moduloC, int moduloT) {
        FormatTools.assertId(this.currentId, true, 1);
        return FormatTools.getIndex(this, z, c, t, moduloZ, moduloC, moduloT);
    }

    @Override
    public int[] getZCTCoords(int index) {
        FormatTools.assertId(this.currentId, true, 1);
        return FormatTools.getZCTCoords(this, index);
    }

    @Override
    public int[] getZCTModuloCoords(int index) {
        FormatTools.assertId(this.currentId, true, 1);
        return FormatTools.getZCTModuloCoords(this, index);
    }

    @Override
    public Object getMetadataValue(String field) {
        FormatTools.assertId(this.currentId, true, 1);
        this.flattenHashtables();
        return this.getGlobalMeta(field);
    }

    @Override
    public Object getSeriesMetadataValue(String field) {
        FormatTools.assertId(this.currentId, true, 1);
        this.flattenHashtables();
        return this.getSeriesMeta(field);
    }

    @Override
    public Hashtable<String, Object> getGlobalMetadata() {
        FormatTools.assertId(this.currentId, true, 1);
        this.flattenHashtables();
        return this.metadata;
    }

    @Override
    public Hashtable<String, Object> getSeriesMetadata() {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.getCurrentCore().seriesMetadata.size() > 0) {
            this.flattenHashtables();
        }
        return this.getCurrentCore().seriesMetadata;
    }

    @Override
    public List<CoreMetadata> getCoreMetadataList() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.core;
    }

    @Override
    public void setMetadataFiltered(boolean filter) {
        FormatTools.assertId(this.currentId, false, 1);
        this.filterMetadata = filter;
    }

    @Override
    public boolean isMetadataFiltered() {
        return this.filterMetadata;
    }

    @Override
    public void setMetadataStore(MetadataStore store) {
        FormatTools.assertId(this.currentId, false, 1);
        if (store == null) {
            throw new IllegalArgumentException("Metadata object cannot be null; use loci.formats.meta.DummyMetadata instead");
        }
        this.metadataStore = store;
    }

    @Override
    public MetadataStore getMetadataStore() {
        return this.metadataStore;
    }

    @Override
    public Object getMetadataStoreRoot() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.getMetadataStore().getRoot();
    }

    @Override
    public IFormatReader[] getUnderlyingReaders() {
        return null;
    }

    @Override
    public boolean isSingleFile(String id) throws FormatException, IOException {
        return true;
    }

    @Override
    public int getRequiredDirectories(String[] files) throws FormatException, IOException {
        return 0;
    }

    @Override
    public String getDatasetStructureDescription() {
        return this.datasetDescription;
    }

    @Override
    public boolean hasCompanionFiles() {
        return this.hasCompanionFiles;
    }

    @Override
    public String[] getPossibleDomains(String id) throws FormatException, IOException {
        return this.domains;
    }

    @Override
    public String[] getDomains() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.domains;
    }

    @Override
    public int getOptimalTileWidth() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.getSizeX();
    }

    @Override
    public int getOptimalTileHeight() {
        FormatTools.assertId(this.currentId, true, 1);
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        int maxHeight = 0x100000 / (this.getSizeX() * this.getRGBChannelCount() * bpp);
        return Math.min(maxHeight, this.getSizeY());
    }

    @Override
    public int seriesToCoreIndex(int series) {
        if (this.hasFlattenedResolutions()) {
            if (series < 0 || series >= this.core.size()) {
                throw new IllegalArgumentException("Invalid series: " + series);
            }
            return series;
        }
        if (this.series == series) {
            return this.coreIndex - this.resolution;
        }
        int index = 0;
        for (int i = 0; i < series && index < this.core.size(); index += this.core.get((int)index).resolutionCount, ++i) {
            if (this.core.get(i) != null) {
                continue;
            }
            throw new IllegalArgumentException("Invalid series (null core[" + i + "]: " + series);
        }
        if (index < 0 || index >= this.core.size()) {
            throw new IllegalArgumentException("Invalid series: " + series + "  index=" + index);
        }
        return index;
    }

    @Override
    public int coreIndexToSeries(int index) {
        if (index < 0 || index >= this.core.size()) {
            throw new IllegalArgumentException("Invalid index: " + index);
        }
        if (this.hasFlattenedResolutions()) {
            return index;
        }
        if (this.coreIndex == index) {
            return this.series;
        }
        int series = 0;
        int i = 0;
        while (i < index) {
            int nextSeries;
            if (this.core.get(i) != null) {
                nextSeries = i + this.core.get((int)i).resolutionCount;
                if (index < nextSeries) break;
            } else {
                throw new IllegalArgumentException("Invalid coreIndex (null core[" + i + "]: " + index);
            }
            i = nextSeries;
            ++series;
        }
        return series;
    }

    @Override
    public int getResolutionCount() {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.hasFlattenedResolutions()) {
            return 1;
        }
        return this.core.get((int)this.seriesToCoreIndex((int)this.getSeries())).resolutionCount;
    }

    @Override
    public void setResolution(int no) {
        if (no < 0 || no >= this.getResolutionCount()) {
            throw new IllegalArgumentException("Invalid resolution: " + no);
        }
        this.coreIndex = this.seriesToCoreIndex(this.getSeries()) + no;
        this.resolution = no;
    }

    @Override
    public int getResolution() {
        return this.resolution;
    }

    @Override
    public boolean hasFlattenedResolutions() {
        return this.flattenedResolutions;
    }

    @Override
    public void setFlattenedResolutions(boolean flattened) {
        FormatTools.assertId(this.currentId, false, 1);
        this.flattenedResolutions = flattened;
    }

    @Override
    public int getCoreIndex() {
        return this.coreIndex;
    }

    @Override
    public void setCoreIndex(int no) {
        if (no < 0 || no >= this.core.size()) {
            throw new IllegalArgumentException("Invalid series: " + no);
        }
        this.series = this.coreIndexToSeries(no);
        this.coreIndex = no;
        this.resolution = no - this.seriesToCoreIndex(this.series);
    }

    @Override
    public boolean isThisType(String name) {
        return this.isThisType(name, true);
    }

    @Override
    public void setId(String id) throws FormatException, IOException {
        if (!this.isOmero(id)) {
            LOGGER.debug("{} initializing {}", (Object)this.getClass().getSimpleName(), (Object)id);
        }
        if (this.currentId == null || !new Location(id).getAbsolutePath().equals(new Location(this.currentId).getAbsolutePath())) {
            this.initFile(id);
            MetadataStore store = this.getMetadataStore();
            if (this.saveOriginalMetadata && store instanceof OMEXMLMetadata) {
                this.setupService();
                Hashtable<String, Object> allMetadata = new Hashtable<String, Object>(this.metadata);
                for (int series = 0; series < this.getSeriesCount(); ++series) {
                    String name = "Series " + series;
                    try {
                        String realName = ((IMetadata)store).getImageName(series);
                        if (realName != null && realName.trim().length() != 0) {
                            name = realName;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.setSeries(series);
                    MetadataTools.merge(this.getSeriesMetadata(), allMetadata, name + " ");
                }
                this.setSeries(0);
                this.service.populateOriginalMetadata((OMEXMLMetadata)store, allMetadata);
            }
            if (store instanceof OMEXMLMetadata) {
                ((OMEXMLMetadata)store).resolveReferences();
                this.setupService();
                if (this.getMetadataOptions().isValidate()) {
                    try {
                        String omexml = this.service.getOMEXML((MetadataRetrieve)((Object)store));
                        this.service.validateOMEXML(omexml);
                    }
                    catch (NullPointerException | ServiceException e) {
                        LOGGER.warn("OMEXMLService unable to create OME-XML metadata object.", e);
                    }
                }
                for (int series = 0; series < this.getSeriesCount(); ++series) {
                    this.setSeries(series);
                    if (this.getModuloZ().length() <= 1 && this.getModuloC().length() <= 1 && this.getModuloT().length() <= 1) continue;
                    this.service.addModuloAlong((OMEXMLMetadata)store, this.getCurrentCore(), series);
                }
                this.setSeries(0);
            }
        }
    }

    private void setupService() {
        try {
            if (this.factory == null) {
                this.factory = new ServiceFactory();
            }
            if (this.service == null) {
                this.service = this.factory.getInstance(OMEXMLService.class);
            }
        }
        catch (DependencyException e) {
            LOGGER.warn("OMEXMLService not available.", e);
        }
    }

    @Override
    public void close() throws IOException {
        this.close(false);
    }

    protected CoreMetadata getCurrentCore() {
        return this.core.get(this.getCoreIndex());
    }

    @Deprecated
    protected AcquisitionMode getAcquisitionMode(String value) throws FormatException {
        return MetadataTools.getAcquisitionMode(value);
    }

    @Deprecated
    protected ArcType getArcType(String value) throws FormatException {
        return MetadataTools.getArcType(value);
    }

    @Deprecated
    protected Binning getBinning(String value) throws FormatException {
        return MetadataTools.getBinning(value);
    }

    @Deprecated
    protected Compression getCompression(String value) throws FormatException {
        return MetadataTools.getCompression(value);
    }

    @Deprecated
    protected ContrastMethod getContrastMethod(String value) throws FormatException {
        return MetadataTools.getContrastMethod(value);
    }

    @Deprecated
    protected Correction getCorrection(String value) throws FormatException {
        return MetadataTools.getCorrection(value);
    }

    @Deprecated
    protected DetectorType getDetectorType(String value) throws FormatException {
        return MetadataTools.getDetectorType(value);
    }

    @Deprecated
    protected DimensionOrder getDimensionOrder(String value) throws FormatException {
        return MetadataTools.getDimensionOrder(value);
    }

    @Deprecated
    protected ExperimentType getExperimentType(String value) throws FormatException {
        return MetadataTools.getExperimentType(value);
    }

    @Deprecated
    protected FilamentType getFilamentType(String value) throws FormatException {
        return MetadataTools.getFilamentType(value);
    }

    @Deprecated
    protected FillRule getFillRule(String value) throws FormatException {
        return MetadataTools.getFillRule(value);
    }

    @Deprecated
    protected FilterType getFilterType(String value) throws FormatException {
        return MetadataTools.getFilterType(value);
    }

    @Deprecated
    protected FontFamily getFontFamily(String value) throws FormatException {
        return MetadataTools.getFontFamily(value);
    }

    @Deprecated
    protected FontStyle getFontStyle(String value) throws FormatException {
        return MetadataTools.getFontStyle(value);
    }

    @Deprecated
    protected IlluminationType getIlluminationType(String value) throws FormatException {
        return MetadataTools.getIlluminationType(value);
    }

    @Deprecated
    protected Immersion getImmersion(String value) throws FormatException {
        return MetadataTools.getImmersion(value);
    }

    @Deprecated
    protected LaserMedium getLaserMedium(String value) throws FormatException {
        return MetadataTools.getLaserMedium(value);
    }

    @Deprecated
    protected LaserType getLaserType(String value) throws FormatException {
        return MetadataTools.getLaserType(value);
    }

    @Deprecated
    protected Marker getMarker(String value) throws FormatException {
        return MetadataTools.getMarker(value);
    }

    @Deprecated
    protected Medium getMedium(String value) throws FormatException {
        return MetadataTools.getMedium(value);
    }

    @Deprecated
    protected MicrobeamManipulationType getMicrobeamManipulationType(String value) throws FormatException {
        return MetadataTools.getMicrobeamManipulationType(value);
    }

    @Deprecated
    protected MicroscopeType getMicroscopeType(String value) throws FormatException {
        return MetadataTools.getMicroscopeType(value);
    }

    @Deprecated
    protected NamingConvention getNamingConvention(String value) throws FormatException {
        return MetadataTools.getNamingConvention(value);
    }

    @Deprecated
    protected PixelType getPixelType(String value) throws FormatException {
        return MetadataTools.getPixelType(value);
    }

    @Deprecated
    protected Pulse getPulse(String value) throws FormatException {
        return MetadataTools.getPulse(value);
    }

    protected AffineTransform getRotationTransform(double theta) {
        AffineTransform transform = new AffineTransform();
        transform.setA02(0.0);
        transform.setA12(0.0);
        transform.setA00(Math.cos(theta));
        transform.setA11(Math.cos(theta));
        transform.setA01(Math.sin(theta));
        transform.setA10(-1.0 * Math.sin(theta));
        return transform;
    }

    private boolean isOmero(String id) {
        return id != null && id.toLowerCase().startsWith("omero:") && id.indexOf("\n") > 0;
    }
}

