/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.imagereaders.jai;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.base.io.AdapterIInputStreamToInputStream;
import ch.systemsx.cisd.base.io.IInputStream;
import ch.systemsx.cisd.base.io.IRandomAccessFile;
import ch.systemsx.cisd.imagereaders.AbstractImageReader;
import ch.systemsx.cisd.imagereaders.IReadParams;
import ch.systemsx.cisd.imagereaders.ImageConvertionUtils;
import ch.systemsx.cisd.imagereaders.ImageID;
import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageDecoder;
import com.sun.media.jai.codecimpl.GIFImageDecoder;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

class DefaultImageReader
extends AbstractImageReader {
    public DefaultImageReader(String libraryName, String readerName) {
        super(libraryName, readerName);
    }

    @Override
    public List<ImageID> getImageIDs(IRandomAccessFile handle) throws IOExceptionUnchecked {
        try {
            AdapterIInputStreamToInputStream input = new AdapterIInputStreamToInputStream((IInputStream)handle);
            ArrayList<ImageID> ids = new ArrayList<ImageID>();
            ImageDecoder decoder = ImageCodec.createImageDecoder((String)this.getName(), (InputStream)input, null);
            int numPages = decoder instanceof GIFImageDecoder ? 1 : decoder.getNumPages();
            int i = 0;
            while (i < numPages) {
                ids.add(new ImageID(0, i, 0, 0));
                ++i;
            }
            return ids;
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
    }

    @Override
    public BufferedImage readImage(IRandomAccessFile handle, ImageID imageID, IReadParams params) throws IOExceptionUnchecked {
        try {
            AdapterIInputStreamToInputStream input = new AdapterIInputStreamToInputStream((IInputStream)handle);
            ImageDecoder decoder = ImageCodec.createImageDecoder((String)this.getName(), (InputStream)input, null);
            RenderedImage renderedImage = decoder.decodeAsRenderedImage(imageID.getTimeSeriesIndex());
            return ImageConvertionUtils.convertToBufferedImage(renderedImage);
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
    }

    @Override
    public Dimension readDimensions(IRandomAccessFile handle, ImageID imageID) {
        try {
            AdapterIInputStreamToInputStream input = new AdapterIInputStreamToInputStream((IInputStream)handle);
            ImageDecoder decoder = ImageCodec.createImageDecoder((String)this.getName(), (InputStream)input, null);
            RenderedImage renderedImage = decoder.decodeAsRenderedImage(imageID.getTimeSeriesIndex());
            return new Dimension(renderedImage.getWidth(), renderedImage.getHeight());
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
    }

    @Override
    public Integer readColorDepth(IRandomAccessFile handle, ImageID imageID) {
        try {
            AdapterIInputStreamToInputStream input = new AdapterIInputStreamToInputStream((IInputStream)handle);
            ImageDecoder decoder = ImageCodec.createImageDecoder((String)this.getName(), (InputStream)input, null);
            RenderedImage renderedImage = decoder.decodeAsRenderedImage(imageID.getTimeSeriesIndex());
            return renderedImage.getColorModel().getPixelSize();
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
    }
}

