/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.imagereaders.jai;

import ch.systemsx.cisd.base.io.IRandomAccessFile;
import ch.systemsx.cisd.base.io.RandomAccessFileImpl;
import ch.systemsx.cisd.imagereaders.IImageReader;
import ch.systemsx.cisd.imagereaders.ImageID;
import ch.systemsx.cisd.imagereaders.ImageReaderTestCase;
import ch.systemsx.cisd.imagereaders.jai.JAIReaderLibrary;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import java.util.List;
import java.util.Map;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class DefaultImageReaderTest
extends ImageReaderTestCase {
    @Test
    public void testMultiPageTIFF() throws FileNotFoundException {
        JAIReaderLibrary library = new JAIReaderLibrary();
        String libraryName = library.getName();
        File imageFile = this.getImageFileForLibrary(libraryName, "multi-page.tif");
        IImageReader reader = library.tryGetReaderForFile(imageFile.getPath());
        List<ImageID> imageIDs = reader.getImageIDs(imageFile);
        DefaultImageReaderTest.assertEquals((String)"[0-0-0-0, 0-1-0-0]", (String)imageIDs.toString());
        Map<String, Object> metaData = reader.readMetaData(imageFile, imageIDs.get(0), null);
        DefaultImageReaderTest.assertEquals((int)0, (int)metaData.size());
        BufferedImage image0 = reader.readImage(imageFile, imageIDs.get(0), null);
        DefaultImageReaderTest.assertEquals((int)459, (int)image0.getWidth());
        DefaultImageReaderTest.assertEquals((int)435, (int)image0.getHeight());
        BufferedImage image1 = reader.readImage(imageFile, imageIDs.get(1), null);
        DefaultImageReaderTest.assertEquals((int)460, (int)image1.getWidth());
        DefaultImageReaderTest.assertEquals((int)437, (int)image1.getHeight());
        int depth = reader.readColorDepth((IRandomAccessFile)new RandomAccessFileImpl(new RandomAccessFile(imageFile, "r")), imageIDs.get(0));
        DefaultImageReaderTest.assertEquals((int)24, (int)depth);
    }

    @DataProvider(name="image-files")
    public Object[][] librariesToTest() {
        return new Object[][]{{"pond.bmp", 24}, {"pond.gif", 8}, {"pond.jpg", 24}, {"pond.png", 24}, {"pond.pgm", 8}, {"pond.tif", 24}, {"pond.ppm", 24}};
    }

    @Test(dataProvider="image-files")
    public void testSingleImageExamples(String imageFileName, int expectedDepth) throws FileNotFoundException {
        JAIReaderLibrary library = new JAIReaderLibrary();
        String libraryName = library.getName();
        File imageFile = this.getImageFileForLibrary(libraryName, imageFileName);
        IImageReader reader = library.tryGetReaderForFile(imageFile.getPath());
        List<ImageID> imageIDs = reader.getImageIDs(imageFile);
        DefaultImageReaderTest.assertEquals((String)"[0-0-0-0]", (String)imageIDs.toString());
        Map<String, Object> metaData = reader.readMetaData(imageFile, imageIDs.get(0), null);
        DefaultImageReaderTest.assertEquals((int)0, (int)metaData.size());
        BufferedImage image = reader.readImage(imageFile, imageIDs.get(0), null);
        DefaultImageReaderTest.assertEquals((int)512, (int)image.getWidth());
        DefaultImageReaderTest.assertEquals((int)384, (int)image.getHeight());
        int depth = reader.readColorDepth((IRandomAccessFile)new RandomAccessFileImpl(new RandomAccessFile(imageFile, "r")), imageIDs.get(0));
        DefaultImageReaderTest.assertEquals((int)expectedDepth, (int)depth);
    }
}

